/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.common.items;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.tardis.mod.common.dimensions.TDimensions;
import net.tardis.mod.common.items.ItemBase;
import net.tardis.mod.common.sounds.TSounds;
import net.tardis.mod.common.systems.SystemStabilizers;
import net.tardis.mod.common.tileentity.TileEntityTardis;
import net.tardis.mod.util.common.helpers.Helper;

public class ItemRemote
extends ItemBase {
    public ItemRemote() {
        this.func_77625_d(1);
    }

    public static BlockPos getConsolePos(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("console_pos")) {
            return BlockPos.func_177969_a((long)stack.func_77978_p().func_74763_f("console_pos"));
        }
        return BlockPos.field_177992_a;
    }

    public static void setConsolePos(ItemStack s, BlockPos pos) {
        if (s.func_77978_p() == null) {
            s.func_77982_d(new NBTTagCompound());
        }
        s.func_77978_p().func_74772_a("console_pos", pos.func_177986_g());
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tte;
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof TileEntityTardis) {
            ItemRemote.setConsolePos(player.func_184586_b(hand), pos);
            return EnumActionResult.SUCCESS;
        }
        if (!worldIn.field_72995_K && !ItemRemote.getConsolePos(player.func_184586_b(hand)).equals((Object)BlockPos.field_177992_a) && (tte = worldIn.func_73046_m().func_71218_a(TDimensions.TARDIS_ID).func_175625_s(ItemRemote.getConsolePos(player.func_184586_b(hand)))) != null && tte instanceof TileEntityTardis) {
            TileEntityTardis tardis = (TileEntityTardis)tte;
            tardis.getSystem(SystemStabilizers.class).setOn(true);
            tardis.setDesination(pos.func_177981_b(1), player.field_71093_bK);
            tardis.setFacing(player.func_174811_aO().func_176734_d());
            tardis.startFlight();
            worldIn.func_184133_a(null, pos, TSounds.remote_accept, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        return EnumActionResult.SUCCESS;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("console_pos")) {
            tooltip.add(new TextComponentTranslation("tooltip.remote", new Object[0]).func_150254_d() + " " + Helper.formatBlockPos(ItemRemote.getConsolePos(stack)));
            String format = stack.func_77978_p().func_74760_g("fuel") * 100.0f + "";
            tooltip.add(new TextComponentTranslation("tooltip.remote.fuel", new Object[0]).func_150254_d() + " " + format.substring(0, format.indexOf(".")) + "%");
            tooltip.add(new TextComponentTranslation("tooltip.remote.time", new Object[0]).func_150254_d() + " " + stack.func_77978_p().func_74762_e("time_left") / 20 + " " + new TextComponentTranslation("general.time.seconds", new Object[0]).func_150254_d());
            tooltip.add(new TextComponentTranslation("tooltip.remote.exteriorpos", new Object[0]).func_150254_d() + " " + Helper.formatBlockPos(BlockPos.func_177969_a((long)stack.func_77978_p().func_74763_f("tardis_position"))));
        } else {
            tooltip.add(new TextComponentTranslation("tooltip.remote.bind", new Object[0]).func_150254_d());
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        WorldServer ws;
        TileEntityTardis tardis;
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.field_72995_K && !ItemRemote.getConsolePos(stack).equals((Object)BlockPos.field_177992_a) && (tardis = (TileEntityTardis)(ws = worldIn.func_73046_m().func_71218_a(TDimensions.TARDIS_ID)).func_175625_s(ItemRemote.getConsolePos(stack))) != null && tardis.isInFlight()) {
            stack.func_77978_p().func_74776_a("fuel", tardis.getArtron());
            stack.func_77978_p().func_74768_a("time_left", tardis.getTimeLeft());
            stack.func_77978_p().func_74772_a("tardis_position", tardis.getLocation().func_177986_g());
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public static class NBT {
        public static final String POS = "tardis_position";
        public static final String TIME = "time_left";
        public static final String CONSOLE_POS = "console_pos";
        public static final String FUEL = "fuel";
    }
}

