/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.common.entities;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.client.CPacketVehicleMove;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tardis.mod.client.EnumExterior;
import net.tardis.mod.common.blocks.BlockTardis;
import net.tardis.mod.common.blocks.BlockTardisTop;
import net.tardis.mod.common.blocks.TBlocks;
import net.tardis.mod.common.dimensions.TDimensions;
import net.tardis.mod.common.entities.controls.ControlDoor;
import net.tardis.mod.common.enums.EnumFlightState;
import net.tardis.mod.common.tileentity.TileEntityDoor;
import net.tardis.mod.common.tileentity.TileEntityTardis;
import net.tardis.mod.util.TardisTeleporter;

public class EntityTardis
extends Entity {
    public static final DataParameter<Integer> OPEN_STATE = EntityDataManager.func_187226_a(EntityTardis.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> EXTERIOR = EntityDataManager.func_187226_a(EntityTardis.class, (DataSerializer)DataSerializers.field_187192_b);
    private BlockPos consolePos = BlockPos.field_177992_a;
    private int ticksOnGround = 0;
    private NBTTagCompound doorTag;
    private IBlockState state = TBlocks.tardis_top_tt.func_176223_P();

    public EntityTardis(World worldIn) {
        super(worldIn);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(OPEN_STATE, (Object)EnumFlightState.CLOSED.ordinal());
        this.field_70180_af.func_187214_a(EXTERIOR, (Object)Block.func_176210_f((IBlockState)TBlocks.tardis_top_tt.func_176223_P()));
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.consolePos = BlockPos.func_177969_a((long)compound.func_74763_f("console"));
        this.doorTag = compound.func_74775_l("door_tag");
        this.state = Block.func_176220_d((int)compound.func_74762_e("exterior_state"));
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74772_a("console", this.consolePos.func_177986_g());
        if (this.doorTag != null && !this.doorTag.func_82582_d()) {
            compound.func_74782_a("door_tag", (NBTBase)this.doorTag);
        }
        compound.func_74768_a("exterior_state", Block.func_176210_f((IBlockState)this.state));
    }

    public void func_70030_z() {
        TileEntity te;
        WorldServer tardisDimension;
        Entity entity;
        super.func_70030_z();
        this.move();
        if (this.func_184188_bt().size() > 0 && (entity = (Entity)this.func_184188_bt().get(0)) instanceof EntityLivingBase) {
            this.handleRider((EntityLivingBase)entity);
        }
        this.func_189654_d(!this.func_184188_bt().isEmpty());
        if (this.func_189652_ae()) {
            this.field_70177_z = (this.field_70177_z + 0.5f) % 360.0f;
        }
        if (!this.field_70170_p.field_72995_K && !BlockPos.field_177992_a.equals((Object)this.consolePos) && (tardisDimension = ((WorldServer)this.field_70170_p).func_73046_m().func_71218_a(TDimensions.TARDIS_ID)) != null && (te = tardisDimension.func_175625_s(this.getConsole())) instanceof TileEntityTardis) {
            ControlDoor intDoor;
            TileEntityTardis tardis = (TileEntityTardis)te;
            tardis.setLocation(this.func_180425_c());
            if (tardis.getTardisEntity() != this) {
                tardis.setTardisEntity(this);
            }
            if ((intDoor = tardis.getDoor()) != null && this.field_70173_aa % 20 == 0) {
                intDoor.func_184212_Q().func_187227_b(ControlDoor.FACING, (Object)Float.valueOf(this.field_70177_z));
                intDoor.setBotiUpdate(true);
                intDoor.func_184212_Q().func_187227_b(ControlDoor.MOTION, (Object)new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y));
            }
            if (this.field_70122_E) {
                ++this.ticksOnGround;
                if (this.ticksOnGround > 60) {
                    this.createDoorTile();
                    this.func_70106_y();
                }
            }
        }
        if (this.field_70170_p.field_72995_K && this.func_70055_a(Material.field_151586_h)) {
            for (int i = 0; i < 20; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t + Math.sin(Math.toRadians(i * 18)), this.field_70163_u, this.field_70161_v + Math.cos(Math.toRadians(i * 18)), 0.0, 0.5, 0.0, new int[]{0});
            }
        }
        if (this.field_70170_p.field_72995_K && this.func_70055_a(Material.field_151581_o)) {
            for (int i = 0; i < 20; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + Math.sin(Math.toRadians(i * 18)), this.field_70163_u, this.field_70161_v + Math.cos(Math.toRadians(i * 18)), 0.0, 0.5, 0.0, new int[]{0});
            }
        }
        if (this.field_70170_p.field_72995_K && this.field_70173_aa % 20 == 0) {
            this.state = Block.func_176220_d((int)((Integer)this.field_70180_af.func_187225_a(EXTERIOR)));
        }
    }

    public void move() {
        if (!this.field_70122_E && !this.func_189652_ae()) {
            this.field_70181_x -= 0.5;
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70159_w = 0.0;
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
    }

    public void handleRider(EntityLivingBase base) {
        Vec3d look = base.func_70040_Z().func_186678_a(0.3);
        if (base.field_191988_bg > 0.0f) {
            this.field_70159_w = look.field_72450_a;
            this.field_70179_y = look.field_72449_c;
        } else if (base.field_191988_bg < 0.0f) {
            this.field_70159_w = -look.field_72450_a;
            this.field_70179_y = -look.field_72449_c;
        }
        if (base.field_70702_br > 0.0f) {
            Vec3d move = look.func_178785_b(-80.0f);
            this.field_70159_w = move.field_72450_a;
            this.field_70179_y = move.field_72449_c;
        } else if (base.field_70702_br < 0.0f) {
            Vec3d move = look.func_178785_b(80.0f);
            this.field_70159_w = move.field_72450_a;
            this.field_70179_y = move.field_72449_c;
        }
        if (this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_184135_a((Packet)new CPacketVehicleMove((Entity)this));
        }
    }

    public void setConsole(BlockPos console) {
        this.consolePos = console;
    }

    public BlockPos getConsole() {
        return this.consolePos;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumExterior getExteriorEnum() {
        return EnumExterior.getExteriorFromBlock(this.state.func_177230_c());
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return true;
    }

    public void setOpenState(EnumFlightState state) {
        this.field_70180_af.func_187227_b(OPEN_STATE, (Object)state.ordinal());
    }

    public EnumFlightState getOpenState() {
        return EnumFlightState.values()[(Integer)this.field_70180_af.func_187225_a(OPEN_STATE)];
    }

    public double func_70042_X() {
        return 0.0;
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        double angle = Math.toRadians(-this.field_70177_z);
        double offsetX = Math.sin(angle) * 0.5;
        double offsetZ = Math.cos(angle) * 0.5;
        passenger.func_70107_b(this.field_70165_t + offsetX, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), this.field_70161_v + offsetZ);
        passenger.field_70143_R = 0.0f;
    }

    protected void func_184225_p(final Entity pass) {
        super.func_184225_p(pass);
        if (!this.field_70170_p.field_72995_K) {
            if (this.getOpenState() == EnumFlightState.CLOSED) {
                ((WorldServer)this.field_70170_p).func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        WorldServer tardisWorld = ((WorldServer)EntityTardis.this.field_70170_p).func_73046_m().func_71218_a(TDimensions.TARDIS_ID);
                        if (tardisWorld != null) {
                            BlockPos pos = EntityTardis.this.getConsole().func_177968_d();
                            pass.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                            if (pass instanceof EntityPlayerMP) {
                                EntityTardis.this.field_70170_p.func_73046_m().func_184103_al().transferPlayerToDimension((EntityPlayerMP)pass, TDimensions.TARDIS_ID, (ITeleporter)new TardisTeleporter());
                            }
                        }
                    }
                });
            } else {
                double x = Math.sin(Math.toRadians(this.field_70177_z));
                double z = Math.cos(Math.toRadians(this.field_70177_z));
                pass.func_70107_b(this.field_70165_t + z, this.field_70163_u, this.field_70161_v + z);
            }
        }
    }

    public IBlockState getBlockState() {
        return this.state;
    }

    public void setBlockState(IBlockState state) {
        this.state = state;
        this.field_70180_af.func_187227_b(EXTERIOR, (Object)Block.func_176210_f((IBlockState)state));
    }

    public TileEntityDoor createDoorTile() {
        if (this.state == null || !(this.state.func_177230_c() instanceof BlockTardis)) {
            this.func_70106_y();
            return null;
        }
        this.field_70170_p.func_175656_a(this.func_180425_c().func_177984_a(), this.getBlockState().func_177226_a((IProperty)BlockTardisTop.FACING, (Comparable)this.func_174811_aO()));
        this.field_70170_p.func_175656_a(this.func_180425_c(), TBlocks.tardis.func_176223_P());
        TileEntity te = this.field_70170_p.func_175625_s(this.func_180425_c().func_177984_a());
        if (te instanceof TileEntityDoor && this.doorTag != null && !this.doorTag.func_82582_d()) {
            ((TileEntityDoor)te).deserializeNBT(this.doorTag);
            te.func_174878_a(this.func_180425_c().func_177984_a());
        }
        return (TileEntityDoor)te;
    }

    public void setTag(NBTTagCompound tag) {
        this.doorTag = tag;
    }
}

