/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.common.entities;

import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.tardis.mod.api.entities.IDontSufficate;
import net.tardis.mod.common.dimensions.TDimensions;
import net.tardis.mod.common.items.TItems;
import net.tardis.mod.common.tileentity.TileEntityDoor;

public class EntityCyberman
extends EntityMob
implements IDontSufficate {
    public EntityCyberman(World worldIn) {
        super(worldIn);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveToTARDIS(this, 1.0));
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        ItemStack[] drops;
        for (ItemStack s : drops = new ItemStack[]{new ItemStack(TItems.circuts, 1 + lootingModifier)}) {
            if (this.field_70170_p.field_72995_K) continue;
            InventoryHelper.func_180173_a((World)this.field_70170_p, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (ItemStack)s);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        EntityPlayer player;
        if (source != null && source.func_76346_g() instanceof EntityPlayer && !source.func_76352_a() && (player = (EntityPlayer)source.func_76346_g()).func_184614_ca().func_77973_b() == Items.field_151010_B) {
            amount *= 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public static class EntityAIMoveToTARDIS
    extends EntityAIBase {
        double speed;
        EntityMob entity;
        Vec3d pos;
        BlockPos doorPos = BlockPos.field_177992_a;

        public EntityAIMoveToTARDIS(EntityMob base, double speed) {
            this.entity = base;
            this.speed = speed;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            return this.entity.func_70638_az() == null;
        }

        public boolean func_75253_b() {
            if (this.entity.field_71093_bK == TDimensions.TARDIS_ID) {
                return false;
            }
            for (TileEntity te : this.entity.field_70170_p.field_147482_g) {
                if (!(te instanceof TileEntityDoor)) continue;
                Vec3d tePos = new Vec3d((double)te.func_174877_v().func_177958_n(), (double)te.func_174877_v().func_177956_o(), (double)te.func_174877_v().func_177952_p());
                double dist = this.entity.func_174791_d().func_72438_d(tePos);
                if (!(dist < 30.0)) continue;
                this.pos = tePos;
                this.doorPos = te.func_174877_v();
                return true;
            }
            return false;
        }

        public boolean func_75252_g() {
            return true;
        }

        public void func_75249_e() {
            super.func_75249_e();
        }

        public void func_75246_d() {
            if (this.pos != null) {
                TileEntityDoor door;
                if (this.entity.func_174791_d().func_72438_d(this.pos) > 1.5) {
                    this.entity.func_70605_aq().func_75642_a(this.pos.field_72450_a, this.pos.field_72448_b, this.pos.field_72449_c, this.speed);
                } else if (this.doorPos != null && this.entity.field_70173_aa % 20 == 0 && (door = (TileEntityDoor)this.entity.field_70170_p.func_175625_s(this.doorPos)) != null) {
                    door.knock();
                }
            }
        }
    }
}

