/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.common.dimensions;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.tardis.mod.common.dimensions.WorldProviderTardis;
import net.tardis.mod.common.dimensions.gallifrey.WorldProviderGallifrey;
import net.tardis.mod.common.dimensions.gallifrey.biomes.BiomeMountains;
import net.tardis.mod.common.dimensions.gallifrey.biomes.BiomeRedlands;
import net.tardis.mod.common.dimensions.gallifrey.biomes.BiomeWastelands;
import net.tardis.mod.common.dimensions.moon.BiomeMoon;
import net.tardis.mod.common.dimensions.moon.MoonProvider;
import net.tardis.mod.common.dimensions.space.SpaceProvider;
import net.tardis.mod.common.dimensions.telos.BiomeTelos;
import net.tardis.mod.common.dimensions.telos.WorldProviderTelos;
import net.tardis.mod.config.TardisConfig;

public class TDimensions {
    public static int TARDIS_ID;
    public static DimensionType DIMTYPE_TARDIS;
    public static int MOON_ID;
    public static DimensionType MOON_TYPE;
    public static Biome BIOME_MOON;
    public static int SPACE_ID;
    public static DimensionType DIMTYPE_SPACE;
    public static int TELOS_ID;
    public static DimensionType DIMTYPE_TELOS;
    public static Biome BIOME_TELOS;
    public static Biome BIOME_TELOS_ORANGE;
    public static int GALLIFREY_ID;
    public static DimensionType GALLIFREY_TYPE;
    public static Biome BIOME_GALLIFREY_REDLANDS;
    public static Biome BIOME_GALLIFREY_FARMLAND;
    public static Biome BIOME_GALLIFREY_MOUNTAIN;

    public static void register() {
        boolean setDim = TardisConfig.Dimensions.setDimension;
        TARDIS_ID = setDim ? TardisConfig.Dimensions.tardisDimension : DimensionManager.getNextFreeDimId();
        DIMTYPE_TARDIS = DimensionType.register((String)"tardis", (String)"_tardis", (int)TARDIS_ID, WorldProviderTardis.class, (boolean)false);
        DimensionManager.registerDimension((int)TARDIS_ID, (DimensionType)DIMTYPE_TARDIS);
        SPACE_ID = setDim ? TardisConfig.Dimensions.spaceDimension : DimensionManager.getNextFreeDimId();
        DIMTYPE_SPACE = DimensionType.register((String)"space", (String)"_space", (int)SPACE_ID, SpaceProvider.class, (boolean)false);
        DimensionManager.registerDimension((int)SPACE_ID, (DimensionType)DIMTYPE_SPACE);
        TELOS_ID = setDim ? TardisConfig.Dimensions.telosDimension : DimensionManager.getNextFreeDimId();
        DIMTYPE_TELOS = DimensionType.register((String)"telos", (String)"_telos", (int)TELOS_ID, WorldProviderTelos.class, (boolean)false);
        DimensionManager.registerDimension((int)TELOS_ID, (DimensionType)DIMTYPE_TELOS);
        MOON_ID = setDim ? TardisConfig.Dimensions.moonDimension : DimensionManager.getNextFreeDimId();
        MOON_TYPE = DimensionType.register((String)"moon", (String)"_moon", (int)MOON_ID, MoonProvider.class, (boolean)false);
        DimensionManager.registerDimension((int)MOON_ID, (DimensionType)MOON_TYPE);
        GALLIFREY_ID = setDim ? TardisConfig.Dimensions.gallifreyDimension : DimensionManager.getNextFreeDimId();
        GALLIFREY_TYPE = DimensionType.register((String)"gallifrey", (String)"_gallifrey", (int)GALLIFREY_ID, WorldProviderGallifrey.class, (boolean)false);
        DimensionManager.registerDimension((int)GALLIFREY_ID, (DimensionType)GALLIFREY_TYPE);
    }

    static {
        BIOME_MOON = new BiomeMoon();
        BIOME_TELOS = new BiomeTelos(true);
        BIOME_TELOS_ORANGE = new BiomeTelos(false);
        BIOME_GALLIFREY_REDLANDS = new BiomeRedlands();
        BIOME_GALLIFREY_FARMLAND = new BiomeWastelands();
        BIOME_GALLIFREY_MOUNTAIN = new BiomeMountains();
    }

    @Mod.EventBusSubscriber(modid="tardis")
    public static class BiomeReg {
        private static List<Biome> BIOMES = new ArrayList<Biome>();

        @SubscribeEvent
        public static void register(RegistryEvent.Register<Biome> event) {
            BIOMES.forEach(biome -> event.getRegistry().register((IForgeRegistryEntry)biome));
        }

        public static void registerBiome(Biome b, String name, BiomeDictionary.Type type) {
            b.setRegistryName(new ResourceLocation("tardis", name));
            BIOMES.add(b);
        }

        public static void init() {
            BiomeReg.registerBiome(BIOME_TELOS, "telos", BiomeDictionary.Type.SNOWY);
            BiomeReg.registerBiome(BIOME_TELOS_ORANGE, "telos_orange", BiomeDictionary.Type.SNOWY);
            BiomeReg.registerBiome(BIOME_MOON, "moon", BiomeDictionary.Type.COLD);
            BiomeReg.registerBiome(BIOME_GALLIFREY_REDLANDS, "redlands", BiomeDictionary.Type.PLAINS);
            BiomeReg.registerBiome(BIOME_GALLIFREY_FARMLAND, "farmlands", BiomeDictionary.Type.PLAINS);
            BiomeReg.registerBiome(BIOME_GALLIFREY_MOUNTAIN, "mountains", BiomeDictionary.Type.SNOWY);
        }
    }
}

