/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.common.commands.subcommands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.tardis.mod.common.commands.TardisCommand;
import net.tardis.mod.common.commands.subcommands.CommandTemplate;
import net.tardis.mod.common.dimensions.TDimensions;
import net.tardis.mod.common.systems.TardisSystems;
import net.tardis.mod.common.tileentity.TileEntityTardis;
import net.tardis.mod.util.common.helpers.TardisHelper;

public class CommandRestoresys
extends CommandTemplate {
    public CommandRestoresys(TardisCommand parent, @Nullable String permission) {
        super(parent, permission);
    }

    public String func_71517_b() {
        return "restoresys";
    }

    @Override
    public String func_71518_a(ICommandSender sender) {
        return super.func_71518_a(sender) + " <username> <system...s>";
    }

    @Override
    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return super.func_184882_a(server, sender) || sender instanceof MinecraftServer;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 2) {
            throw new CommandException(this.func_71518_a(sender), new Object[0]);
        }
        int j = 0;
        if (!Arrays.asList(server.func_71213_z()).contains(args[j])) {
            throw new CommandException(this.func_71518_a(sender), new Object[0]);
        }
        EntityPlayerMP player = server.func_184103_al().func_152612_a(args[j++]);
        ArrayList<Object> systemNames = new ArrayList();
        if (args[j].equals("*")) {
            systemNames = TardisSystems.getSystemsnames();
        } else {
            for (int i = j; i < args.length; ++i) {
                systemNames.add(args[i]);
            }
        }
        this.restoreSystem(player, player.func_110124_au(), systemNames.toArray(new String[0]));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void restoreSystem(EntityPlayerMP player, @Nullable UUID id, String ... names) throws CommandException {
        ArrayList<TardisSystems.BaseSystem> systemBases = new ArrayList<TardisSystems.BaseSystem>();
        UUID owner = id == null ? player.func_110124_au() : id;
        for (String s : names) {
            TardisSystems.BaseSystem system = TardisSystems.createFromName(s);
            if (system != null) {
                systemBases.add(system);
                continue;
            }
            player.func_145747_a((ITextComponent)new TextComponentString(s + ": " + new TextComponentTranslation("command.tardis.nosystem", new Object[0]).func_150254_d()));
        }
        if (!TardisHelper.hasTardis(owner)) throw new CommandException("command.no_tardis_owned", new Object[0]);
        TileEntityTardis tardis = (TileEntityTardis)player.func_71121_q().func_73046_m().func_71218_a(TDimensions.TARDIS_ID).func_175625_s(TardisHelper.getTardis(owner));
        if (tardis == null) throw new CommandException("command.tardis.notinworld", new Object[0]);
        for (TardisSystems.BaseSystem system : systemBases) {
            ((TardisSystems.BaseSystem)tardis.getSystem(system.getClass())).setHealth(1.0f);
            player.func_146105_b((ITextComponent)new TextComponentString(new TextComponentTranslation(system.getNameKey(), new Object[0]).func_150254_d() + " : " + new TextComponentTranslation("commands.tardis.system_restored", new Object[0]).func_150254_d()), false);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length <= 1) {
            return Arrays.asList(server.func_71213_z());
        }
        ArrayList<String> systemNames = TardisSystems.getSystemsnames();
        systemNames.add("*");
        return CommandRestoresys.func_175762_a((String[])args, systemNames);
    }
}

