/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.common.blocks;

import com.google.common.base.Predicate;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.tardis.mod.common.blocks.BlockTileBase;
import net.tardis.mod.common.blocks.TBlocks;
import net.tardis.mod.common.blocks.interfaces.IRenderBox;
import net.tardis.mod.common.dimensions.TDimensions;
import net.tardis.mod.common.items.TItems;
import net.tardis.mod.common.sounds.TSounds;
import net.tardis.mod.common.systems.SystemDimension;
import net.tardis.mod.common.systems.TardisSystems;
import net.tardis.mod.common.tileentity.TileEntityDoor;
import net.tardis.mod.common.tileentity.TileEntityTardis;

public class BlockTardisTop
extends BlockTileBase
implements IRenderBox {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public ItemBlock item = new ItemBlockTardis(this);

    public BlockTardisTop(Supplier<TileEntity> tileEntity) {
        super(Material.field_151575_d, tileEntity);
        this.func_149722_s();
        this.func_149752_b(9999.0f);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public ItemBlock getItem() {
        return this.item;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            TileEntityDoor door = (TileEntityDoor)worldIn.func_175625_s(pos);
            door.toggleLocked(playerIn);
            WorldServer ws = worldIn.func_73046_m().func_71218_a(TDimensions.TARDIS_ID);
            TileEntity te = ws.func_175625_s(door.getConsolePos());
            if (te != null && te instanceof TileEntityTardis) {
                ItemStack held = playerIn.func_184586_b(hand);
                SystemDimension dim = null;
                if (held.func_77973_b() == TItems.time_vector_generator) {
                    for (TardisSystems.BaseSystem s : ((TileEntityTardis)te).systems) {
                        if (s.getClass() != SystemDimension.class) continue;
                        dim = (SystemDimension)s;
                    }
                }
                if (dim != null) {
                    dim.repair(held);
                    held.func_190918_g(1);
                }
            }
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        WorldServer tWorld;
        TileEntityTardis tardis;
        if (!worldIn.field_72995_K && (tardis = (TileEntityTardis)(tWorld = worldIn.func_73046_m().func_71218_a(TDimensions.TARDIS_ID)).func_175625_s(((TileEntityDoor)worldIn.func_175625_s(pos)).getConsolePos())) != null) {
            tWorld.func_184133_a(null, tardis.func_174877_v(), TSounds.knocking, SoundCategory.BLOCKS, 1.0f, 1.0f);
            worldIn.func_184133_a(null, tardis.func_174877_v(), TSounds.knocking, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        super.func_180649_a(worldIn, pos, playerIn);
    }

    public boolean func_176209_a(IBlockState state, boolean hitIfLiquid) {
        return true;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        try {
            if (!worldIn.field_72995_K) {
                worldIn.func_184133_a(null, pos, TSounds.tardis_land, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    @Override
    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return false;
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return ItemStack.field_190927_a;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityDoor door;
        if (world.func_175625_s(pos) instanceof TileEntityDoor && (door = (TileEntityDoor)world.func_175625_s(pos)) != null && !door.isLocked()) {
            return door.getLightLevel();
        }
        return super.getLightValue(state, world, pos);
    }

    @Override
    public boolean shouldRenderBox() {
        return false;
    }

    public static class ItemBlockTardis
    extends ItemBlock {
        public ItemBlockTardis(Block block) {
            super(block);
        }

        public String func_77653_i(ItemStack stack) {
            return new TextComponentTranslation(TBlocks.tardis_top.func_149739_a() + ".name", new Object[0]).func_150254_d();
        }
    }
}

