/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.cap;

import java.text.DecimalFormat;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.tardis.mod.cap.ITardisTracker;
import net.tardis.mod.common.dimensions.TDimensions;
import net.tardis.mod.common.systems.TardisSystems;
import net.tardis.mod.common.tileentity.TileEntityTardis;
import net.tardis.mod.util.common.helpers.Helper;
import net.tardis.mod.util.common.helpers.PlayerHelper;

public class TardisTrackerCapability
implements ITardisTracker {
    public static final DecimalFormat FORMAT = new DecimalFormat("##.#");
    BlockPos consolePos;
    TileEntityTardis console;

    @Override
    public void setConsole(BlockPos pos) {
        this.consolePos = pos.func_185334_h();
    }

    @Override
    public BlockPos getConsolePos() {
        return this.consolePos;
    }

    @Override
    public TileEntityTardis getConsole() {
        return this.console;
    }

    @Override
    @Nullable
    public BlockPos getExteriorPos() {
        if (this.consolePos == null) {
            return null;
        }
        if (this.console == null) {
            this.findConsoleInstance();
        }
        if (this.console == null) {
            return null;
        }
        return this.console.getLocation();
    }

    @Override
    public void deserialize(NBTTagCompound tag) {
        this.consolePos = BlockPos.func_177969_a((long)tag.func_74763_f("console"));
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        if (this.consolePos != null) {
            tag.func_74772_a("console", this.consolePos.func_177986_g());
        }
        return tag;
    }

    @Override
    public void findConsoleInstance() {
        TileEntity te;
        if (this.consolePos == null) {
            return;
        }
        WorldServer ws = DimensionManager.getWorld((int)TDimensions.TARDIS_ID);
        if (ws != null && (te = ws.func_175625_s(this.consolePos)) instanceof TileEntityTardis) {
            this.console = (TileEntityTardis)te;
        }
    }

    @Override
    public void onRightClick(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        TileEntityTardis console = this.getConsole();
        if (console != null) {
            for (TardisSystems.BaseSystem sub : console.systems) {
                PlayerHelper.sendMessage(playerIn, (ITextComponent)new TextComponentString(new TextComponentTranslation(sub.getNameKey(), new Object[0]).func_150254_d() + " " + FORMAT.format(sub.getHealth() * 100.0f) + "%"), false);
            }
            PlayerHelper.sendMessage(playerIn, (ITextComponent)new TextComponentTranslation("tooltip.tardis.tracker.exterior", new Object[]{Helper.formatBlockPos(console.getLocation()), console.dimension}), false);
        } else {
            PlayerHelper.sendMessage(playerIn, "Remote not bound!", true);
        }
    }
}

