/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.api.disguise;

import java.util.HashMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.tardis.mod.util.common.helpers.EntityHelper;

public class DisguiseRegistry {
    public static final ResourceLocation CACTUS = new ResourceLocation("tardis", "shells/cactus.json");
    public static final ResourceLocation TREE = new ResourceLocation("tardis", "shells/tree.json");
    public static final ResourceLocation MUSHROOM = new ResourceLocation("tardis", "shells/mushroom.json");
    public static HashMap<String, ResourceLocation> DISGUISES = new HashMap();

    public static void registerDisguise(String biomeName, ResourceLocation disguiseLoc) {
        DISGUISES.put(biomeName, disguiseLoc);
    }

    public static void registerDisguiseAllBiomes(String name, ResourceLocation disguiseLoc) {
        for (Biome b : EntityHelper.biomes) {
            if (!b.getRegistryName().toString().contains(name)) continue;
            DISGUISES.put(b.getRegistryName().toString(), disguiseLoc);
        }
    }

    public static ResourceLocation getDisguise(String name) {
        for (String biome : DISGUISES.keySet()) {
            if (!biome.equals(name)) continue;
            return DISGUISES.get(name);
        }
        return null;
    }

    public static void init() {
        DisguiseRegistry.registerDisguiseAllBiomes("desert", CACTUS);
        DisguiseRegistry.registerDisguiseAllBiomes("plains", TREE);
        DisguiseRegistry.registerDisguiseAllBiomes("forest", TREE);
        DisguiseRegistry.registerDisguiseAllBiomes("mushroom", MUSHROOM);
    }
}

