/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.event;

import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.silentchaos512.lib.SilentLib;
import net.silentchaos512.lib.advancements.LibTriggers;
import net.silentchaos512.lib.advancements.UseItemTrigger;
import net.silentchaos512.lib.item.ItemGuideBookSL;
import net.silentchaos512.lib.util.PlayerHelper;

public final class SilentLibCommonEvents {
    private static final String NBT_ROOT_GUIDE_BOOKS = "silentlib_guide_books";

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        NBTTagCompound guideData = PlayerHelper.getPersistedDataSubcompound(player, NBT_ROOT_GUIDE_BOOKS);
        int id = 0;
        ItemGuideBookSL item = ItemGuideBookSL.getBookById(id);
        while (item != null && item.giveBookOnFirstLogin) {
            ResourceLocation name = Objects.requireNonNull(item.getRegistryName());
            if (!guideData.func_74767_n(name.toString())) {
                guideData.func_74757_a(name.toString(), true);
                PlayerHelper.giveItem(player, new ItemStack((Item)item));
                SilentLib.LOGGER.info("Player has been given guide book {}", (Object)name);
            }
            item = ItemGuideBookSL.getBookById(++id);
        }
    }

    @SubscribeEvent
    public void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntityPlayer() instanceof EntityPlayerMP) {
            LibTriggers.USE_ITEM.trigger((EntityPlayerMP)event.getEntityPlayer(), event.getItemStack(), UseItemTrigger.Target.BLOCK);
        }
    }

    @SubscribeEvent
    public void onPlayerRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        if (event.getEntityPlayer() instanceof EntityPlayerMP) {
            LibTriggers.USE_ITEM.trigger((EntityPlayerMP)event.getEntityPlayer(), event.getItemStack(), UseItemTrigger.Target.ENTITY);
        }
    }

    @SubscribeEvent
    public void onPlayerRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (event.getEntityPlayer() instanceof EntityPlayerMP) {
            LibTriggers.USE_ITEM.trigger((EntityPlayerMP)event.getEntityPlayer(), event.getItemStack(), UseItemTrigger.Target.ITEM);
        }
    }
}

