/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rscpl.gui;

import cd4017be.lib.Gui.comp.GuiCompBase;
import cd4017be.lib.Gui.comp.GuiCompGroup;
import cd4017be.lib.Gui.comp.GuiFrame;
import cd4017be.rscpl.editor.BoundingBox2D;
import cd4017be.rscpl.editor.Gate;
import cd4017be.rscpl.editor.GateType;
import cd4017be.rscpl.editor.Pin;
import cd4017be.rscpl.editor.Schematic;
import cd4017be.rscpl.gui.GateTextureHandler;
import cd4017be.rscpl.gui.ISpecialRender;
import cd4017be.rscpl.gui.PinRef;
import cd4017be.rscpl.gui.TraceColors;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class SchematicBoard
extends GuiCompBase<GuiFrame> {
    private static final byte A_MOVE_TRACE = 1;
    private static final byte A_SELECTING = 2;
    private static final byte A_MOVE_AREA = 3;
    private final Schematic schematic;
    private final Runnable update;
    public final ArrayList<BoundingBox2D<Gate>> parts = new ArrayList();
    public final Int2ObjectOpenHashMap<PinRef> pins = new Int2ObjectOpenHashMap();
    public TraceColors colors = TraceColors.DEFAULT;
    public BoundingBox2D<Gate> selPart;
    int originX;
    int originY;
    int moveX;
    int moveY;
    byte curAction;
    PinRef selPin;
    private Gate placing;

    public SchematicBoard(GuiFrame parent, int x, int y, Schematic schematic, Runnable update) {
        super((GuiCompGroup)parent, schematic.BOARD_AREA.width() + 1 << 2, schematic.BOARD_AREA.height() << 2, x, y);
        this.schematic = schematic;
        this.update = update;
    }

    public void update() {
        if (!this.schematic.modified) {
            return;
        }
        this.parts.clear();
        this.pins.clear();
        for (Gate g : this.schematic.operators) {
            PinRef pin;
            int i;
            if (g == null) continue;
            this.parts.add(g.getBounds());
            for (i = g.outputs.length - 1; i >= 0; --i) {
                pin = new PinRef(g.outputs[i]);
                this.pins.putIfAbsent((Object)pin.hashCode(), (Object)pin);
            }
            for (i = g.inputCount() - 1; i >= 0; --i) {
                pin = new PinRef(g, i);
                while (pin != null) {
                    this.pins.merge((Object)pin.hashCode(), (Object)pin, (o, n) -> o.trace < 0 || n.trace < o.trace ? n : o);
                    pin = pin.link;
                }
            }
        }
        for (PinRef pin : this.pins.values()) {
            PinRef other;
            if (pin.link == null) continue;
            PinRef link = pin.link;
            while (link.link != null && link != (other = (PinRef)this.pins.get(link.hashCode())) && !this.commonSource(link, other)) {
                pin.link = link = link.link;
            }
        }
        if (this.selPart != null && this.selPart.owner != null) {
            Gate op = this.schematic.get(((Gate)this.selPart.owner).index);
            this.selPart = op == null ? null : op.getBounds();
            this.update.run();
        }
        this.schematic.modified = false;
    }

    public void drawBackground(int mx, int my, float t) {
        BoundingBox2D<Gate> part;
        ((GuiFrame)this.parent).bindTexture(((GuiFrame)this.parent).mainTex);
        ((GuiFrame)this.parent).gui.field_146297_k.field_71446_o.func_110577_a(GateTextureHandler.GATE_ICONS_LOC);
        if (!GuiScreen.func_175283_s()) {
            for (BoundingBox2D<Gate> boundingBox2D : this.parts) {
                this.drawPart(boundingBox2D);
            }
        }
        if (this.placing != null) {
            this.placing.setPosition((mx - this.x) / 4, (my - this.y) / 4);
            part = this.placing.getBounds();
            this.drawPart(part);
        }
        ((GuiFrame)this.parent).drawNow();
        ((GuiFrame)this.parent).bindTexture(null);
        this.drawWires(mx, my);
        if (this.placing != null) {
            part = this.placing.getBounds();
            for (BoundingBox2D<Gate> boundingBox2D : this.parts) {
                if (!part.overlapsWith(boundingBox2D)) continue;
                this.drawSelection(boundingBox2D, -2130771968);
            }
        } else if (this.selPart != null) {
            boolean bl;
            part = this.selPart;
            boolean bl2 = bl = part.owner == null && this.curAction == 3;
            if (bl) {
                this.moveX = (mx - this.x - 2) / 4 - this.originX;
                this.moveY = (my - this.y) / 4 - this.originY;
            }
            if (bl || this.moveX != 0 || this.moveY != 0) {
                BoundingBox2D<Gate> boundingBox2D = part.offset(this.moveX, this.moveY);
                for (BoundingBox2D<Gate> p : this.parts) {
                    if (bl && part.overlapsWith(p)) {
                        this.drawSelection(p.offset(this.moveX, this.moveY), -2134867968);
                        continue;
                    }
                    if (!boundingBox2D.overlapsWith(p)) continue;
                    this.drawSelection(p, -2130771968);
                }
                part = boundingBox2D;
            }
            this.drawSelection(part, part.enclosedBy(this.schematic.BOARD_AREA) ? (part.owner == null ? -2147483393 : -2134867968) : -65536);
        } else if (this.curAction == 2) {
            BoundingBox2D<Object> box = new BoundingBox2D<Object>(null, this.originX + Math.min(0, this.moveX), this.originY + Math.min(0, this.moveY), Math.abs(this.moveX), Math.abs(this.moveY));
            this.drawSelection(box, -2147418368);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawWires(int mx, int my) {
        GlStateManager.func_179090_x();
        BufferBuilder vb = Tessellator.func_178181_a().func_178180_c();
        vb.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        int a = 255;
        float z = ((GuiFrame)this.parent).zLevel + 0.5f;
        for (PinRef pin : this.pins.values()) {
            boolean sel = pin.equals(this.selPin);
            PinRef link = pin.link;
            if (link == null && (!sel || this.curAction == 1)) continue;
            int b = this.colors.color(this.schematic.get(pin.gate), pin.pin);
            int r = b >> 16 & 0xFF;
            int g = b >> 8 & 0xFF;
            b &= 0xFF;
            if (this.curAction == 1 && sel) {
                vb.func_181662_b((double)mx + 0.5, (double)my + 0.5, (double)z).func_181669_b(r, g, b, a).func_181675_d();
            } else {
                vb.func_181662_b((double)(this.x + pin.x * 4) + 2.5, (double)(this.y + pin.y * 4) + 2.5, (double)z).func_181669_b(r, g, b, a).func_181675_d();
            }
            if (this.curAction == 1 ? link.equals(this.selPin) : sel) {
                vb.func_181662_b((double)mx + 0.5, (double)my + 0.5, (double)z).func_181669_b(r, g, b, a).func_181675_d();
                continue;
            }
            vb.func_181662_b((double)(this.x + link.x * 4) + 2.5, (double)(this.y + link.y * 4) + 2.5, (double)z).func_181669_b(r, g, b, a).func_181675_d();
        }
        GlStateManager.func_187441_d((float)((float)((GuiFrame)this.parent).gui.field_146297_k.field_71440_d / (float)((GuiFrame)this.parent).gui.field_146295_m));
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179098_w();
    }

    private void drawPart(BoundingBox2D<Gate> part) {
        Gate node = (Gate)part.owner;
        int x = this.x + 2 + part.x0 * 4;
        int y = this.y + part.y0 * 4;
        GateTextureHandler.drawIcon(((GuiFrame)this.parent).getDraw(), x, y, part.width() * 4, part.height() * 4, ((Gate)part.owner).type.getIcon(), ((GuiFrame)this.parent).zLevel + 1.0f);
        if (node instanceof ISpecialRender) {
            ((ISpecialRender)((Object)node)).draw(this, x, y);
        }
    }

    private void drawSelection(BoundingBox2D<Gate> part, int c) {
        int x0 = this.x + 2 + part.x0 * 4;
        int x1 = this.x + 2 + part.x1 * 4;
        int y0 = this.y + part.y0 * 4;
        int y1 = this.y + part.y1 * 4;
        Gui.func_73734_a((int)x0, (int)y0, (int)x1, (int)(y0 + 1), (int)c);
        Gui.func_73734_a((int)(x0 + 1), (int)y1, (int)(x1 + 1), (int)(y1 + 1), (int)c);
        Gui.func_73734_a((int)x0, (int)(y0 + 1), (int)(x0 + 1), (int)(y1 + 1), (int)c);
        Gui.func_73734_a((int)x1, (int)y0, (int)(x1 + 1), (int)y1, (int)c);
    }

    public void drawOverlay(int mx, int my) {
        PinRef pin;
        int px = (mx - this.x - 1) / 4;
        int py = (my - this.y) / 4;
        BoundingBox2D<Gate> part = this.findPart((mx - this.x - 2) / 4, (my - this.y) / 4);
        if (part != null) {
            ((GuiFrame)this.parent).drawTooltip(((Gate)part.owner).label, mx, my);
        }
        if ((pin = (PinRef)this.pins.get(px & 0xFFFF | py << 16)) == null) {
            return;
        }
        Gate g = this.schematic.get(pin.gate);
        if (g == null) {
            return;
        }
        int c = pin.trace == 0 ? this.colors.color(g.type.getInType(pin.pin)) : (pin.trace == -1 ? this.colors.color(g.type.getOutType(pin.pin)) : this.colors.color(g, pin.pin));
        mx = pin.x * 4 + this.x + 1;
        my = pin.y * 4 + this.y + 1;
        RenderHelper.func_74518_a();
        GlStateManager.func_179097_i();
        Gui.func_73734_a((int)mx, (int)my, (int)(mx + 3), (int)(my + 3), (int)(0xBF000000 | c));
    }

    public boolean mouseIn(int mx, int my, int b, byte d) {
        my = (my - this.y) / 4;
        switch (b) {
            case 0: {
                mx = (mx - this.x - 2) / 4;
                if (this.placing != null && d != 1) {
                    ((GuiFrame)this.parent).gui.sendPkt(new Object[]{(byte)0, (byte)this.schematic.INS_SET.id(this.placing.type), (byte)mx, (byte)my});
                    this.placing = null;
                    break;
                }
                if (d == 0) {
                    if (this.curAction == 3 && this.selPart != null) {
                        if (!this.selPart.offset(this.moveX, this.moveY).enclosedBy(this.schematic.BOARD_AREA)) {
                            ((GuiFrame)this.parent).gui.sendPkt(new Object[]{(byte)12, (byte)this.selPart.x0, (byte)this.selPart.y0, (byte)this.selPart.width(), (byte)this.selPart.height(), (byte)0, (byte)0});
                        } else if (this.moveX != 0 || this.moveY != 0) {
                            ((GuiFrame)this.parent).gui.sendPkt(new Object[]{(byte)12, (byte)this.selPart.x0, (byte)this.selPart.y0, (byte)this.selPart.width(), (byte)this.selPart.height(), (byte)this.moveX, (byte)this.moveY});
                        }
                        this.selPart = null;
                        this.curAction = 0;
                        break;
                    }
                    this.selPart = GuiScreen.func_175283_s() ? null : this.findPart(mx, my);
                    this.update.run();
                    this.originX = mx;
                    this.originY = my;
                } else if (d == 1 && this.selPart == null) {
                    this.curAction = (byte)2;
                } else if (d == 2) {
                    if (this.curAction == 2) {
                        if (this.moveX != 0 && this.moveY != 0) {
                            this.selPart = new BoundingBox2D<Object>(null, this.originX + Math.min(0, this.moveX), this.originY + Math.min(0, this.moveY), Math.abs(this.moveX), Math.abs(this.moveY));
                            this.curAction = (byte)3;
                        } else {
                            this.curAction = 0;
                        }
                        this.originX = mx;
                        this.originY = my;
                    } else {
                        this.unfocus();
                    }
                }
                this.moveX = mx - this.originX;
                this.moveY = my - this.originY;
                break;
            }
            case 1: {
                mx = (mx - this.x - 1) / 4;
                if (d == 0) {
                    if (this.curAction == 3) {
                        this.curAction = 0;
                        this.selPart = null;
                        break;
                    }
                    PinRef pin = (PinRef)this.pins.get(mx & 0xFFFF | my << 16);
                    if (this.selPin == null) {
                        if (pin == null || pin.trace < 0) break;
                        this.selPin = pin;
                        break;
                    }
                    if (pin == null) {
                        this.selPin = pin = new PinRef(this.selPin, mx, my);
                        ((GuiFrame)this.parent).gui.sendPkt(new Object[]{(byte)8, (byte)pin.gate, (byte)(pin.pin | pin.trace - 1 << 4), (byte)mx, (byte)my});
                        break;
                    }
                    if (pin.gate != this.selPin.gate || pin.pin != this.selPin.pin || pin.trace < 0) {
                        if (pin.link == null) {
                            ((GuiFrame)this.parent).gui.sendPkt(new Object[]{(byte)3, (byte)this.selPin.gate, pin.trace >= 0 ? (byte)-1 : (byte)pin.gate, (byte)(this.selPin.pin | (pin.trace >= 0 ? 240 : pin.pin << 4)), (byte)this.selPin.trace});
                        } else {
                            ((GuiFrame)this.parent).gui.sendPkt(new Object[]{(byte)11, (byte)this.selPin.gate, (byte)pin.gate, (byte)(this.selPin.pin | pin.pin << 4), (byte)(this.selPin.trace & 0xF | pin.trace << 4)});
                        }
                        this.selPin = null;
                        break;
                    }
                    if (pin.trace <= this.selPin.trace) {
                        ((GuiFrame)this.parent).gui.sendPkt(new Object[]{(byte)3, (byte)this.selPin.gate, (byte)-1, (byte)(this.selPin.pin | 0xF0), (byte)this.selPin.trace});
                        this.selPin = null;
                        break;
                    }
                    ((GuiFrame)this.parent).gui.sendPkt(new Object[]{(byte)9, (byte)this.selPin.gate, (byte)this.selPin.pin, (byte)(this.selPin.trace & 0xF | pin.trace - 1 << 4)});
                    this.selPin = null;
                    break;
                }
                if (d == 1) {
                    this.curAction = this.selPin != null && this.selPin.trace > 0 ? (byte)1 : 0;
                    break;
                }
                if (d != 2 || this.curAction != 1) break;
                if (this.selPin != null && this.selPin.trace > 0) {
                    PinRef pin = (PinRef)this.pins.get(mx & 0xFFFF | my << 16);
                    if (pin == null || pin.trace >= 0 && this.commonSource(pin, this.selPin)) {
                        ((GuiFrame)this.parent).gui.sendPkt(new Object[]{(byte)10, (byte)this.selPin.gate, (byte)(this.selPin.pin | this.selPin.trace - 1 << 4), (byte)mx, (byte)my});
                    }
                    this.selPin = null;
                }
                this.curAction = 0;
                break;
            }
            case 2: {
                mx = (mx - this.x - 2) / 4;
                if (d == 0) break;
                BoundingBox2D<Gate> part = this.findPart(mx, my);
                if (part != null) {
                    this.placing = ((Gate)part.owner).type.newGate(0);
                }
                this.selPart = null;
                this.curAction = 0;
                this.update.run();
            }
        }
        return true;
    }

    private boolean commonSource(PinRef pin0, PinRef pin1) {
        Gate g0 = this.schematic.get(pin0.gate);
        Gate g1 = this.schematic.get(pin1.gate);
        if (g0 == null || g1 == null || pin0.pin >= g0.inputCount() || pin1.pin >= g1.inputCount()) {
            return false;
        }
        Pin p0 = g0.getInput(pin0.pin);
        Pin p1 = g1.getInput(pin1.pin);
        return p0 != null && p0.equals(p1);
    }

    public void unfocus() {
        if (this.selPart != null && this.selPart.owner != null && (this.moveX != 0 || this.moveY != 0)) {
            if (this.selPart.offset(this.moveX, this.moveY).enclosedBy(this.schematic.BOARD_AREA)) {
                ((GuiFrame)this.parent).gui.sendPkt(new Object[]{(byte)2, (byte)((Gate)this.selPart.owner).index, (byte)(((Gate)this.selPart.owner).rasterX + this.moveX), (byte)(((Gate)this.selPart.owner).rasterY + this.moveY)});
            } else {
                ((GuiFrame)this.parent).gui.sendPkt(new Object[]{(byte)1, (byte)((Gate)this.selPart.owner).index});
            }
            this.originX += this.moveX;
            this.originY += this.moveY;
        }
    }

    public boolean focus() {
        return true;
    }

    private BoundingBox2D<Gate> findPart(int x, int y) {
        for (BoundingBox2D<Gate> part : this.parts) {
            if (!part.isPointInside(x, y)) continue;
            return part;
        }
        return null;
    }

    public void place(GateType op) {
        this.placing = op == null ? null : op.newGate(0);
    }

    public void del(int b) {
        if (this.selPart != null && this.selPart.owner != null) {
            ((GuiFrame)this.parent).gui.sendPkt(new Object[]{(byte)1, (byte)((Gate)this.selPart.owner).index});
        }
    }
}

