/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rscpl.gui;

import cd4017be.lib.render.ModTextureMap;
import cd4017be.lib.render.RectangularSprite;
import cd4017be.rscpl.editor.BoundingBox2D;
import cd4017be.rscpl.editor.GateType;
import cd4017be.rscpl.gui.Category;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.ITextureMapPopulator;
import net.minecraft.client.renderer.texture.ITickableTextureObject;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GateTextureHandler
implements ITextureMapPopulator {
    private static final String TINY_FONT = "rs_ctr:tiny_font";
    public static final ResourceLocation GATE_ICONS_LOC = new ResourceLocation("rs_ctr", "textures/gates");
    public static final ModTextureMap GATE_ICONS_TEX = new ModTextureMap(GATE_ICONS_LOC.func_110623_a(), (ITextureMapPopulator)new GateTextureHandler());
    public static final ArrayList<Category> ins_sets = new ArrayList();
    private static boolean registered;

    public static void register() {
        if (registered) {
            return;
        }
        registered = true;
        Minecraft.func_71410_x().field_71446_o.func_110580_a(GATE_ICONS_LOC, (ITickableTextureObject)GATE_ICONS_TEX);
    }

    public void func_177059_a(TextureMap textureMap) {
        textureMap.setTextureEntry((TextureAtlasSprite)new RectangularSprite(TINY_FONT));
        for (Category ins : ins_sets) {
            textureMap.func_174942_a(new ResourceLocation(ins.getIcon()));
            for (BoundingBox2D<GateType> t : ins.instructions) {
                textureMap.setTextureEntry((TextureAtlasSprite)new RectangularSprite(((GateType)t.owner).getIcon()));
            }
        }
    }

    public static void drawIcon(BufferBuilder b, int x, int y, int w, int h, String icon, double z) {
        TextureAtlasSprite tex = GATE_ICONS_TEX.func_110572_b(icon);
        int X = (x += (w - tex.func_94211_a()) / 2) + tex.func_94211_a();
        int Y = (y += (h - tex.func_94216_b()) / 2) + tex.func_94216_b();
        double u = tex.func_94209_e();
        double U = tex.func_94212_f();
        double v = tex.func_94206_g();
        double V = tex.func_94210_h();
        boolean t = tex instanceof RectangularSprite && ((RectangularSprite)tex).uvTransposed();
        b.func_181662_b((double)x, (double)Y, z).func_187315_a(t ? U : u, t ? v : V).func_181675_d();
        b.func_181662_b((double)X, (double)Y, z).func_187315_a(U, V).func_181675_d();
        b.func_181662_b((double)X, (double)y, z).func_187315_a(t ? u : U, t ? V : v).func_181675_d();
        b.func_181662_b((double)x, (double)y, z).func_187315_a(u, v).func_181675_d();
    }

    public static void drawTinyText(BufferBuilder b, String s, int x, int y, int w, double z) {
        char[] cs = s.toCharArray();
        double scale = cs.length <= w ? 1.0 : (double)cs.length / (double)w;
        double px = (double)x + ((double)w - (double)cs.length / scale) * 2.0;
        double dx = 4.0 / scale;
        double y0 = (double)y + (scale - 1.0) * 1.25;
        double y1 = y0 + 6.0 / scale;
        TextureAtlasSprite tex = GATE_ICONS_TEX.func_110572_b(TINY_FONT);
        float du = 0.0625f;
        float dv = 6.0f / (float)tex.func_94216_b();
        float[] t = new float[8];
        for (char c : cs) {
            RectangularSprite.getInterpolatedUV((float[])t, (TextureAtlasSprite)tex, (float)((float)(c & 0xF) * du), (float)((float)(c >> 4) * dv), (float)du, (float)dv);
            double x1 = px + dx;
            b.func_181662_b(px, y0, z).func_187315_a((double)t[0], (double)t[1]).func_181675_d();
            b.func_181662_b(px, y1, z).func_187315_a((double)t[2], (double)t[3]).func_181675_d();
            b.func_181662_b(x1, y1, z).func_187315_a((double)t[4], (double)t[5]).func_181675_d();
            b.func_181662_b(x1, y0, z).func_187315_a((double)t[6], (double)t[7]).func_181675_d();
            px = x1;
        }
    }
}

