/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rscpl.editor;

import cd4017be.lib.util.Utils;
import cd4017be.rs_ctr.Main;
import cd4017be.rscpl.editor.BoundingBox2D;
import cd4017be.rscpl.editor.Gate;
import cd4017be.rscpl.editor.GateType;
import cd4017be.rscpl.editor.InstructionSet;
import cd4017be.rscpl.editor.Pin;
import cd4017be.rscpl.editor.TraceNode;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.BitSet;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.apache.commons.lang3.tuple.Pair;

public class Schematic {
    public final InstructionSet INS_SET;
    public final BoundingBox2D<Gate> BOARD_AREA;
    public ArrayList<Gate> operators = new ArrayList();
    private BitSet toSync = new BitSet();
    public boolean modified;
    public boolean server;
    public static final byte ADD_GATE = 0;
    public static final byte REM_GATE = 1;
    public static final byte MOVE_GATE = 2;
    public static final byte CONNECT = 3;
    public static final byte SET_LABEL = 4;
    public static final byte SET_VALUE = 5;
    public static final byte INS_TRACE = 8;
    public static final byte REM_TRACE = 9;
    public static final byte MOVE_TRACE = 10;
    public static final byte JOIN_TRACE = 11;
    public static final byte MOVE_AREA = 12;

    public Schematic(InstructionSet insSet, int width, int height) {
        this.INS_SET = insSet;
        this.BOARD_AREA = new BoundingBox2D<Object>(null, 0, 0, width - 1, height);
    }

    public void resetSync() {
        this.modified |= !this.toSync.isEmpty();
        this.toSync.clear();
    }

    public void clear() {
        if (this.server) {
            int l = this.operators.size();
            for (int i = 0; i < l; ++i) {
                if (this.operators.get(i) == null) continue;
                this.toSync.set(i << 1);
            }
        }
        this.operators.clear();
    }

    public void deserialize(ByteBuf data) {
        this.clear();
        int n = data.readUnsignedByte();
        for (int i = 0; i < n; ++i) {
            GateType t = this.INS_SET.get(data.readUnsignedByte());
            int l = data.readUnsignedShort();
            int p = l + data.readerIndex();
            if (t != null) {
                Gate g = t.newGate(this.operators.size());
                g.read(data);
                g.readCfg(data);
                this.operators.add(g);
            } else {
                this.operators.add(null);
            }
            if (data.readerIndex() == p) continue;
            Main.LOG.warn("corrupted data in circuit schematic:\ntype = {}, exp_size = {}, read_size = {}", (Object)t, (Object)l, (Object)(l - p + data.readerIndex()));
            data.readerIndex(p);
        }
        for (Gate g : this.operators) {
            if (g == null) continue;
            g.reconnect(this::get);
        }
        if (this.server) {
            this.toSync.set(0, n << 1);
        }
    }

    public void serialize(ByteBuf data) {
        int n;
        for (n = this.operators.size(); n > 0 && this.operators.get(n - 1) == null; --n) {
        }
        data.writeByte(n);
        for (int i = 0; i < n; ++i) {
            Gate g = this.operators.get(i);
            if (g != null) {
                data.writeByte(this.INS_SET.id(g.type));
                int j = data.writerIndex();
                data.writeShort(0);
                g.write(data);
                g.writeCfg(data);
                data.setShort(j, data.writerIndex() - j - 2);
                continue;
            }
            data.writeByte(-1);
            data.writeShort(0);
        }
    }

    public void getChanges(NBTTagCompound nbt, boolean all) {
        int l;
        NBTTagList list = new NBTTagList();
        ByteBuf buf = Unpooled.buffer();
        int j = -1;
        for (l = this.operators.size(); l > 0 && this.operators.get(l - 1) == null; --l) {
        }
        l <<= 1;
        while (all ? ++j < l : (j = this.toSync.nextSetBit(j + 1)) >= 0) {
            NBTTagCompound tag = new NBTTagCompound();
            int i = j >> 1;
            tag.func_74774_a("i", (byte)i);
            Gate op = this.get(i);
            if (op != null) {
                byte[] arr;
                tag.func_74774_a("t", (byte)this.INS_SET.id(op.type));
                if ((j & 1) == 0) {
                    op.write(buf);
                    arr = new byte[buf.writerIndex()];
                    buf.readBytes(arr);
                    tag.func_74773_a("d", arr);
                    buf.clear();
                }
                if ((all || (j & 1) != 0 || this.toSync.get(j | 1)) && op.writeCfg(buf)) {
                    arr = new byte[buf.writerIndex()];
                    buf.readBytes(arr);
                    tag.func_74773_a("c", arr);
                    buf.clear();
                }
            }
            j |= 1;
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("d", (NBTBase)list);
        if (!all) {
            this.toSync.clear();
        }
    }

    public void applyChanges(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("d", 10);
        ByteBuf buf = Unpooled.buffer();
        for (NBTBase bt : list) {
            GateType t;
            NBTTagCompound tag = (NBTTagCompound)bt;
            int i = tag.func_74771_c("i") & 0xFF;
            Gate op = this.get(i);
            if ((op == null ? null : op.type) != (t = tag.func_150297_b("t", 1) ? this.INS_SET.get(tag.func_74771_c("t")) : null)) {
                if (op != null) {
                    op.remove();
                }
                if (t != null) {
                    while (i > this.operators.size()) {
                        this.operators.add(null);
                    }
                    op = t.newGate(i);
                    if (i < this.operators.size()) {
                        this.operators.set(i, op);
                    } else {
                        this.operators.add(op);
                    }
                } else {
                    op = null;
                    if (i < this.operators.size()) {
                        this.operators.set(i, null);
                    }
                }
            }
            if (op != null && tag.func_150297_b("d", 7)) {
                buf.writeBytes(tag.func_74770_j("d"));
                op.read(buf);
                buf.clear();
            }
            if (op == null || !tag.func_150297_b("c", 7)) continue;
            buf.writeBytes(tag.func_74770_j("c"));
            op.readCfg(buf);
            buf.clear();
        }
        for (NBTBase tag : list) {
            Gate op = this.get(((NBTTagCompound)tag).func_74771_c("i") & 0xFF);
            if (op == null) continue;
            op.reconnect(this::get);
        }
        this.modified = true;
    }

    public Gate get(int idx) {
        if (idx < this.operators.size()) {
            return this.operators.get(idx);
        }
        return null;
    }

    public BoundingBox2D<Gate> getCollision(BoundingBox2D<Gate> box) {
        if (!box.enclosedBy(this.BOARD_AREA)) {
            return this.BOARD_AREA;
        }
        for (Gate op1 : this.operators) {
            BoundingBox2D<Gate> box1;
            if (op1 == null || !(box1 = op1.getBounds()).overlapsWith(box)) continue;
            return box1;
        }
        return null;
    }

    public boolean handleUserInput(byte actionID, ByteBuf data) {
        switch (actionID) {
            case 0: {
                int i = this.operators.indexOf(null);
                if (i < 0) {
                    i = this.operators.size();
                }
                if (i >= 256) {
                    return false;
                }
                Gate op = this.INS_SET.newGate(data.readByte(), i);
                if (op == null) {
                    return false;
                }
                op.setPosition(data.readUnsignedByte(), data.readUnsignedByte());
                if (this.getCollision(op.getBounds()) != null) {
                    return false;
                }
                if (i == this.operators.size()) {
                    this.operators.add(op);
                } else {
                    this.operators.set(i, op);
                }
                this.toSync.set(i << 1);
                return true;
            }
            case 1: {
                short i = data.readUnsignedByte();
                Gate op = this.get(i);
                if (op == null) {
                    return false;
                }
                op.remove();
                this.operators.set(i, null);
                this.toSync.set(i << 1);
                return true;
            }
            case 2: {
                int j;
                short i = data.readUnsignedByte();
                Gate op = this.get(i);
                if (op == null) {
                    return false;
                }
                int prevX = op.rasterX;
                int prevY = op.rasterY;
                op.setPosition(data.readUnsignedByte(), data.readUnsignedByte());
                if (this.getCollision(op.getBounds()) != null) {
                    op.rasterX = prevX;
                    op.rasterY = prevY;
                    return false;
                }
                int dx = op.rasterX - prevX;
                int dy = op.rasterY - prevY;
                int x = prevX + Math.max(0, -op.type.width);
                for (j = op.inputCount() - 1; j >= 0; --j) {
                    Pin p = op.getInput(j);
                    if (p == null) continue;
                    int y = prevY + op.type.getInputHeight(j);
                    this.moveAll(p, x, y, x + dx, y + dy, false);
                }
                x = prevX + Math.max(0, op.type.width);
                for (j = op.outputs.length - 1; j >= 0; --j) {
                    int y = prevY + op.type.getOutputHeight(j);
                    this.moveAll(op.outputs[j], x, y, x + dx, y + dy, true);
                }
                this.toSync.set(i << 1);
                return true;
            }
            case 3: {
                short i = data.readUnsignedByte();
                Gate op = this.get(i);
                Gate op1 = this.get(data.readUnsignedByte());
                if (op == null) {
                    return false;
                }
                int pins = data.readUnsignedByte();
                if ((pins & 0xF) >= op.inputCount()) {
                    return false;
                }
                int trace = data.readUnsignedByte();
                op.setInput(pins & 0xF, op1 != null ? op1.outputs[pins >> 4] : null);
                pins &= 0xF;
                if (trace == 0) {
                    op.traces[pins] = null;
                } else {
                    TraceNode tn = op.traces[pins];
                    while (tn != null) {
                        if (--trace == 0) {
                            tn.next = null;
                        }
                        tn = tn.next;
                    }
                }
                this.toSync.set(i << 1);
                return true;
            }
            case 4: {
                short i = data.readUnsignedByte();
                Gate op = this.get(i);
                if (op == null) {
                    return false;
                }
                op.label = data.toString(Utils.UTF8);
                data.readerIndex(data.writerIndex());
                this.toSync.set(i << 1);
                return true;
            }
            case 5: {
                short i = data.readUnsignedByte();
                Gate op = this.get(i);
                if (!op.readCfg(data)) {
                    return false;
                }
                this.toSync.set(i << 1 | 1);
                return true;
            }
            case 8: {
                short i = data.readUnsignedByte();
                Gate op = this.get(i);
                if (op == null) {
                    return false;
                }
                int p = data.readUnsignedByte();
                int t = p >> 4;
                if ((p &= 0xF) >= op.inputCount()) {
                    return false;
                }
                TraceNode tn = new TraceNode(op, p);
                tn.rasterX = data.readUnsignedByte();
                tn.rasterY = data.readUnsignedByte();
                if (t == 0) {
                    tn.next = op.traces[p];
                    op.traces[p] = tn;
                } else {
                    TraceNode tn1 = op.getTrace(p, t - 1);
                    if (tn1 == null) {
                        return false;
                    }
                    tn.next = tn1.next;
                    tn1.next = tn;
                }
                this.toSync.set(i << 1);
                return true;
            }
            case 9: {
                short i = data.readUnsignedByte();
                Gate op = this.get(i);
                if (op == null) {
                    return false;
                }
                short p = data.readUnsignedByte();
                if (p >= op.inputCount()) {
                    return false;
                }
                int t = data.readUnsignedByte();
                int t1 = t >> 4;
                if ((t &= 0xF) == 0) {
                    op.traces[p] = op.getTrace(p, t1);
                } else {
                    TraceNode tn = op.getTrace(p, t - 1);
                    if (tn == null || t1 < t) {
                        return false;
                    }
                    tn.next = op.getTrace(p, t1);
                }
                this.toSync.set(i << 1);
                return true;
            }
            case 10: {
                short i = data.readUnsignedByte();
                Gate op = this.get(i);
                if (op == null) {
                    return false;
                }
                int p = data.readUnsignedByte();
                int t = p >> 4;
                if ((p &= 0xF) >= op.inputCount()) {
                    return false;
                }
                short x = data.readUnsignedByte();
                short y = data.readUnsignedByte();
                TraceNode tn = op.getTrace(p, t);
                if (tn == null) {
                    return false;
                }
                Pin pin = op.getInput(p);
                if (pin != null) {
                    this.moveAll(pin, tn.rasterX, tn.rasterY, x, y, false);
                } else {
                    tn.rasterX = x;
                    tn.rasterY = y;
                    this.toSync.set(i << 1);
                }
                return true;
            }
            case 11: {
                TraceNode tn1;
                short i = data.readUnsignedByte();
                Gate op = this.get(i);
                Gate op1 = this.get(data.readUnsignedByte());
                if (op == null || op1 == null) {
                    return false;
                }
                int pin = data.readUnsignedByte();
                int pin1 = pin >> 4;
                if ((pin &= 0xF) >= op.inputCount() || pin1 >= op1.inputCount()) {
                    return false;
                }
                int t = data.readUnsignedByte();
                int t1 = t >> 4;
                t &= 0xF;
                if (t1 == 0) {
                    tn1 = new TraceNode(op, pin);
                    tn1.rasterX = op1.rasterX + Math.max(0, -op1.type.width);
                    tn1.rasterY = op1.rasterY + op1.type.getInputHeight(pin1);
                    tn1.next = op1.getTrace(pin1, 0);
                    if (tn1.next != null) {
                        tn1.next = tn1.next.copy(op, pin);
                    }
                } else {
                    tn1 = op1.getTrace(pin1, t1 - 1);
                    if (tn1 != null) {
                        tn1 = tn1.copy(op, pin);
                    }
                }
                if (t == 0) {
                    op.traces[pin] = tn1;
                } else {
                    TraceNode tn = op.getTrace(pin, t - 1);
                    if (tn == null || t1 < t) {
                        return false;
                    }
                    tn.next = tn1;
                }
                op.setInput(pin, op1.getInput(pin1));
                this.toSync.set(i << 1);
                return true;
            }
            case 12: {
                BoundingBox2D<Object> from = new BoundingBox2D<Object>(null, data.readUnsignedByte(), data.readUnsignedByte(), data.readUnsignedByte(), data.readUnsignedByte());
                byte dx = data.readByte();
                byte dy = data.readByte();
                boolean delete = dx == 0 && dy == 0;
                BoundingBox2D<Object> to = from.offset(dx, dy);
                if (!to.enclosedBy(this.BOARD_AREA)) {
                    return false;
                }
                ArrayList<Gate> toMove = new ArrayList<Gate>();
                ArrayList<TraceNode> traces = new ArrayList<TraceNode>();
                for (Gate g : this.operators) {
                    if (g == null) continue;
                    BoundingBox2D<Gate> box = g.getBounds();
                    if (box.overlapsWith(from)) {
                        toMove.add(g);
                    } else {
                        if (delete) continue;
                        if (box.overlapsWith(to)) {
                            return false;
                        }
                    }
                    for (TraceNode n : g.traces) {
                        while (n != null) {
                            if (from.isPointInside(n.rasterX, n.rasterY)) {
                                traces.add(n);
                            }
                            n = n.next;
                        }
                    }
                }
                for (TraceNode tn : traces) {
                    tn.rasterX += dx;
                    tn.rasterY += dy;
                    this.toSync.set(tn.owner.index << 1);
                }
                for (Gate g : toMove) {
                    if (delete) {
                        g.remove();
                        this.operators.set(g.index, null);
                    } else {
                        g.rasterX += dx;
                        g.rasterY += dy;
                    }
                    this.toSync.set(g.index << 1);
                }
                return true;
            }
        }
        return false;
    }

    private void moveAll(Pin signal, int x0, int y0, int x1, int y1, boolean output) {
        if (x1 == x0 && y1 == y0) {
            return;
        }
        for (Pair<Gate, Integer> r : signal.receivers) {
            Gate g = (Gate)r.getLeft();
            TraceNode first = null;
            TraceNode prev = null;
            TraceNode tn = g.traces[(Integer)r.getRight()];
            while (tn != null) {
                if (tn.rasterX == x0 && tn.rasterY == y0 || tn.rasterX == x1 && tn.rasterY == y1) {
                    if (first != null) {
                        first.next = tn.next;
                    } else {
                        first = tn;
                        if (!output) {
                            tn.rasterX = x1;
                            tn.rasterY = y1;
                        } else {
                            if (prev != null) {
                                prev.next = null;
                                break;
                            }
                            g.traces[((Integer)r.getRight()).intValue()] = null;
                            break;
                        }
                    }
                }
                prev = tn;
                tn = tn.next;
            }
            if (first == null) continue;
            this.toSync.set(g.index << 1);
        }
    }
}

