/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity.part;

import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.lib.Gui.AdvancedContainer;
import cd4017be.lib.Gui.ModularGui;
import cd4017be.lib.Gui.comp.GuiCompGroup;
import cd4017be.lib.Gui.comp.GuiFrame;
import cd4017be.lib.Gui.comp.TextField;
import cd4017be.lib.network.StateSyncClient;
import cd4017be.lib.network.StateSyncServer;
import cd4017be.lib.network.StateSynchronizer;
import cd4017be.lib.util.Orientation;
import cd4017be.lib.util.TooltipUtil;
import cd4017be.rs_ctr.tileentity.part.Module;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Socket
extends Module
implements AdvancedContainer.IStateInteractionHandler {
    protected byte pos;
    protected String title = "";

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_74774_a("pos", this.pos);
        nbt.func_74778_a("title", this.title);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.pos = nbt.func_74771_c("pos");
        this.loadCfg(nbt);
    }

    @Override
    protected void loadCfg(NBTTagCompound nbt) {
        this.title = nbt.func_74779_i("title");
    }

    protected abstract String portLabel(boolean var1);

    protected abstract Class<?> type();

    @Override
    public void init(List<MountedPort> ports, int idx, Module.IPanel panel) {
        double x = this.getX() + 0.125;
        double y = this.getY() + 0.125;
        Orientation o = panel.getOrientation();
        boolean out = (this.pos & 0x10) != 0;
        ports.add(new MountedPort((IPortProvider)panel, idx << 1, this.type(), !out).setLocation(x, y, 0.75, EnumFacing.NORTH, o).setName(this.portLabel(!out)));
        ports.add(new MountedPort((IPortProvider)panel, idx << 1 | 1, this.type(), out).setLocation(x, y, 1.002, EnumFacing.SOUTH, o).setName('\\' + this.title));
        super.init(ports, idx, panel);
    }

    @Override
    public void onPlaced(ItemStack stack, float x, float y) {
        int gx = (int)Math.floor(x * 4.0f);
        int gy = (int)Math.floor(y * 4.0f);
        this.pos = (byte)(gx & 3 | gy << 2 & 0xC | (int)((x + y) * 4.0f - (float)(gx + gy)) << 4 & 0x10);
        this.title = TooltipUtil.translate((String)this.portLabel((this.pos & 0x10) != 0));
    }

    @Override
    public int getBounds() {
        return 1 << (this.pos & 0xF);
    }

    protected double getX() {
        return (double)(this.pos & 3) * 0.25;
    }

    protected double getY() {
        return (double)(this.pos >> 2 & 3) * 0.25;
    }

    @Override
    public void writeSync(PacketBuffer buf, boolean init) {
    }

    @Override
    public void readSync(PacketBuffer buf) {
    }

    public AdvancedContainer getCfgContainer(EntityPlayer player) {
        return new AdvancedContainer((AdvancedContainer.IStateInteractionHandler)this, StateSynchronizer.builder().build(this.host.world().field_72995_K), player);
    }

    @SideOnly(value=Side.CLIENT)
    public ModularGui getCfgScreen(EntityPlayer player) {
        ModularGui gui = new ModularGui(this.getCfgContainer(player));
        GuiFrame frame = new GuiFrame(gui, 80, 31, 1).title("gui.rs_ctr.dsp_cfg.name", 0.5f).background(new ResourceLocation("rs_ctr", "textures/gui/small.png"), 0, 0);
        new TextField((GuiCompGroup)frame, 64, 7, 8, 16, 16, () -> this.title, t -> gui.sendPkt(new Object[]{t})).allowFormat().tooltip("gui.rs_ctr.label");
        gui.compGroup = frame;
        return gui;
    }

    public void writeState(StateSyncServer state, AdvancedContainer cont) {
    }

    public void readState(StateSyncClient state, AdvancedContainer cont) {
    }

    public void handleAction(PacketBuffer pkt, EntityPlayerMP sender) throws Exception {
        this.title = pkt.func_150789_c(32);
        this.host.markDirty(2);
    }

    public boolean canInteract(EntityPlayer player, AdvancedContainer cont) {
        Module.IPanel host = this.host;
        return !player.field_70128_L && host != null && player.func_174831_c(host.pos()) < 256.0;
    }
}

