/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity.part;

import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.interact.IInteractiveComponent;
import cd4017be.lib.Gui.AdvancedContainer;
import cd4017be.lib.Gui.ModularGui;
import cd4017be.lib.Gui.comp.GuiFrame;
import cd4017be.lib.network.StateSyncClient;
import cd4017be.lib.network.StateSyncServer;
import cd4017be.lib.network.StateSynchronizer;
import cd4017be.lib.render.model.IntArrayModel;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr.tileentity.part.Module;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class SignalModule
extends Module
implements AdvancedContainer.IStateInteractionHandler,
IInteractiveComponent.ITESRenderComp {
    protected byte pos;
    protected String title = "";
    protected int value;
    @SideOnly(value=Side.CLIENT)
    IntArrayModel renderCache;

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_74774_a("pos", this.pos);
        nbt.func_74768_a("val", this.value);
        nbt.func_74778_a("title", this.title);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.pos = nbt.func_74771_c("pos");
        this.value = nbt.func_74762_e("val");
        this.loadCfg(nbt);
    }

    @Override
    protected void loadCfg(NBTTagCompound nbt) {
        this.title = nbt.func_74779_i("title");
        if (this.host != null && this.host.world().field_72995_K) {
            this.renderCache = null;
        }
    }

    @Override
    public int getBounds() {
        return (15 >> 3 - (this.pos >> 4 & 3)) * (4369 >> 12 - (this.pos >> 4 & 0xC)) << (this.pos & 0xF);
    }

    protected double getX() {
        return (double)(this.pos & 3) * 0.25;
    }

    protected double getY() {
        return (double)(this.pos >> 2 & 3) * 0.25;
    }

    protected double getW() {
        return (double)((this.pos >> 4 & 3) + 1) * 0.25;
    }

    protected double getH() {
        return (double)((this.pos >> 6 & 3) + 1) * 0.25;
    }

    @Override
    public Object getPortCallback() {
        return this instanceof SignalHandler ? this : null;
    }

    @Override
    public void setPortCallback(Object callback) {
    }

    @Override
    public void resetInput() {
        if (this instanceof SignalHandler) {
            ((SignalHandler)this).updateSignal(0);
        }
    }

    @Override
    public void writeSync(PacketBuffer buf, boolean init) {
        buf.writeInt(this.value);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readSync(PacketBuffer buf) {
        int val = buf.readInt();
        if (val != this.value) {
            this.value = val;
            this.renderCache = null;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawText(FontRenderer fr) {
        int x = (this.pos & 3) * 32;
        int y = (3 - (this.pos >> 2 & 3) - (this.pos >> 6 & 3)) * 32;
        int w = (this.pos >> 4 & 3) * 32 + 32;
        y = (this.pos >> 6 & 3) != 0 ? (y += 8) : ++y;
        fr.func_78276_b(this.title, x + (w - fr.func_78256_a(this.title)) / 2, y, -16777216);
    }

    @SideOnly(value=Side.CLIENT)
    public void render(World world, BlockPos pos, double x, double y, double z, int light, BufferBuilder buffer) {
        Module.IPanel host = this.host;
        if (host == null) {
            return;
        }
        light = host.frontLight();
        IntArrayModel m = this.renderCache;
        if (m == null && (this.refreshFTESR(host.getOrientation(), x, y, z, light, buffer) || (m = this.renderCache) == null)) {
            return;
        }
        m.setBrightness(this.brightness(light));
        buffer.func_178981_a(m.translated((float)((float)x), (float)((float)y), (float)((float)z)).vertexData);
    }

    @SideOnly(value=Side.CLIENT)
    protected abstract boolean refreshFTESR(Orientation var1, double var2, double var4, double var6, int var8, BufferBuilder var9);

    @SideOnly(value=Side.CLIENT)
    protected int brightness(int light) {
        return light;
    }

    public AxisAlignedBB getRenderBB(World world, BlockPos pos) {
        return null;
    }

    public AdvancedContainer getCfgContainer(EntityPlayer player) {
        return new AdvancedContainer((AdvancedContainer.IStateInteractionHandler)this, StateSynchronizer.builder().build(this.host.world().field_72995_K), player);
    }

    @SideOnly(value=Side.CLIENT)
    public ModularGui getCfgScreen(EntityPlayer player) {
        ModularGui gui = new ModularGui(this.getCfgContainer(player));
        gui.compGroup = this.initGuiFrame(gui);
        return gui;
    }

    @SideOnly(value=Side.CLIENT)
    protected abstract GuiFrame initGuiFrame(ModularGui var1);

    public void writeState(StateSyncServer state, AdvancedContainer cont) {
    }

    public void readState(StateSyncClient state, AdvancedContainer cont) {
    }

    public boolean canInteract(EntityPlayer player, AdvancedContainer cont) {
        Module.IPanel host = this.host;
        return !player.field_70128_L && host != null && player.func_174831_c(host.pos()) < 256.0;
    }

    @Override
    public Object getState(int id) {
        return this.value;
    }
}

