/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity.part;

import cd4017be.api.rs_ctr.interact.IInteractiveComponent;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.lib.network.GuiNetworkHandler;
import cd4017be.lib.util.ItemFluidUtil;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr.item.ItemWrench;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public abstract class Module
implements IInteractiveComponent,
INBTSerializable<NBTTagCompound> {
    public static final HashMap<String, Supplier<Module>> REGISTRY = new HashMap();
    protected IPanel host;
    protected int idx;

    public static Module get(String id) {
        Supplier<Module> loader = REGISTRY.get(id);
        return loader == null ? null : loader.get();
    }

    public void init(List<MountedPort> ports, int idx, IPanel panel) {
        this.idx = idx;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("id", this.id());
        return nbt;
    }

    public Pair<Vec3d, EnumFacing> rayTrace(Vec3d start, Vec3d dir) {
        IPanel host = this.host;
        if (host == null) {
            return null;
        }
        Orientation o = host.getOrientation();
        Pair res = IInteractiveComponent.rayTraceFlat((Vec3d)start, (Vec3d)dir, (Vec3d)o.Z.func_186678_a(0.5).func_72441_c(0.5, 0.5, 0.5), (EnumFacing)o.back, (float)0.5f, (float)0.5f);
        if (res != null) {
            Vec3d pos = o.invRotate(((Vec3d)res.getLeft()).func_178787_e(start).func_178786_a(0.5, 0.5, 0.5));
            if ((this.getBounds() >> (int)Math.floor(pos.field_72450_a * 4.0) + (int)Math.floor(pos.field_72448_b * 4.0) * 4 + 10 & 1) == 0) {
                res = null;
            }
        }
        return res;
    }

    public boolean onInteract(EntityPlayer player, boolean hit, EnumFacing side, Vec3d aim) {
        ItemStack stack = player.func_184614_ca();
        if (stack.func_190926_b() || !ItemWrench.WRENCHES.contains(stack.func_77973_b().getRegistryName())) {
            return false;
        }
        if (hit) {
            stack = this.onRemove();
            if (!player.func_184812_l_()) {
                ItemFluidUtil.dropStack((ItemStack)stack, (Entity)player);
            }
            this.host.remove(this.idx);
        } else if (player.func_70093_af()) {
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt == null) {
                nbt = new NBTTagCompound();
                stack.func_77982_d(nbt);
            }
            nbt.func_74782_a("cfg", (NBTBase)this.serializeNBT());
            player.func_146105_b((ITextComponent)new TextComponentTranslation("msg.rs_ctr.cfg_store", new Object[0]), true);
        } else {
            NBTTagCompound nbt = stack.func_179543_a("cfg");
            if (nbt != null) {
                String id = nbt.func_74779_i("id");
                if (id.equals(this.id())) {
                    this.loadCfg(nbt);
                    this.host.markDirty(3);
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("msg.rs_ctr.cfg_load", new Object[0]), true);
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("msg.rs_ctr.cfg_invalid", new Object[0]), true);
                }
            } else {
                GuiNetworkHandler.openBlockGui((EntityPlayer)player, (BlockPos)this.host.pos(), (int)this.idx);
            }
        }
        return true;
    }

    protected abstract void loadCfg(NBTTagCompound var1);

    public Pair<Vec3d, String> getDisplayText(Vec3d aim) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void drawText(FontRenderer fr) {
    }

    public abstract void onPlaced(ItemStack var1, float var2, float var3);

    public abstract String id();

    public abstract int getBounds();

    public abstract ItemStack onRemove();

    public void onLoad(IPanel host) {
        this.host = host;
    }

    public void onUnload() {
        this.host = null;
    }

    public boolean loaded() {
        return this.host != null;
    }

    public abstract Object getPortCallback();

    public abstract void setPortCallback(Object var1);

    public abstract void resetInput();

    public abstract void writeSync(PacketBuffer var1, boolean var2);

    @SideOnly(value=Side.CLIENT)
    public abstract void readSync(PacketBuffer var1);

    public abstract Container getCfgContainer(EntityPlayer var1);

    @SideOnly(value=Side.CLIENT)
    public abstract GuiScreen getCfgScreen(EntityPlayer var1);

    public Object getState(int id) {
        return null;
    }

    public static interface IPanel
    extends IPortProvider {
        public Orientation getOrientation();

        public BlockPos pos();

        public World world();

        public void remove(int var1);

        public boolean add(Module var1);

        public void updateDisplay();

        public void markDirty(int var1);

        @SideOnly(value=Side.CLIENT)
        public int frontLight();
    }
}

