/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity;

import cd4017be.api.rs_ctr.com.DelayedSignal;
import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.lib.TickRegistry;
import cd4017be.rs_ctr.tileentity.WallMountGate;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public abstract class SignalCombiner
extends WallMountGate
implements TickRegistry.IUpdatable {
    protected SignalHandler output0;
    protected SignalHandler output1;
    protected final int[] inputs = new int[4];
    protected byte tick;
    protected DelayedSignal delayed;

    public SignalCombiner() {
        this.ports = new MountedPort[6];
        for (int i = 0; i < 4; ++i) {
            this.ports[i] = new MountedPort((IPortProvider)this, i, SignalHandler.class, false).setLocation(0.25, (double)(0.125f + (float)i * 0.25f), 0.125, EnumFacing.WEST).setName("port.rs_ctr.i");
        }
        this.ports[4] = new MountedPort((IPortProvider)this, 4, SignalHandler.class, true).setLocation(0.75, 0.375, 0.125, EnumFacing.EAST).setName("port.rs_ctr.o");
        this.ports[5] = new MountedPort((IPortProvider)this, 5, SignalHandler.class, true).setLocation(0.75, 0.625, 0.125, EnumFacing.EAST).setName("port.rs_ctr.o");
    }

    public SignalHandler getPortCallback(int pin) {
        return val -> this.setInput(pin, val);
    }

    public void setPortCallback(int pin, Object callback) {
        SignalHandler scb;
        if (callback instanceof SignalHandler) {
            scb = (SignalHandler)callback;
            this.scheduleUpdate();
        } else {
            scb = null;
        }
        if (pin == 4) {
            this.output0 = scb;
        } else {
            this.output1 = scb;
        }
    }

    @Override
    protected void resetPin(int pin) {
        this.getPortCallback(pin).updateSignal(0);
    }

    public void process() {
        int val = this.computeResult();
        this.tick = 0;
        while (this.delayed != null) {
            this.inputs[this.delayed.id] = this.delayed.value;
            this.delayed = this.delayed.next;
            this.scheduleUpdate();
        }
        if (this.output0 != null) {
            this.output0.updateSignal(val);
        }
        if (this.output1 != null) {
            this.output1.updateSignal(val);
        }
    }

    protected abstract int computeResult();

    protected void setInput(int pin, int val) {
        if (val != this.inputs[pin]) {
            if (this.tick == 0) {
                this.tick = TickRegistry.TICK;
                TickRegistry.schedule((TickRegistry.IUpdatable)this);
            } else if (this.tick != TickRegistry.TICK) {
                this.delayed = new DelayedSignal(pin, val, this.delayed);
                return;
            }
            this.inputs[pin] = val;
        }
    }

    protected void scheduleUpdate() {
        if (this.tick != 0) {
            return;
        }
        this.tick = TickRegistry.TICK;
        TickRegistry.schedule((TickRegistry.IUpdatable)this);
    }

    protected void refreshInput(int pin) {
        MountedPort port = this.ports[pin];
        if (port.getConnector() != null) {
            port.onUnload();
            port.onLoad();
        } else {
            this.getPortCallback(pin).updateSignal(0);
        }
    }

    @Override
    protected void storeState(NBTTagCompound nbt, int mode) {
        if (mode == 0) {
            nbt.func_74783_a("states", this.inputs);
        }
        super.storeState(nbt, mode);
    }

    @Override
    protected void loadState(NBTTagCompound nbt, int mode) {
        super.loadState(nbt, mode);
        if (mode == 0) {
            int[] arr = nbt.func_74759_k("states");
            System.arraycopy(arr, 0, this.inputs, 0, Math.min(arr.length, this.inputs.length));
            this.tick = 0;
        }
    }

    @Override
    public Object getState(int id) {
        return id < this.inputs.length ? this.inputs[id] : this.computeResult();
    }
}

