/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity;

import cd4017be.api.rs_ctr.com.DelayedSignal;
import cd4017be.api.rs_ctr.com.EnergyHandler;
import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.interact.IInteractiveComponent;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.lib.Gui.AdvancedContainer;
import cd4017be.lib.TickRegistry;
import cd4017be.lib.block.AdvancedBlock;
import cd4017be.lib.network.GuiNetworkHandler;
import cd4017be.lib.network.IGuiHandlerTile;
import cd4017be.lib.network.StateSyncClient;
import cd4017be.lib.network.StateSyncServer;
import cd4017be.lib.network.StateSynchronizer;
import cd4017be.lib.util.ItemFluidUtil;
import cd4017be.lib.util.Orientation;
import cd4017be.lib.util.Utils;
import cd4017be.rs_ctr.Objects;
import cd4017be.rs_ctr.circuit.Circuit;
import cd4017be.rs_ctr.circuit.CompiledCircuit;
import cd4017be.rs_ctr.circuit.UnloadedCircuit;
import cd4017be.rs_ctr.gui.BlockButton;
import cd4017be.rs_ctr.gui.GuiProcessor;
import cd4017be.rs_ctr.tileentity.IProcessor;
import cd4017be.rs_ctr.tileentity.WallMountGate;
import cd4017be.rscpl.util.StateBuffer;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Processor
extends WallMountGate
implements TickRegistry.IUpdatable,
AdvancedBlock.ITilePlaceHarvest,
IGuiHandlerTile,
AdvancedContainer.IStateInteractionHandler,
IProcessor {
    public static int BURNOUT_INTERVAL = 50;
    ItemStack[] ingreds = new ItemStack[0];
    int[] stats = new int[6];
    String name = "";
    BlockButton coreBtn = new BlockButton(null, () -> null, () -> this.name + "\n" + this.getError()){

        @Override
        public boolean onInteract(EntityPlayer player, boolean hit, EnumFacing side, Vec3d aim) {
            if (!hit) {
                GuiNetworkHandler.openBlockGui((EntityPlayer)player, (BlockPos)Processor.this.field_174879_c, (int)0);
            }
            return true;
        }
    }.setSize(0.25f, 0.25f);
    public Circuit circuit;
    SignalHandler[] callbacks;
    EnergyHandler energySup;
    private long lastTick = 0L;
    public int energy;
    public int cap;
    public int usage;
    public int gain;
    public byte tick;
    public String lastError;
    DelayedSignal delayed;
    String[] keys = new String[0];
    boolean isBGA;

    public Processor() {
        this.ports = new MountedPort[]{new MountedPort((IPortProvider)this, 0, EnergyHandler.class, true)};
    }

    public void process() {
        this.tick = 0;
        if (this.unloaded) {
            return;
        }
        long t = this.field_145850_b.func_82737_E();
        if (this.lastTick > t) {
            return;
        }
        if (this.usage > 0) {
            int e = this.energy - this.usage + (int)(t - this.lastTick) * this.gain;
            if (e >= 0) {
                this.energy = e <= this.cap ? e : this.cap;
            } else if (this.energySup != null && (e -= this.energySup.changeEnergy(e - this.cap, false)) >= 0) {
                this.energy = e;
            } else {
                this.doBurnout(false);
                this.lastError = "power depleted";
                this.energy = BURNOUT_INTERVAL * this.gain;
                this.markDirty(2);
                return;
            }
        }
        this.lastTick = t;
        try {
            int d = this.circuit.tick();
            while (this.delayed != null) {
                this.circuit.inputs[this.delayed.id] = this.delayed.value;
                this.delayed = this.delayed.next;
                d |= 1;
            }
            if ((d & 1) != 0) {
                this.tick = TickRegistry.TICK;
                TickRegistry.schedule((TickRegistry.IUpdatable)this);
            }
            d >>>= 1;
            int i = 0;
            while (d != 0) {
                if ((d & 1) != 0 && this.callbacks[i] != null) {
                    this.callbacks[i].updateSignal(this.circuit.outputs[i]);
                }
                ++i;
                d >>>= 1;
            }
            if (this.lastError != null) {
                this.lastError = null;
                this.markDirty(2);
            }
        }
        catch (Throwable e) {
            this.lastError = this.circuit.processError(e, (TileEntity)this);
            if (this.lastError == null) {
                this.lastError = "BUG! see log";
                this.doBurnout(true);
            } else {
                this.doBurnout(false);
            }
            this.markDirty(2);
        }
    }

    public void doBurnout(boolean hard) {
        Random rand = this.field_145850_b.field_73012_v;
        this.field_145850_b.func_184133_a((EntityPlayer)null, this.field_174879_c, hard ? SoundEvents.field_187539_bB : SoundEvents.field_187745_eA, SoundCategory.BLOCKS, hard ? 5.0f : 0.5f, 2.6f + (rand.nextFloat() - rand.nextFloat()) * 0.8f);
        for (int i = 0; i < 5; ++i) {
            double d0 = (double)this.field_174879_c.func_177958_n() + rand.nextDouble() * 0.6 + 0.2;
            double d1 = (double)this.field_174879_c.func_177956_o() + rand.nextDouble() * 0.6 + 0.2;
            double d2 = (double)this.field_174879_c.func_177952_p() + rand.nextDouble() * 0.6 + 0.2;
            this.field_145850_b.func_175688_a(hard ? EnumParticleTypes.SMOKE_LARGE : EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
        this.lastTick = hard ? Long.MAX_VALUE : this.field_145850_b.func_82737_E() + (long)BURNOUT_INTERVAL;
    }

    public SignalHandler getPortCallback(int pin) {
        int[] inputs = this.circuit.inputs;
        return this.circuit.isInterrupt(pin) ? val -> {
            if (inputs[pin] == val) {
                return;
            }
            if (this.tick == 0) {
                this.tick = TickRegistry.TICK;
                TickRegistry.schedule((TickRegistry.IUpdatable)this);
            } else if (this.tick != TickRegistry.TICK) {
                this.delayed = new DelayedSignal(pin, val, this.delayed);
                return;
            }
            inputs[pin] = val;
        } : val -> {
            inputs[pin] = val;
        };
    }

    public void setPortCallback(int pin, Object callback) {
        if (pin == this.ports.length - 1) {
            this.energySup = callback instanceof EnergyHandler ? (EnergyHandler)callback : null;
        } else {
            SignalHandler scb = callback instanceof SignalHandler ? (SignalHandler)callback : null;
            this.callbacks[pin -= this.circuit.inputs.length] = scb;
            if (scb != null) {
                scb.updateSignal(this.circuit.outputs[pin]);
            }
        }
    }

    @Override
    protected void resetPin(int pin) {
        this.getPortCallback(pin).updateSignal(0);
    }

    @Override
    protected void storeState(NBTTagCompound nbt, int mode) {
        super.storeState(nbt, mode);
        if (mode <= 1 || mode == 4) {
            nbt.func_179237_a(this.circuit.serializeNBT());
            NBTTagList names = new NBTTagList();
            for (MountedPort port : this.ports) {
                String n = port.name;
                names.func_74742_a((NBTBase)new NBTTagString(n.isEmpty() ? n : n.substring(1)));
            }
            nbt.func_74782_a("labels", (NBTBase)names);
            nbt.func_74778_a("name", this.name);
            nbt.func_74783_a("stats", this.stats);
            if (mode != 1) {
                nbt.func_74782_a("ingr", (NBTBase)ItemFluidUtil.saveItems((ItemStack[])this.ingreds));
            }
            if (mode != 4) {
                nbt.func_74768_a("energy", this.energy);
                nbt.func_74774_a("type", (byte)(this.isBGA ? 1 : 0));
            }
        } else if (mode == 2 && this.lastError != null) {
            nbt.func_74778_a("err", this.lastError);
        }
        if (mode == 0) {
            nbt.func_74772_a("burnout", this.lastTick);
            nbt.func_74757_a("active", this.tick != 0);
        }
    }

    @Override
    protected void loadState(NBTTagCompound nbt, int mode) {
        if (mode <= 1 || mode == 4) {
            if (mode != 4) {
                this.isBGA = nbt.func_74771_c("type") != 0;
            }
            this.circuit = mode == 4 ? new CompiledCircuit() : new UnloadedCircuit();
            this.circuit.deserializeNBT(nbt);
            this.createPorts();
            NBTTagList names = nbt.func_150295_c("labels", 8);
            for (int i = this.ports.length - 2; i >= 0; --i) {
                this.ports[i].setName("\\" + names.func_150307_f(i));
            }
            this.name = nbt.func_74779_i("name");
            this.keys = this.circuit.getState().nbt.func_150296_c().toArray(this.keys);
            Arrays.sort(this.keys);
            int[] arr = nbt.func_74759_k("stats");
            System.arraycopy(arr, 0, this.stats, 0, Math.min(arr.length, this.stats.length));
            if (mode != 1) {
                this.ingreds = ItemFluidUtil.loadItems((NBTTagList)nbt.func_150295_c("ingr", 10));
            }
            this.energy = nbt.func_74762_e("energy");
            this.gain = this.stats[4];
            this.cap = this.stats[5];
            this.usage = this.stats[0] + this.stats[1];
            if (this.usage < this.gain) {
                this.usage = 0;
            }
        } else if (mode == 2) {
            this.lastError = nbt.func_150297_b("err", 8) ? nbt.func_74779_i("err") : null;
        }
        super.loadState(nbt, mode);
        if (mode == 0) {
            this.lastTick = nbt.func_74763_f("burnout");
            this.tick = (byte)(nbt.func_74767_n("active") ? 1 : 0);
        }
    }

    private void createPorts() {
        int in = this.circuit.inputs.length;
        int out = this.circuit.outputs.length;
        int oin = 4 - in >> 1;
        int oout = (4 - out >> 1) - in;
        this.ports = new MountedPort[(out += in) + 1];
        for (int i = 0; i < out; ++i) {
            int k;
            int j;
            MountedPort port;
            this.ports[i] = port = new MountedPort((IPortProvider)this, i, SignalHandler.class, i >= in);
            if (this.isBGA) {
                j = (i < in ? i : i - in) & 3;
                k = i < in ? i >> 2 : 3 - (i - in >> 2);
                port.setLocation(0.125 + (double)k * 0.25, 0.875 - (double)j * 0.25, 0.5, EnumFacing.NORTH, this.o);
                continue;
            }
            j = i + (i < in ? oin : oout);
            k = j < 0 ? 0 : (j > 3 ? 3 : j);
            j = k > j ? k - j : j - k;
            port.setLocation(i < in ? 0.125 + (double)j * 0.25 : 0.875 - (double)j * 0.25, 0.875 - (double)k * 0.25, 0.25, EnumFacing.SOUTH, this.o);
        }
        this.ports[out] = new MountedPort((IPortProvider)this, out, EnergyHandler.class, true).setLocation(0.5, 1.0, this.isBGA ? 0.625 : 0.125, EnumFacing.UP, this.o).setName("port.rs_ctr.energy_i");
    }

    @Override
    public void onLoad() {
        if (this.circuit == null) {
            this.circuit = new UnloadedCircuit();
        }
        if (!this.field_145850_b.field_72995_K) {
            this.circuit = this.circuit.load();
            this.callbacks = new SignalHandler[this.circuit.outputs.length];
            if (this.tick == 1) {
                this.tick = TickRegistry.TICK;
                TickRegistry.schedule((TickRegistry.IUpdatable)this);
            }
        }
        super.onLoad();
    }

    @Override
    protected void initGuiComps(List<IInteractiveComponent> list) {
        list.add(this.coreBtn);
    }

    @Override
    protected void orient(Orientation o) {
        this.coreBtn.setLocation(0.5, 0.5, this.isBGA ? 0.9375 : 0.4375, o);
        super.orient(o);
    }

    public void onPlaced(EntityLivingBase entity, ItemStack item) {
        NBTTagCompound nbt = item.func_77978_p();
        if (nbt == null) {
            return;
        }
        this.isBGA = item.func_77973_b() == Objects.processor3;
        this.loadState(nbt, 4);
        this.energy = this.cap;
        this.lastTick = this.field_145850_b.func_82737_E();
        this.tick = 1;
        this.unloaded = true;
        this.onLoad();
    }

    public List<ItemStack> dropItem(IBlockState state, int fortune) {
        return this.makeDefaultDrops();
    }

    @Override
    public String getName() {
        return "\\" + this.name;
    }

    @Override
    public String getError() {
        return this.lastError == null ? "\u00a7ano error" : "\u00a7c" + this.lastError;
    }

    @Override
    public String[] getIOLabels() {
        String[] io = new String[this.ports.length - 1];
        for (int i = 0; i < io.length; ++i) {
            String n = this.ports[i].name;
            io[i] = n.isEmpty() ? n : n.substring(1);
        }
        return io;
    }

    @Override
    public double getExhaustion() {
        return (double)(this.cap - this.energy) / (double)this.cap * 100.0;
    }

    @Override
    public Circuit getCircuit() {
        return this.circuit;
    }

    @Override
    public int getClockState() {
        return this.tick;
    }

    public AdvancedContainer getContainer(EntityPlayer player, int id) {
        return new AdvancedContainer((AdvancedContainer.IStateInteractionHandler)this, StateSynchronizer.builder().addFix(new int[]{1, 4}).addMulFix(4, this.circuit.inputs.length + this.circuit.outputs.length).addVar(this.keys.length).build(this.field_145850_b.field_72995_K), player);
    }

    public void writeState(StateSyncServer state, AdvancedContainer cont) {
        state.writeInt(this.tick > 0 ? 1 : 0).writeInt(Math.min(this.cap, this.energy + (int)(this.field_145850_b.func_82737_E() - this.lastTick - 1L) * this.gain));
        state.writeIntArray(this.circuit.inputs).writeIntArray(this.circuit.outputs).endFixed();
        NBTTagCompound nbt = this.circuit.getState().nbt;
        for (String key : this.keys) {
            Utils.writeTag((ByteBuf)state.buffer, (NBTBase)nbt.func_74781_a(key));
            state.put();
        }
    }

    public void readState(StateSyncClient state, AdvancedContainer cont) {
        this.tick = (byte)state.get((int)this.tick);
        this.energy = state.get(this.energy);
        this.circuit.inputs = state.get(this.circuit.inputs);
        this.circuit.outputs = state.get(this.circuit.outputs);
        NBTTagCompound nbt = this.circuit.getState().nbt;
        for (String key : this.keys) {
            if (!state.next()) continue;
            nbt.func_74782_a(key, Utils.readTag((ByteBuf)state.buffer, (byte)nbt.func_150299_b(key)));
        }
    }

    public boolean canInteract(EntityPlayer player, AdvancedContainer cont) {
        return this.canPlayerAccessUI(player);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiProcessor getGuiScreen(EntityPlayer player, int id) {
        return new GuiProcessor(this, this.getContainer(player, id));
    }

    public void handleAction(PacketBuffer pkt, EntityPlayerMP sender) throws Exception {
        String key;
        short var = pkt.readUnsignedByte();
        if (var == 255) {
            if (this.tick == 0) {
                this.tick = TickRegistry.TICK;
                TickRegistry.schedule((TickRegistry.IUpdatable)this);
            }
            return;
        }
        if (var >= this.keys.length || (key = this.keys[var]) == null) {
            return;
        }
        StateBuffer state = this.circuit.getState();
        state.nbt.func_74782_a(key, Utils.readTag((ByteBuf)pkt, (byte)state.nbt.func_150299_b(key)));
        this.circuit.setState(state);
    }

    @Override
    public Object getState(int id) {
        return id < this.circuit.inputs.length ? this.circuit.inputs[id] : ((id -= this.circuit.inputs.length) < this.circuit.outputs.length ? Integer.valueOf(this.circuit.outputs[id]) : null);
    }
}

