/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity;

import cd4017be.api.rs_ctr.com.BlockReference;
import cd4017be.api.rs_ctr.com.EnergyHandler;
import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.lib.capability.BlockFluidWrapper;
import cd4017be.lib.tileentity.BaseTileEntity;
import cd4017be.rs_ctr.tileentity.WallMountGate;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidTranslocator
extends WallMountGate
implements BaseTileEntity.ITickableServerOnly {
    public static int BASE_COST = -100;
    public static int TRANSFER_COST = -500;
    public static int BLOCK_COST = -500;
    BlockReference ref0;
    BlockReference ref1;
    EnergyHandler energy = EnergyHandler.NOP;
    SignalHandler out;
    int amIn;
    int amOut;
    int clk;
    boolean update;

    public FluidTranslocator() {
        this.ports = new MountedPort[]{new MountedPort((IPortProvider)this, 0, BlockReference.BlockHandler.class, false).setLocation(0.875, 0.625, 0.25, EnumFacing.NORTH).setName("port.rs_ctr.tank0"), new MountedPort((IPortProvider)this, 1, BlockReference.BlockHandler.class, false).setLocation(0.125, 0.625, 0.25, EnumFacing.NORTH).setName("port.rs_ctr.tank1"), new MountedPort((IPortProvider)this, 2, EnergyHandler.class, true).setLocation(0.375, 0.25, 0.125, EnumFacing.UP).setName("port.rs_ctr.energy_i"), new MountedPort((IPortProvider)this, 3, SignalHandler.class, false).setLocation(0.625, 0.25, 0.125, EnumFacing.UP).setName("port.rs_ctr.clk"), new MountedPort((IPortProvider)this, 4, SignalHandler.class, false).setLocation(0.875, 0.25, 0.125, EnumFacing.UP).setName("port.rs_ctr.am_i"), new MountedPort((IPortProvider)this, 5, SignalHandler.class, true).setLocation(0.125, 0.25, 0.125, EnumFacing.UP).setName("port.rs_ctr.am_o")};
    }

    public Object getPortCallback(int pin) {
        switch (pin) {
            case 0: {
                return ref -> {
                    this.ref0 = ref;
                };
            }
            case 1: {
                return ref -> {
                    this.ref1 = ref;
                };
            }
            case 3: {
                return val -> {
                    if (val == this.clk) {
                        return;
                    }
                    this.clk = val;
                    this.update = true;
                };
            }
            case 4: {
                return val -> {
                    this.amIn = val;
                };
            }
        }
        return null;
    }

    public void setPortCallback(int pin, Object callback) {
        switch (pin) {
            case 2: {
                this.energy = callback instanceof EnergyHandler ? (EnergyHandler)callback : EnergyHandler.NOP;
                break;
            }
            case 5: {
                if (callback instanceof SignalHandler) {
                    this.out = (SignalHandler)callback;
                    this.out.updateSignal(this.amOut);
                    break;
                }
                this.out = null;
            }
        }
    }

    @Override
    protected void resetPin(int pin) {
        switch (pin) {
            case 0: {
                this.ref0 = null;
                break;
            }
            case 1: {
                this.ref1 = null;
                break;
            }
            case 3: {
                this.clk = 0;
                break;
            }
            case 4: {
                this.amIn = 0;
            }
        }
    }

    public void func_73660_a() {
        if (!this.update) {
            return;
        }
        this.update = false;
        int n = this.transfer(this.amIn);
        if (this.amOut != n) {
            this.amOut = n;
            if (this.out != null) {
                this.out.updateSignal(n);
            }
        }
    }

    private int transfer(int am) {
        if (am == 0 || this.ref0 == null || this.ref1 == null || !this.ref0.isLoaded() || !this.ref1.isLoaded()) {
            return 0;
        }
        int e = FluidTranslocator.cost(am);
        if (this.energy.changeEnergy(e, true) != e) {
            return 0;
        }
        IFluidHandler inv0 = (IFluidHandler)this.ref0.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
        IFluidHandler inv1 = (IFluidHandler)this.ref1.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
        e = 0;
        if (inv0 == null) {
            inv0 = new BlockFluidWrapper().set(this.ref0.world(), this.ref0.pos);
            ++e;
        }
        if (inv1 == null) {
            inv1 = new BlockFluidWrapper().set(this.ref1.world(), this.ref1.pos);
            ++e;
        }
        am = am > 0 ? this.transfer(am, inv0, inv1) : -this.transfer(-am, inv1, inv0);
        this.energy.changeEnergy(am == 0 ? BASE_COST : FluidTranslocator.cost(am) + e * BLOCK_COST, false);
        return am;
    }

    private static int cost(int am) {
        if (am < 0) {
            am = -am;
        }
        return (int)Math.min((long)am * (long)TRANSFER_COST / 1000L + (long)BASE_COST, Integer.MAX_VALUE);
    }

    private int transfer(int am, IFluidHandler fromInv, IFluidHandler toInv) {
        if (fromInv == null || toInv == null) {
            return 0;
        }
        FluidStack stack = fromInv.drain(am, false);
        if (stack == null) {
            am = 0;
        } else {
            am = toInv.fill(stack, true);
            if (am > 0) {
                fromInv.drain(new FluidStack(stack, am), true);
            }
        }
        return am;
    }

    @Override
    protected void storeState(NBTTagCompound nbt, int mode) {
        if (mode == 0) {
            nbt.func_74757_a("update", this.update);
            nbt.func_74768_a("in", this.amIn);
            nbt.func_74768_a("out", this.amOut);
            nbt.func_74768_a("clk", this.clk);
            if (this.ref0 != null) {
                nbt.func_74782_a("inv0", (NBTBase)this.ref0.serializeNBT());
            } else {
                nbt.func_82580_o("inv0");
            }
            if (this.ref1 != null) {
                nbt.func_74782_a("inv1", (NBTBase)this.ref1.serializeNBT());
            } else {
                nbt.func_82580_o("inv1");
            }
        }
        super.storeState(nbt, mode);
    }

    @Override
    protected void loadState(NBTTagCompound nbt, int mode) {
        if (mode == 0) {
            this.update = nbt.func_74767_n("update");
            this.amIn = nbt.func_74762_e("in");
            this.amOut = nbt.func_74762_e("out");
            this.clk = nbt.func_74762_e("clk");
            this.ref0 = nbt.func_150297_b("inv0", 10) ? new BlockReference(nbt.func_74775_l("inv0")) : null;
            this.ref1 = nbt.func_150297_b("inv1", 10) ? new BlockReference(nbt.func_74775_l("inv1")) : null;
        }
        super.loadState(nbt, mode);
    }

    @Override
    public Object getState(int id) {
        switch (id) {
            case 0: {
                return this.ref0;
            }
            case 1: {
                return this.ref1;
            }
            case 3: {
                return this.clk;
            }
            case 4: {
                return this.amIn;
            }
            case 5: {
                return this.amOut;
            }
        }
        return null;
    }
}

