/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.port;

import cd4017be.api.rs_ctr.interact.IInteractiveComponent;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.api.rs_ctr.port.Port;
import cd4017be.api.rs_ctr.wire.WiredConnector;
import cd4017be.lib.util.DimPos;
import cd4017be.rs_ctr.port.WireType;
import cd4017be.rs_ctr.render.WireRenderer;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WireBranch
extends WiredConnector
implements IInteractiveComponent.ITESRenderComp,
IInteractiveComponent.IBlockRenderComp {
    public final WireType type;
    protected Vec3d line;
    public int length;
    private float[] vertices;
    private int light1 = -1;

    public WireBranch(MountedPort port, WireType type) {
        super(port);
        this.type = type;
    }

    protected String id() {
        return this.type.wiredId;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_74776_a("dx", (float)this.line.field_72450_a);
        nbt.func_74776_a("dy", (float)this.line.field_72448_b);
        nbt.func_74776_a("dz", (float)this.line.field_72449_c);
        nbt.func_74774_a("len", (byte)this.length);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt.func_150297_b("pos", 4)) {
            this.conPos = new DimPos((Vec3i)BlockPos.func_177969_a((long)nbt.func_74763_f("pos")), 0);
            this.conPin = nbt.func_74762_e("pin");
            this.tag = nbt.func_150297_b("tag", 8) ? nbt.func_74779_i("tag") : null;
            this.length = nbt.func_74771_c("count") & 0xFF;
        } else {
            super.deserializeNBT(nbt);
            this.length = nbt.func_74771_c("len") & 0xFF;
        }
        this.line = new Vec3d((double)nbt.func_74760_g("dx"), (double)nbt.func_74760_g("dy"), (double)nbt.func_74760_g("dz"));
    }

    public void onRemoved(EntityPlayer player) {
        super.onRemoved(player);
        this.dropItem(new ItemStack(this.type.wireItem, this.length), player);
    }

    protected void onMoved(WiredConnector link) {
        int d = (int)Math.ceil(WireBranch.getDistance((MountedPort)this.port, (MountedPort)link.port));
        if (d > this.length + (link instanceof WireBranch ? ((WireBranch)link).length : 0)) {
            this.onWireRemoved(link, null);
        } else {
            this.line = WireBranch.getPath((MountedPort)this.port, (MountedPort)link.port).func_186678_a(0.5);
            this.port.owner.onPortModified((Port)this.port, 16);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void render(World world, BlockPos pos, double x, double y, double z, int light, BufferBuilder buffer) {
        if (this.line == null) {
            return;
        }
        if (this.vertices == null) {
            this.vertices = WireRenderer.createLine(this.port, this.line);
        }
        if (this.light1 < 0) {
            this.light1 = this.port.getWorld().func_175626_b(this.port.getPos().func_177963_a(this.line.field_72450_a + this.port.pos.field_72450_a, this.line.field_72448_b + this.port.pos.field_72448_b, this.line.field_72449_c + this.port.pos.field_72449_c), 0);
        }
        WireRenderer.drawLine(buffer, this.vertices, (float)x, (float)y, (float)z, light, this.light1, this.type.color);
    }

    public AxisAlignedBB getRenderBB(World world, BlockPos pos) {
        if (this.line == null) {
            return null;
        }
        Vec3d p = new Vec3d((Vec3i)pos).func_178787_e(this.port.pos);
        return new AxisAlignedBB(p, p.func_178787_e(this.line));
    }

    @SideOnly(value=Side.CLIENT)
    public void render(List<BakedQuad> quads) {
        this.light1 = -1;
    }

    public boolean isCompatible(Class<?> type) {
        return type == this.type.clazz;
    }
}

