/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.port;

import cd4017be.api.rs_ctr.interact.IInteractiveComponent;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.wire.RelayPort;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr.Objects;
import cd4017be.rs_ctr.render.PortRenderer;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WireAnchor
extends RelayPort
implements IInteractiveComponent.IBlockRenderComp {
    public int orient;

    public WireAnchor(IPortProvider owner, int pin) {
        super(owner, pin);
        this.orient = pin >> 16 & 0x3F;
    }

    public WireAnchor(WireAnchor opposite) {
        super((RelayPort)opposite);
    }

    protected RelayPort createPair() {
        return new WireAnchor(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void render(List<BakedQuad> quads) {
        PortRenderer.PORT_RENDER.drawModel(quads, (float)this.pos.field_72450_a, (float)this.pos.field_72448_b, (float)this.pos.field_72449_c, Orientation.values()[this.orient >> 8 & 0xF], "_hook.pin(" + Integer.toString(this.orient >> 12 & 3) + ")");
    }

    public void orient(Orientation o) {
        int or;
        this.setLocation((double)(this.pin & 3) * 0.25 + 0.125, (double)(this.pin >> 4 & 3) * 0.25 + 0.125, (double)(this.pin >> 8 & 3) * 0.25 + 0.125, this.face, o);
        int x = (this.orient & 3) - 2;
        int y = (this.orient >> 2 & 3) - 2;
        int z = (this.orient >> 4 & 3) - 2;
        Vec3d vec = o.rotate(new Vec3d((double)x, (double)y, (double)z));
        x = (int)vec.field_72450_a;
        y = (int)vec.field_72448_b;
        z = (int)vec.field_72449_c;
        int l = x * x + y * y + z * z;
        switch (l) {
            case 1: {
                or = z != 0 ? (z < 0 ? 0 : 2) : (x != 0 ? (x < 0 ? 3 : 1) : (y < 0 ? 4 : 12));
                break;
            }
            case 2: {
                if (y != 0) {
                    int n = x < 0 ? 4 : (z < 0 ? 5 : (or = z == 0 ? 6 : 7));
                    if (y <= 0) break;
                    or += 8;
                    break;
                }
            }
            case 3: {
                int n = or = x > 0 ? 1 : 0;
                if (z > 0) {
                    or = 3 - or;
                }
                if (y <= 0) break;
                or = or + 1 & 3 | 8;
                break;
            }
            default: {
                or = 0;
            }
        }
        this.orient = this.orient & 0x3F | or << 8 | l << 12;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_74774_a("o", (byte)this.orient);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        this.orient = nbt.func_74771_c("o");
    }

    public ItemStack getDropped() {
        return new ItemStack((Item)Objects.wire_anchor);
    }
}

