/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.port;

import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.interact.IInteractiveComponent;
import cd4017be.api.rs_ctr.port.Connector;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.api.rs_ctr.port.Port;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr.Objects;
import cd4017be.rs_ctr.render.PortRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class StatusLamp
extends Connector
implements SignalHandler,
IInteractiveComponent.ITESRenderComp {
    public static final String ID = "lamp";
    private int state;

    public StatusLamp(MountedPort port) {
        super(port);
    }

    protected String id() {
        return ID;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_74768_a("state", this.state);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.state = nbt.func_74762_e("state");
    }

    @SideOnly(value=Side.CLIENT)
    public void render(World world, BlockPos pos, double x, double y, double z, int light, BufferBuilder buffer) {
        if (this.state > 0) {
            light = light & 0xFFFF0000 | 0xEF;
        }
        PortRenderer.PORT_RENDER.drawModel(buffer, (float)(x + this.port.pos.field_72450_a), (float)(y + this.port.pos.field_72448_b), (float)(z + this.port.pos.field_72449_c), Orientation.fromFacing((EnumFacing)this.port.face), light, this.state > 0 ? "_plug.misc(1)" : "_plug.misc(0)");
    }

    public AxisAlignedBB getRenderBB(World world, BlockPos pos) {
        return null;
    }

    public String displayInfo(MountedPort port, int linkID) {
        return "\n" + this.state + "\nx" + Integer.toHexString(this.state);
    }

    public void onRemoved(EntityPlayer player) {
        this.dropItem(new ItemStack((Item)Objects.lamp), player);
    }

    public void onLoad() {
        this.port.owner.setPortCallback(this.port.pin, (Object)this);
    }

    public void onUnload() {
        this.port.owner.setPortCallback(this.port.pin, null);
    }

    public void updateSignal(int value) {
        this.state = value;
        this.port.owner.onPortModified((Port)this.port, 16);
    }
}

