/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.port;

import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.lib.TickRegistry;
import cd4017be.lib.util.Orientation;
import cd4017be.lib.util.TooltipUtil;
import cd4017be.rs_ctr.Objects;
import cd4017be.rs_ctr.port.LogicPlug;
import cd4017be.rs_ctr.render.PortRenderer;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class PulseGen
extends LogicPlug
implements TickRegistry.IUpdatable {
    public static final String ID = "pulse_gen";
    private static final byte S_OFF = 0;
    private static final byte S_RISE = 1;
    private static final byte S_ON = 2;
    private static final byte S_FALL = 3;
    int last;
    byte state;
    byte tick;

    public PulseGen(MountedPort port) {
        super(port);
    }

    public void updateSignal(int value) {
        if (value == this.last) {
            return;
        }
        this.last = value;
        if (this.tick == 0) {
            this.tick = TickRegistry.TICK;
            TickRegistry.schedule((TickRegistry.IUpdatable)this);
            this.state = 1;
        } else if (this.tick != TickRegistry.TICK) {
            this.tick = TickRegistry.TICK;
        } else if (this.state == 3) {
            this.state = (byte)2;
        }
    }

    public void process() {
        boolean repulse = this.tick == TickRegistry.TICK;
        switch (this.state) {
            case 1: {
                if (repulse) {
                    this.state = (byte)2;
                } else {
                    this.state = (byte)3;
                    this.tick = TickRegistry.TICK;
                }
                TickRegistry.schedule((TickRegistry.IUpdatable)this);
                this.out.updateSignal(65535);
                break;
            }
            case 2: {
                if (!repulse) {
                    this.state = (byte)3;
                    this.tick = TickRegistry.TICK;
                }
                TickRegistry.schedule((TickRegistry.IUpdatable)this);
                break;
            }
            case 3: {
                if (repulse) {
                    this.state = 1;
                    TickRegistry.schedule((TickRegistry.IUpdatable)this);
                } else {
                    this.state = 0;
                    this.tick = 0;
                }
                this.out.updateSignal(0);
                break;
            }
            default: {
                this.state = 0;
                this.tick = 0;
            }
        }
    }

    @Override
    protected int getOutput() {
        return this.state >= 2 ? 65535 : 0;
    }

    protected String id() {
        return ID;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_74768_a("last", this.last);
        nbt.func_74774_a("state", this.state);
        return nbt;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        this.last = nbt.func_74762_e("last");
        this.state = nbt.func_74771_c("state");
    }

    @Override
    public void onRemoved(EntityPlayer player) {
        super.onRemoved(player);
        this.dropItem(new ItemStack((Item)Objects.pulse_gen), player);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.state != 0 && this.tick == 0) {
            this.tick = TickRegistry.TICK;
            TickRegistry.schedule((TickRegistry.IUpdatable)this);
        }
    }

    public String displayInfo(MountedPort port, int linkID) {
        return TooltipUtil.translate((String)"port.rs_ctr.pulse") + super.displayInfo(port, this.outPort.getLink());
    }

    @Override
    public void render(List<BakedQuad> quads) {
        super.render(quads);
        PortRenderer.PORT_RENDER.drawModel(quads, (float)this.port.pos.field_72450_a, (float)this.port.pos.field_72448_b, (float)this.port.pos.field_72449_c, Orientation.fromFacing((EnumFacing)this.port.face), "_plug.misc(4)");
    }
}

