/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.port;

import cd4017be.api.rs_ctr.com.BlockReference;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.rs_ctr.Objects;
import cd4017be.rs_ctr.port.SplitPlug;
import cd4017be.rs_ctr.port.WireType;
import java.util.Arrays;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class BlockSplitPlug
extends SplitPlug
implements BlockReference.BlockHandler {
    BlockReference.BlockHandler[] callbacks;
    BlockReference lastValue;

    public BlockSplitPlug(MountedPort port) {
        super(port);
    }

    @Override
    public int addLinks(int n) {
        n = super.addLinks(n);
        this.callbacks = this.callbacks == null ? new BlockReference.BlockHandler[n] : Arrays.copyOf(this.callbacks, this.wires.length);
        return n;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        this.callbacks = new BlockReference.BlockHandler[this.wires.length];
    }

    public void setPortCallback(int pin, Object callback) {
        if (callback instanceof BlockReference.BlockHandler) {
            BlockReference.BlockHandler blockHandler = (BlockReference.BlockHandler)callback;
            this.callbacks[pin - 1] = blockHandler;
            blockHandler.updateBlock(this.lastValue);
        } else {
            this.callbacks[pin - 1] = null;
        }
    }

    @Override
    protected WireType type() {
        return WireType.BLOCK;
    }

    @Override
    protected ItemStack drop() {
        return new ItemStack((Item)Objects.split_b, this.wires.length);
    }

    public void updateBlock(BlockReference value) {
        if (BlockReference.equal((BlockReference)value, (BlockReference)this.lastValue)) {
            return;
        }
        this.lastValue = value;
        for (BlockReference.BlockHandler h : this.callbacks) {
            if (h == null) continue;
            h.updateBlock(value);
        }
    }
}

