/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.gui;

import cd4017be.lib.Gui.comp.Button;
import cd4017be.lib.Gui.comp.FormatText;
import cd4017be.lib.Gui.comp.FrameGrip;
import cd4017be.lib.Gui.comp.GuiCompGroup;
import cd4017be.lib.Gui.comp.GuiFrame;
import cd4017be.lib.Gui.comp.Spinner;
import cd4017be.rs_ctr.circuit.Circuit;
import cd4017be.rs_ctr.circuit.CompiledCircuit;
import cd4017be.rscpl.gui.StateEditor;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class GuiDebugger
extends GuiFrame {
    private static final ResourceLocation TEX = new ResourceLocation("rs_ctr", "textures/gui/palette.png");
    public final Circuit circuit;
    private int interval = 1;
    private int timer = Integer.MIN_VALUE;
    private int dirty = 1;
    private int cycles = 0;
    private final StateEditor state;
    private String lastErr = "";

    public GuiDebugger(GuiFrame parent, CompiledCircuit circuit) {
        this(parent, circuit, circuit.inputs.length, circuit.outputs.length);
    }

    private GuiDebugger(GuiFrame parent, CompiledCircuit circuit, int in, int out) {
        super(parent, 168, 33, 6);
        this.circuit = circuit.load();
        this.background(TEX, 0, 114);
        this.title("gui.rs_ctr.debug.name", 0.5f);
        new FrameGrip((GuiCompGroup)this, 8, 8, 0, 0);
        new Button((GuiCompGroup)this, 8, 8, this.w - 8, 0, 0, null, i -> this.close()).tooltip("gui.cd4017be.close");
        new Spinner((GuiCompGroup)this, 36, 18, 7, 15, false, "\\%.2fs", () -> (double)this.interval / 20.0, v -> {
            this.interval = (int)Math.round(v * 20.0);
        }, 0.05, 60.0, new double[]{1.0, 0.05}).tooltip("gui.rs_ctr.interval");
        new Button((GuiCompGroup)this, 18, 18, 43, 15, 2, () -> this.timer < -this.interval ? 1 : 0, s -> {
            this.timer = s == 0 ? -this.interval : Integer.MIN_VALUE;
        }).texture(168, 184).tooltip("gui.rs_ctr.debug.run#");
        new Button((GuiCompGroup)this, 18, 18, 61, 15, 0, () -> this.dirty & 1, this::tickChip).texture(168, 220).tooltip("gui.rs_ctr.debug.step#");
        new FormatText((GuiCompGroup)this, 80, 8, 80, 16, "\\%s", () -> new Object[]{this.lastErr});
        new FormatText((GuiCompGroup)this, 62, 8, 80, 24, "\\cycle: %d", () -> new Object[]{this.cycles});
        new Button((GuiCompGroup)this, 62, 7, 80, 24, 0, null, b -> {
            this.cycles = 0;
        }).tooltip("gui.rs_ctr.debug.reset");
        this.state = StateEditor.of(this, this.circuit, circuit.ioLabels, 6, this::modify, true);
        this.state.move(0, this.h);
        new Button((GuiCompGroup)this, 18, 9, 143, 24, 2, () -> this.state.hex ? 1 : 0, s -> {
            this.state.hex = s != 0;
        }).texture(168, 166).tooltip("gui.rs_ctr.hex#");
    }

    private void modify(int var) {
        if (var < 0 && this.circuit.isInterrupt(-1 - var)) {
            this.dirty |= 1;
        }
    }

    public void update() {
        if (++this.timer < 0) {
            return;
        }
        this.timer -= this.interval;
        this.tickChip(-1);
    }

    private void tickChip(int b) {
        if (b < 0 && (this.dirty & 1) == 0) {
            return;
        }
        try {
            this.dirty = this.circuit.tick();
            this.lastErr = "\u00a7ano error";
        }
        catch (Throwable e) {
            String err = this.circuit.processError(e, null);
            this.lastErr = "\u00a7c" + (err != null ? err : "BUG! see log");
            this.dirty = 0;
        }
        ++this.cycles;
        this.state.update();
    }

    public void close() {
        this.parent.remove((Object)this);
    }

    public void drawBackground(int mx, int my, float t) {
        GlStateManager.func_179097_i();
        super.drawBackground(mx, my, t);
        GlStateManager.func_179126_j();
    }

    public boolean keyIn(char c, int k, byte d) {
        if (k == 1) {
            this.close();
            return true;
        }
        return super.keyIn(c, k, d);
    }
}

