/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.circuit.gates;

import cd4017be.lib.Gui.comp.GuiFrame;
import cd4017be.lib.Gui.comp.IGuiComp;
import cd4017be.lib.Gui.comp.TextField;
import cd4017be.rs_ctr.circuit.editor.GeneratedGate;
import cd4017be.rs_ctr.circuit.editor.GeneratedType;
import cd4017be.rscpl.editor.InvalidSchematicException;
import cd4017be.rscpl.gui.GateTextureHandler;
import cd4017be.rscpl.gui.ISpecialCfg;
import cd4017be.rscpl.gui.ISpecialRender;
import cd4017be.rscpl.gui.SchematicBoard;
import org.objectweb.asm.Type;

public class ConstNum
extends GeneratedGate
implements ISpecialRender,
ISpecialCfg {
    public Number value;

    public ConstNum(GeneratedType type, int index) {
        super(type, index);
    }

    @Override
    public void checkValid() throws InvalidSchematicException {
        super.checkValid();
        try {
            this.value = ConstNum.parse(this.label, this.type.getOutType(0));
        }
        catch (NumberFormatException e) {
            throw new InvalidSchematicException(7, this, 0);
        }
    }

    @Override
    public void draw(SchematicBoard board, int x, int y) {
        GateTextureHandler.drawTinyText(((GuiFrame)board.parent).getDraw(), this.label, x + this.type.width - 4, y + 2, 5, ((GuiFrame)board.parent).zLevel + 1.0f);
    }

    public static Number parse(String s, Type t) throws NumberFormatException {
        int rad;
        if (s.isEmpty()) {
            throw new NumberFormatException();
        }
        boolean unsigned = false;
        if (s.charAt(0) == '+') {
            s = s.substring(1);
            unsigned = true;
        }
        if (s.charAt(0) == 'x') {
            s = s.substring(1);
            unsigned = true;
            rad = 16;
        } else if (s.charAt(0) == 'b') {
            s = s.substring(1);
            rad = 2;
        } else {
            rad = 10;
        }
        switch (t.getSort()) {
            case 5: {
                return unsigned ? Integer.parseUnsignedInt(s, rad) : Integer.parseInt(s, rad);
            }
            case 7: {
                return unsigned ? Long.parseUnsignedLong(s, rad) : Long.parseLong(s, rad);
            }
            case 6: {
                return Float.valueOf(s);
            }
            case 8: {
                return Double.valueOf(s);
            }
        }
        throw new NumberFormatException();
    }

    @Override
    public void setupCfgGUI(GuiFrame gui, Runnable updateCfg) {
        for (IGuiComp c : gui) {
            if (!(c instanceof TextField)) continue;
            ((TextField)c).tooltip("gui.rs_ctr.value");
        }
    }

    @Override
    public Object getParam(int i) {
        return this.value;
    }
}

