/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.circuit.editor;

import cd4017be.rs_ctr.circuit.data.GateConfiguration;
import cd4017be.rs_ctr.circuit.editor.ASMCode;
import cd4017be.rs_ctr.circuit.editor.GeneratedGate;
import cd4017be.rs_ctr.circuit.editor.GeneratedNode;
import cd4017be.rs_ctr.circuit.editor.IGateProvider;
import cd4017be.rs_ctr.circuit.editor.LinkVar;
import cd4017be.rs_ctr.circuit.editor.Placement;
import cd4017be.rscpl.compile.Dep;
import cd4017be.rscpl.compile.Node;
import cd4017be.rscpl.compile.NodeCompiler;
import cd4017be.rscpl.editor.Gate;
import cd4017be.rscpl.editor.GateType;
import cd4017be.rscpl.editor.InstructionSet;
import cd4017be.rscpl.editor.Pin;
import cd4017be.rscpl.util.IOUtils;
import com.google.common.base.Predicates;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.chars.CharArrayList;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.util.ResourceLocation;
import org.objectweb.asm.Type;

public class GeneratedType
extends GateType {
    public final int links;
    public final int end;
    public final Type[] inputs;
    public final LinkVar[] outputs;
    public final byte[] heights;
    public final GeneratedNode[] nodes;
    private final IGateProvider provider;
    public final GateConfiguration<?>[] cfg;
    public final Placement placementMode;
    private static final Predicate<GeneratedGate> alwaysTrue = Predicates.alwaysTrue();

    public GeneratedType(String name, int width, int height, byte[] heights, Type[] ins, int links, int end, LinkVar[] outs, GeneratedNode[] nodes, IGateProvider provider, GateConfiguration<?>[] cfg, Placement placement) {
        super(name, width, height);
        this.inputs = ins;
        this.links = links;
        this.outputs = outs;
        this.heights = heights;
        this.nodes = nodes;
        this.end = end;
        this.provider = provider;
        this.cfg = cfg;
        this.placementMode = placement;
    }

    @Override
    public Gate newGate(int index) {
        return this.provider.newGate(this, index);
    }

    @Override
    public int getInputHeight(int i) {
        return this.heights[i];
    }

    @Override
    public int getOutputHeight(int o) {
        return this.heights[o + this.inputs.length];
    }

    @Override
    public Type getOutType(int o) {
        return this.outputs[o].type;
    }

    @Override
    public Type getInType(int o) {
        return this.inputs[o];
    }

    @Override
    public boolean isInputTypeValid(int i, Type type) {
        if (i == this.end) {
            return true;
        }
        for (GeneratedNode n : this.nodes) {
            do {
                for (LinkVar v : n.inputs) {
                    if (v.name != i || !Dep.canConvert(type, v.type, false)) continue;
                    return true;
                }
            } while ((n = n.next) != null);
        }
        for (LinkVar v : this.outputs) {
            if (v.name != i || !Dep.canConvert(type, v.type, false)) continue;
            return true;
        }
        return false;
    }

    public Node getNode(GeneratedGate gate, int i) {
        if (i < this.inputs.length) {
            Pin p = gate.getInput(i);
            return p == null ? new Node(NodeCompiler.NOP, new Node[0]) : p.getNode();
        }
        Node node = gate.nodeCache[i -= this.inputs.length];
        if (node != null) {
            return node;
        }
        if (i < this.links) {
            node = gate.createLink(i);
        } else {
            GeneratedNode n = this.nodes[i - this.links];
            while ((node = n.createNode(this, gate)) == null && (n = n.next) != null) {
            }
        }
        gate.nodeCache[i] = node;
        return node;
    }

    @Override
    public Node createNode(Gate gate, int o) {
        return this.getNode((GeneratedGate)gate, this.outputs[o].name);
    }

    public static GeneratedType read(String id, JsonReader jr, InstructionSet inset) throws IOException {
        try {
            IGateProvider provider;
            jr.beginObject();
            int w = 3;
            String in = "";
            String out = "";
            String link = "";
            String type = null;
            Placement placement = Placement.FREE;
            ArrayList cfg = new ArrayList();
            char end = '\u0000';
            int i = -1;
            CharArrayList names = new CharArrayList();
            ArrayList<GeneratedNode> nodes = new ArrayList<GeneratedNode>();
            block26: while (jr.hasNext()) {
                switch (jr.nextName()) {
                    case "type": {
                        type = jr.nextString();
                        continue block26;
                    }
                    case "id": {
                        i = jr.nextInt();
                        continue block26;
                    }
                    case "lock": {
                        placement = Placement.valueOf(jr.nextString().toUpperCase());
                        continue block26;
                    }
                    case "cfg": {
                        jr.beginArray();
                        while (jr.hasNext()) {
                            String s = jr.nextString();
                            GateConfiguration<?> c = GateConfiguration.REGISTRY.get(s);
                            if (c != null) {
                                cfg.add(c);
                                continue;
                            }
                            throw new IllegalArgumentException("invalid configuration type: " + s);
                        }
                        jr.endArray();
                        continue block26;
                    }
                    case "width": {
                        w = jr.nextInt();
                        continue block26;
                    }
                    case "pins_in": {
                        in = jr.nextString();
                        continue block26;
                    }
                    case "pins_out": {
                        out = jr.nextString();
                        continue block26;
                    }
                    case "link": {
                        link = jr.nextString();
                        continue block26;
                    }
                    case "end": {
                        end = jr.nextString().charAt(0);
                        continue block26;
                    }
                    case "nodes": {
                        if (jr.peek() == JsonToken.BEGIN_OBJECT) {
                            GeneratedType.parseNode(jr, nodes, names);
                            continue block26;
                        }
                        jr.beginArray();
                        while (jr.hasNext()) {
                            GeneratedType.parseNode(jr, nodes, names);
                        }
                        jr.endArray();
                        continue block26;
                    }
                }
                jr.skipValue();
            }
            jr.endObject();
            ArrayList<LinkVar> ins = new ArrayList<LinkVar>();
            ArrayList<LinkVar> outs = new ArrayList<LinkVar>();
            ByteArrayList heights = new ByteArrayList();
            int h = Math.max(GeneratedType.parsePins(ins, in, heights), GeneratedType.parsePins(outs, out, heights));
            int ni = ins.size() + link.length();
            int nn = nodes.size();
            Type[] inputs = new Type[ins.size()];
            int j = 0;
            for (LinkVar v : ins) {
                if (names.contains(v.name)) {
                    throw new IllegalStateException("duplicate supplier for variable '" + v.name + "' defined in input pins");
                }
                names.add(v.name);
                inputs[j++] = v.type;
            }
            for (Object c : (Iterator<Object>)link.toCharArray()) {
                if (names.contains((char)c)) {
                    throw new IllegalStateException("duplicate supplier for variable '" + (char)c + "' defined in link");
                }
                names.add((char)c);
            }
            for (LinkVar v : outs) {
                v.name = (char)GeneratedType.lookup(names, v.name, nn, ni);
            }
            for (GeneratedNode n : nodes) {
                n.translateVars(names, nn, ni);
            }
            if (end != '\u0000') {
                end = (char)(GeneratedType.lookup(names, end, nn, ni) + 1);
            }
            IGateProvider iGateProvider = provider = type == null ? IGateProvider.DEFAULT : IGateProvider.REGISTRY.get(type);
            if (provider == null) {
                throw new IllegalArgumentException("invalid gate type: " + type);
            }
            GeneratedType t = new GeneratedType(id, w, h, heights.toByteArray(), inputs, link.length(), end - '\u0001', outs.toArray(new LinkVar[outs.size()]), nodes.toArray(new GeneratedNode[nn]), provider, cfg.toArray(new GateConfiguration[cfg.size()]), placement);
            if (i >= 0) {
                inset.add(i, t);
            }
            return t;
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new IOException("invalid gate definition json:", e);
        }
    }

    static int lookup(CharArrayList names, char name, int r1, int r2) {
        int i = names.indexOf(name);
        if (i < 0) {
            throw new IllegalStateException("no supplier defined for variable '" + name + "'");
        }
        return i < r1 ? i + r2 : i - r1;
    }

    private static int parsePins(ArrayList<LinkVar> vars, String pins, ByteArrayList heights) {
        try {
            char[] ca = pins.toCharArray();
            int h = 0;
            int i = 0;
            while (i < ca.length) {
                char c;
                if (Character.isWhitespace(c = ca[i++])) {
                    ++h;
                    continue;
                }
                int j = GeneratedType.descrLength(ca, i);
                vars.add(new LinkVar(c, IOUtils.getValidType(pins.substring(i, i += j))));
                heights.add((byte)h++);
            }
            return h;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("invalid type descriptor in pin layout: '" + pins + "'");
        }
    }

    private static int descrLength(char[] code, int ofs) {
        char c = code[ofs];
        if (c == '[') {
            return GeneratedType.descrLength(code, ofs + 1) + 1;
        }
        if (c == 'L') {
            int n = 2;
            while (code[++ofs] != ';') {
                ++n;
            }
            return n;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static void parseNode(JsonReader jr, ArrayList<GeneratedNode> nodes, CharArrayList names) throws IOException {
        jr.beginObject();
        out = null;
        in = new ArrayList<LinkVar>();
        args = new ArrayList<Function<GeneratedGate, Object>>();
        sort = 0x7FFFFFFF;
        code = null;
        strict = false;
        precond = GeneratedType.alwaysTrue;
        block21: while (jr.hasNext()) {
            var10_10 = jr.nextName();
            var11_11 = -1;
            switch (var10_10.hashCode()) {
                case -506586493: {
                    if (!var10_10.equals("typestrict")) break;
                    var11_11 = 0;
                    break;
                }
                case 3357: {
                    if (!var10_10.equals("if")) break;
                    var11_11 = 1;
                    break;
                }
                case 3365: {
                    if (!var10_10.equals("in")) break;
                    var11_11 = 2;
                    break;
                }
                case -896593085: {
                    if (!var10_10.equals("sortin")) break;
                    var11_11 = 3;
                    break;
                }
                case 110414: {
                    if (!var10_10.equals("out")) break;
                    var11_11 = 4;
                    break;
                }
                case 3059181: {
                    if (!var10_10.equals("code")) break;
                    var11_11 = 5;
                    break;
                }
                case 0x2DD0DD: {
                    if (!var10_10.equals("args")) break;
                    var11_11 = 6;
                }
            }
            switch (var11_11) {
                case 0: {
                    strict = jr.nextBoolean();
                    continue block21;
                }
                case 1: {
                    precond = GeneratedType.parsePrecondition(jr, precond);
                    continue block21;
                }
                case 2: {
                    jr.beginArray();
                    while (jr.hasNext()) {
                        v = new LinkVar(jr.nextString());
                        if (sort <= in.size()) {
                            in.add(sort++, v);
                            continue;
                        }
                        in.add(v);
                    }
                    jr.endArray();
                    continue block21;
                }
                case 3: {
                    jr.beginArray();
                    sort = Math.min(sort, in.size());
                    while (jr.hasNext()) {
                        in.add(new LinkVar(jr.nextString()));
                    }
                    jr.endArray();
                    continue block21;
                }
                case 4: {
                    out = new LinkVar(jr.nextString());
                    continue block21;
                }
                case 5: {
                    if (jr.peek() != JsonToken.BEGIN_ARRAY) ** GOTO lbl85
                    jr.beginArray();
                    try {
                        while (jr.hasNext()) {
                            ASMCode.PARSER.accept(jr.nextString());
                        }
                        code = ASMCode.PARSER.build();
                    }
                    finally {
                        ASMCode.PARSER.clear();
                    }
                    jr.endArray();
                    continue block21;
lbl85:
                    // 1 sources

                    code = ASMCode.get(new ResourceLocation(jr.nextString()));
                    continue block21;
                }
                case 6: {
                    jr.beginArray();
                    while (jr.hasNext()) {
                        o = IOUtils.nextValue(jr);
                        if (o instanceof String) {
                            s = (String)o;
                            if (s.length() > 0 && s.charAt(0) == '$') {
                                if (s.length() > 1 && s.charAt(1) == 'l') {
                                    args.add((Function<GeneratedGate, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$parseNode$0(cd4017be.rs_ctr.circuit.editor.GeneratedGate ), (Lcd4017be/rs_ctr/circuit/editor/GeneratedGate;)Ljava/lang/Object;)());
                                    continue;
                                }
                                i = Integer.parseInt(s.substring(1));
                                args.add((Function<GeneratedGate, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$parseNode$1(int cd4017be.rs_ctr.circuit.editor.GeneratedGate ), (Lcd4017be/rs_ctr/circuit/editor/GeneratedGate;)Ljava/lang/Object;)((int)i));
                                continue;
                            }
                            if (s.length() > 0 && s.charAt(0) == '\\') {
                                o = s.substring(1);
                            }
                        }
                        o_ = o;
                        args.add((Function<GeneratedGate, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$parseNode$2(java.lang.Object cd4017be.rs_ctr.circuit.editor.GeneratedGate ), (Lcd4017be/rs_ctr/circuit/editor/GeneratedGate;)Ljava/lang/Object;)((Object)o_));
                    }
                    jr.endArray();
                    continue block21;
                }
            }
            jr.skipValue();
        }
        jr.endObject();
        node /* !! */  = code == null ? new GeneratedNode.Pass(out.type, in, sort, strict, precond) : (code.extra == null ? new GeneratedNode(out.type, code, in, sort, strict, precond, args) : new GeneratedNode.Bool(out.type, code, in, sort, strict, precond, args));
        i = names.indexOf(out.name);
        if (i < 0) {
            nodes.add(node /* !! */ );
            names.add(out.name);
        } else {
            n = nodes.get(i);
            while (n.next != null) {
                n = n.next;
            }
            n.next = node /* !! */ ;
        }
    }

    private static Predicate<GeneratedGate> parsePrecondition(JsonReader jr, Predicate<GeneratedGate> precond) throws IOException {
        jr.beginObject();
        int var = -1;
        block10: while (jr.hasNext()) {
            Predicate<GeneratedGate> cond;
            switch (jr.nextName()) {
                case "var": {
                    var = jr.nextInt();
                    continue block10;
                }
                case "eq": {
                    Object val = IOUtils.nextValue(jr);
                    int var_ = var;
                    cond = g -> g.getParam(var_).equals(val);
                    break;
                }
                case "neq": {
                    Object val = IOUtils.nextValue(jr);
                    int var_ = var;
                    cond = g -> g.getParam(var_).equals(val);
                    break;
                }
                default: {
                    jr.skipValue();
                    continue block10;
                }
            }
            if (precond == alwaysTrue) {
                precond = cond;
                continue;
            }
            precond = precond.and(cond);
        }
        jr.endObject();
        return precond;
    }

    private static /* synthetic */ Object lambda$parseNode$2(Object o_, GeneratedGate g) {
        return o_;
    }

    private static /* synthetic */ Object lambda$parseNode$1(int i, GeneratedGate g) {
        return g.getParam(i);
    }

    private static /* synthetic */ Object lambda$parseNode$0(GeneratedGate g) {
        return g.label;
    }
}

