/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.circuit.editor;

import cd4017be.rs_ctr.Main;
import cd4017be.rscpl.compile.Compiler;
import cd4017be.rscpl.compile.Context;
import cd4017be.rscpl.compile.Dep;
import cd4017be.rscpl.util.IOUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.minecraft.util.ResourceLocation;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import scala.actors.threadpool.Arrays;

public class ASMCode {
    private static final HashMap<ResourceLocation, ASMCode> REGISTRY = new HashMap();
    public static final Parser PARSER = new Parser();
    final Insn[] instructions;
    final int locals;
    final int labels;
    public ASMCode extra;
    static final HashMap<String, Insn> TRANSLATION = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ASMCode get(ResourceLocation loc) {
        ASMCode code = REGISTRY.get(loc);
        if (code != null) {
            return code;
        }
        InputStream is = IOUtils.getClassResource(loc, "/logic/nodes/", ".jasm");
        if (is == null) {
            Main.LOG.error("missing asm code {}", (Object)loc);
            return code;
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
            br.lines().map(l -> {
                int i = l.indexOf(35);
                if (i >= 0) {
                    l = l.substring(0, i);
                }
                return l.trim();
            }).filter(l -> !l.isEmpty()).forEachOrdered(PARSER);
            code = PARSER.build();
            REGISTRY.put(loc, code);
        }
        catch (IOException | IllegalArgumentException e) {
            Main.LOG.error("failed loading asm code " + loc, (Throwable)e);
        }
        finally {
            PARSER.clear();
        }
        return code;
    }

    public ASMCode(Insn[] instructions, int locals, int labels) {
        this.instructions = instructions;
        this.locals = locals;
        this.labels = labels;
    }

    private static void put(int start, IntFunction<Insn> instr, String ... opcodes) {
        for (String s : opcodes) {
            if (s != null) {
                TRANSLATION.put(s, instr.apply(start++));
                continue;
            }
            ++start;
        }
    }

    static Object replace(String arg, CompCont cont) {
        if (arg.isEmpty()) {
            return arg;
        }
        char c = arg.charAt(0);
        if (c == '\\') {
            return arg.substring(1);
        }
        if (c != '$') {
            return arg;
        }
        return cont.args[Integer.parseInt(arg.substring(1))];
    }

    static {
        TRANSLATION.put("CLR", new IntInsn(-6, 1));
        TRANSLATION.put("JOF", new IntInsn(-5, 3));
        TRANSLATION.put("JOT", new IntInsn(-4, 3));
        TRANSLATION.put("IN", new IntInsn(-3, 3));
        TRANSLATION.put("EVDEPS", new IntInsn(-2, 3));
        TRANSLATION.put("EVDEP", new IntInsn(-1, 3));
        ASMCode.put(0, Insn::new, "NOP", "ACONST_NULL", "ICONST_M1", "ICONST_0", "ICONST_1", "ICONST_2", "ICONST_3", "ICONST_4", "ICONST_5", "LCONST_0", "LCONST_1", "FCONST_0", "FCONST_1", "FCONST_2", "DCONST_0", "DCONST_1");
        TRANSLATION.put("BIPUSH", new IntInsn(16, 0));
        TRANSLATION.put("SIPUSH", new IntInsn(17, 0));
        TRANSLATION.put("LDC", new LdcInsn());
        ASMCode.put(21, i -> new IntInsn(i, 1), "ILOAD", "LLOAD", "FLOAD", "DLOAD", "ALOAD");
        ASMCode.put(46, Insn::new, "IALOAD", "LALOAD", "FALOAD", "DALOAD", "AALOAD", "BALOAD", "CALOAD", "SALOAD");
        ASMCode.put(54, i -> new IntInsn(i, 1), "ISTORE", "LSTORE", "FSTORE", "DSTORE", "ASTORE");
        ASMCode.put(79, Insn::new, "IASTORE", "LASTORE", "FASTORE", "DASTORE", "AASTORE", "BASTORE", "CASTORE", "SASTORE", "POP", "POP2", "DUP", "DUP_X1", "DUP_X2", "DUP2", "DUP2_X1", "DUP2_X2", "SWAP", "IADD", "LADD", "FADD", "DADD", "ISUB", "LSUB", "FSUB", "DSUB", "IMUL", "LMUL", "FMUL", "DMUL", "IDIV", "LDIV", "FDIV", "DDIV", "IREM", "LREM", "FREM", "DREM", "INEG", "LNEG", "FNEG", "DNEG", "ISHL", "LSHL", "ISHR", "LSHR", "IUSHR", "LUSHR", "IAND", "LAND", "IOR", "LOR", "IXOR", "LXOR", null, "I2L", "I2F", "I2D", "L2I", "L2F", "L2D", "F2I", "F2L", "F2D", "D2I", "D2L", "D2F", "I2B", "I2C", "I2S", "LCMP", "FCMPL", "FCMPG", "DCMPL", "DCMPG");
        ASMCode.put(153, i -> new IntInsn(i, 2), "IFEQ", "IFNE", "IFLT", "IFGE", "IFGT", "IFLE", "IF_ICMPEQ", "IF_ICMPNE", "IF_ICMPLT", "IF_ICMPGE", "IF_ICMPGT", "IF_ICMPLE", "IF_ACMPEQ", "IF_ACMPNE", "GOTO", "JSR");
        TRANSLATION.put("RET", new IntInsn(169, 1));
        ASMCode.put(172, Insn::new, "IRETURN", "LRETURN", "FRETURN", "DRETURN", "ARETURN", "RETURN");
        ASMCode.put(178, DescInsn::new, "GETSTATIC", "PUTSTATIC", "GETFIELD", "PUTFIELD", "INVOKEVIRTUAL", "INVOKESPECIAL", "INVOKESTATIC", "INVOKEINTERFACE");
        TRANSLATION.put("NEWARRAY", new IntInsn(188, 0));
        ASMCode.put(187, DescInsn::new, "NEW", null, "ANEWARRAY", null, null, "CHECKCAST", "INSTANCEOF");
        ASMCode.put(190, Insn::new, "ARRAYLENGTH", "ATHROW", null, null, "MONITORENTER", "MONITOREXIT");
        TRANSLATION.put("IFNULL", new IntInsn(198, 2));
        TRANSLATION.put("IFNONNULL", new IntInsn(199, 2));
    }

    static class DefLocal
    extends Insn {
        final int idx;
        final Type type;

        public DefLocal(int idx, Type type) {
            super(0);
            this.idx = idx;
            this.type = type;
        }

        @Override
        public void visit(MethodVisitor mv, CompCont cont) {
            cont.defineLocal(this.idx, this.type);
        }

        @Override
        public String toString() {
            return this.type + " " + this.idx;
        }
    }

    static class LdcInsn
    extends Insn {
        final Object val;

        public LdcInsn() {
            this(null);
        }

        public LdcInsn(Object val) {
            super(18);
            this.val = val;
        }

        @Override
        public Insn parse(String[] args, Parser cont) {
            Object val;
            LdcInsn.assertArgs(args, 1);
            String arg = args[1];
            switch (arg.charAt(0)) {
                case '$': {
                    val = Byte.parseByte(arg.substring(1));
                    break;
                }
                case '\"': 
                case '\'': {
                    val = arg.substring(1, arg.length() - 1);
                    break;
                }
                case 'F': {
                    val = Float.valueOf(Float.parseFloat(arg.substring(1)));
                    break;
                }
                case 'D': {
                    val = Double.parseDouble(arg.substring(1));
                    break;
                }
                case 'L': {
                    val = Long.parseLong(arg.substring(1));
                    break;
                }
                default: {
                    int v = Integer.parseInt(arg);
                    if (v >= -1 && v <= 5) {
                        return new Insn(3 + v);
                    }
                    if (v >= -128 && v <= 127) {
                        return new IntInsn(16, 0, v);
                    }
                    if (v >= Short.MIN_VALUE && v <= Short.MAX_VALUE) {
                        return new IntInsn(17, 0, v);
                    }
                    val = v;
                }
            }
            return new LdcInsn(val);
        }

        @Override
        public void visit(MethodVisitor mv, CompCont cont) {
            if (this.val instanceof Byte) {
                Object v = cont.args[(Byte)this.val & 0xFF];
                if (v instanceof Integer) {
                    Compiler.i_const(mv, (Integer)v);
                } else {
                    mv.visitLdcInsn(v);
                }
            } else {
                mv.visitLdcInsn(this.val);
            }
        }

        @Override
        public String toString() {
            return "LdcInsn " + this.val;
        }
    }

    static class DescInsn
    extends Insn {
        final String owner;
        final String name;
        final String desc;

        public DescInsn(int opcode) {
            this(opcode, null, null, null);
        }

        public DescInsn(int opcode, String owner, String name, String desc) {
            super(opcode);
            this.owner = owner;
            this.name = name;
            this.desc = desc;
        }

        @Override
        public Insn parse(String[] args, Parser cont) {
            if (this.opcode < 186) {
                DescInsn.assertArgs(args, 3);
                return new DescInsn(this.opcode, args[1], args[2], args[3]);
            }
            DescInsn.assertArgs(args, 1);
            return new DescInsn(this.opcode, null, null, args[1]);
        }

        @Override
        public void visit(MethodVisitor mv, CompCont cont) {
            String owner = this.owner;
            String name = this.name;
            String desc = this.desc;
            if ("this".equals(owner)) {
                owner = cont.context.compiler.C_THIS;
            } else if ("super".equals(owner)) {
                owner = cont.context.compiler.C_SUPER;
            }
            if (name != null) {
                name = ASMCode.replace(name, cont).toString();
            }
            if (desc != null) {
                desc = ASMCode.replace(desc, cont).toString();
            }
            if (this.opcode < 182) {
                mv.visitFieldInsn(this.opcode, owner, name, desc);
            } else if (this.opcode < 186) {
                mv.visitMethodInsn(this.opcode, owner, name, desc, this.opcode == 185);
            } else {
                mv.visitTypeInsn(this.opcode, desc);
            }
        }

        @Override
        public String toString() {
            String s = "DescInsn " + this.opcode + " " + this.owner;
            return this.name != null ? s + "." + this.name + this.desc : s;
        }
    }

    static class IntInsn
    extends Insn {
        final int arg;
        final byte type;
        private static final String[] TYPES = new String[]{"IntInsn ", "VarInsn ", "JumpInsn ", "Input "};

        public IntInsn(int opcode, int type) {
            this(opcode, (byte)type, 0);
        }

        public IntInsn(int opcode, byte type, int arg) {
            super(opcode);
            this.type = type;
            this.arg = arg;
        }

        @Override
        public Insn parse(String[] args, Parser cont) {
            int arg;
            switch (this.type) {
                case 0: {
                    IntInsn.assertArgs(args, 1);
                    arg = Integer.parseInt(args[1]);
                    break;
                }
                case 1: {
                    IntInsn.assertArgs(args, 1);
                    arg = cont.getLocal(args[1]);
                    break;
                }
                case 2: {
                    IntInsn.assertArgs(args, 1);
                    arg = cont.getLabel(args[1]);
                    break;
                }
                case 3: {
                    if (this.opcode < -3) {
                        IntInsn.assertArgs(args, 2);
                        arg = cont.getLabel(args[2]) << 16;
                    } else {
                        IntInsn.assertArgs(args, 1);
                        arg = 0;
                    }
                    arg |= Integer.parseInt(args[1]) & 0xFFFF;
                    break;
                }
                default: {
                    return null;
                }
            }
            return new IntInsn(this.opcode, this.type, arg);
        }

        @Override
        public void visit(MethodVisitor mv, CompCont cont) {
            switch (this.type) {
                case 0: {
                    mv.visitIntInsn(this.opcode, this.arg);
                    break;
                }
                case 1: {
                    int l;
                    if (this.opcode < 0) {
                        cont.clearLocal(this.arg);
                        break;
                    }
                    if (this.arg < 0) {
                        l = this.arg == -1 ? 0 : 1;
                    } else if (cont.locals == null || (l = cont.locals[this.arg]) < 0) {
                        throw new IllegalStateException("local variable " + this.arg + " for varInsn " + this.opcode + " not defined");
                    }
                    mv.visitVarInsn(this.opcode, l);
                    break;
                }
                case 2: {
                    if (this.opcode == 0) {
                        mv.visitLabel(cont.labels[this.arg]);
                        break;
                    }
                    mv.visitJumpInsn(this.opcode, this.arg < 0 ? cont.target : cont.labels[this.arg]);
                    break;
                }
                case 3: {
                    Dep in = cont.inputs[this.arg & 0xFFFF];
                    if (this.opcode < -3) {
                        in.compile(mv, cont.context, this.arg < 0 ? cont.target : cont.labels[this.arg >> 16], this.opcode == -4);
                        break;
                    }
                    if (this.opcode == -3) {
                        in.compile(mv, cont.context);
                        break;
                    }
                    in.ensureDependencyEvaluation(mv, cont.context, this.opcode == -2);
                }
            }
        }

        @Override
        public String toString() {
            return TYPES[this.type] + this.opcode + " " + this.arg;
        }
    }

    public static class Insn {
        final int opcode;

        public Insn(int opcode) {
            this.opcode = opcode;
        }

        public Insn parse(String[] args, Parser cont) {
            Insn.assertArgs(args, 0);
            return this;
        }

        public static void assertArgs(String[] args, int n) {
            if (args.length != n + 1) {
                throw new IllegalArgumentException("expected opcode with " + n + " arguments but got: " + String.join((CharSequence)" ", args));
            }
        }

        public void visit(MethodVisitor mv, CompCont cont) {
            mv.visitInsn(this.opcode);
        }

        public String toString() {
            return "Insn " + this.opcode;
        }
    }

    public static class CompCont {
        final Context context;
        final Object[] args;
        final Dep[] inputs;
        final int[] locals;
        final Type[] types;
        final Label[] labels;
        final Label target;

        public CompCont(ASMCode code, Dep[] inputs, Object[] args, Context context, Label target) {
            this.inputs = inputs;
            this.args = args;
            this.context = context;
            if (code.locals > 0) {
                this.types = new Type[code.locals];
                this.locals = new int[code.locals];
                Arrays.fill((int[])this.locals, (int)-1);
            } else {
                this.types = null;
                this.locals = null;
            }
            if (code.labels > 0) {
                this.labels = new Label[code.labels];
                for (int i = 0; i < this.labels.length; ++i) {
                    this.labels[i] = new Label();
                }
            } else {
                this.labels = null;
            }
            this.target = target;
        }

        public void defineLocal(int i, Type type) {
            this.clearLocal(i);
            this.locals[i] = this.context.newLocal(type);
            this.types[i] = type;
        }

        public void clearLocal(int i) {
            int idx = this.locals[i];
            if (idx < 0) {
                return;
            }
            this.context.releaseLocal(idx, this.types[i]);
            this.locals[i] = -1;
            this.types[i] = null;
        }

        public void clear() {
            if (this.locals != null) {
                for (int i = 0; i < this.locals.length; ++i) {
                    this.clearLocal(i);
                }
            }
        }
    }

    public static class Parser
    implements Consumer<String> {
        private ASMCode main;
        private ASMCode jot;
        private ASMCode jof;
        private byte section = 0;
        private ArrayList<String> locals = new ArrayList();
        private ArrayList<String> labels = new ArrayList();
        private ArrayList<Insn> list = new ArrayList();

        private Parser() {
        }

        public int getLocal(String name) {
            if ("this".equals(name)) {
                return -1;
            }
            if ("mod".equals(name)) {
                return -2;
            }
            int i = this.locals.indexOf(name);
            if (i < 0) {
                i = this.locals.size();
                this.locals.add(name);
            }
            return i;
        }

        public int getLabel(String name) {
            if (this.section > 0 && "dst".equals(name)) {
                return -1;
            }
            int i = this.labels.indexOf(name);
            if (i < 0) {
                i = this.labels.size();
                this.labels.add(name);
            }
            return i;
        }

        @Override
        public void accept(String t) {
            String[] tokens = t.split("\\s+");
            String cmd = tokens[0];
            Insn ins = TRANSLATION.get(cmd.toUpperCase());
            int l = cmd.length();
            if (ins != null) {
                ins = ins.parse(tokens, this);
            } else if (l > 0 && cmd.charAt(l - 1) == ':') {
                if ("true".equals(cmd = cmd.substring(0, l - 1))) {
                    this.pushState();
                    this.section = 1;
                    return;
                }
                if ("false".equals(cmd)) {
                    this.pushState();
                    this.section = (byte)2;
                    return;
                }
                ins = new IntInsn(0, 2, this.getLabel(cmd));
            } else {
                Insn.assertArgs(tokens, 1);
                ins = new DefLocal(this.getLocal(tokens[1]), IOUtils.getValidType(cmd));
            }
            this.list.add(ins);
        }

        private void pushState() {
            ASMCode code = new ASMCode(this.list.toArray(new Insn[this.list.size()]), this.locals.size(), this.labels.size());
            switch (this.section) {
                case 0: {
                    this.main = code;
                    break;
                }
                case 1: {
                    this.jot = code;
                    break;
                }
                case 2: {
                    this.jof = code;
                }
            }
            this.list.clear();
            this.labels.clear();
            this.locals.clear();
        }

        public ASMCode build() {
            this.pushState();
            if (this.jot != null && this.jof != null) {
                this.jof.extra = this.jot;
                this.main.extra = this.jof;
            }
            return this.main;
        }

        public void clear() {
            this.jof = null;
            this.jot = null;
            this.main = null;
            this.section = 0;
            this.list.clear();
            this.labels.clear();
            this.locals.clear();
        }
    }
}

