/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.block;

import cd4017be.api.rs_ctr.interact.IInteractiveComponent;
import cd4017be.api.rs_ctr.wire.IHookAttachable;
import cd4017be.lib.block.BlockCoveredPipe;
import cd4017be.lib.block.BlockPipe;
import cd4017be.lib.util.Utils;
import cd4017be.rs_ctr.Objects;
import cd4017be.rs_ctr.tileentity.RedstonePort;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockRedstonePort
extends BlockCoveredPipe {
    public BlockRedstonePort(String id, Material m, SoundType sound, Class<? extends TileEntity> tile) {
        super(id, m, sound, BlockPipe.CON_PROPS.length + 2, tile);
        this.boundingBox = new AxisAlignedBB[]{field_185506_k, new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.125, 0.75), new AxisAlignedBB(0.25, 0.875, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.75, 0.125), new AxisAlignedBB(0.25, 0.25, 0.875, 0.75, 0.75, 1.0), new AxisAlignedBB(0.0, 0.25, 0.25, 0.125, 0.75, 0.75), new AxisAlignedBB(0.875, 0.25, 0.25, 1.0, 0.75, 0.75)};
        this.setSolid((byte)1);
    }

    public Class<?> moduleType(int i) {
        return i < 7 ? super.moduleType(i) : IInteractiveComponent.IBlockRenderComp[].class;
    }

    protected PropertyInteger createBaseState() {
        return null;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        RayTraceResult res;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof RedstonePort && !world.field_72995_K && (res = Utils.getHit((EntityPlayer)player, (IBlockState)state, (BlockPos)pos)) != null && ((RedstonePort)te).breakPort(res.subHit - 1, player, willHarvest)) {
            return false;
        }
        if (willHarvest) {
            return true;
        }
        return world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), world.field_72995_K ? 11 : 3);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof RedstonePort)) {
            return ItemStack.field_190927_a;
        }
        RedstonePort port = (RedstonePort)te;
        int i = target.subHit - 1;
        if (i == -2) {
            return new ItemStack((Item)Objects.wire_anchor);
        }
        if (i >= 0 && i < 6) {
            for (int t = 0; t < 4; ++t) {
                if (port.getPort(i + t * 6) == null) continue;
                return new ItemStack((Item)Objects.rs_port, 1, t);
            }
        }
        if ((state = port.cover.state) == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = port.cover.stack;
        if (stack != null && !stack.func_190926_b()) {
            return stack;
        }
        return state.func_177230_c().getPickBlock(state, target, world, pos, player);
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return this.isSideSolid(state, world, pos, side) ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d start, Vec3d end) {
        return IHookAttachable.addBlockRayTrace((RayTraceResult)super.func_180636_a(state, world, pos, start, end), (World)world, (BlockPos)pos, (Vec3d)start, (Vec3d)end);
    }
}

