/*
 * Decompiled with CFR 0.152.
 */
package com.alet.littletiles.gui.controls;

import com.alet.littletiles.common.utils.mc.ColorUtilsAlet;
import com.alet.littletiles.gui.controls.GuiColoredSteppedSliderAlet;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.client.style.Style;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButtonHold;
import com.creativemd.creativecore.common.gui.controls.gui.GuiColorPicker;
import com.creativemd.creativecore.common.gui.controls.gui.GuiColorPlate;
import com.creativemd.creativecore.common.gui.event.ControlEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import java.util.ArrayList;
import java.util.Collections;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;

public class GuiColorPickerAlet
extends GuiColorPicker {
    public Color color;
    public GuiColorPicker.GuiColorPickerPalette palette;
    public GuiColoredSteppedSliderAlet sliderR;
    public GuiColoredSteppedSliderAlet sliderG;
    public GuiColoredSteppedSliderAlet sliderB;
    public GuiColoredSteppedSliderAlet sliderS;
    private double oldShaderValue = 0.0;
    private boolean hasAlpha;

    public GuiColorPickerAlet(String name, int x, int y, Color color, boolean hasAlpha, int alphaMin) {
        super(name, x, y, color, hasAlpha, alphaMin);
        this.hasAlpha = hasAlpha;
        this.width = 134 + this.getContentOffset() * 2;
        this.height = 55 + this.getContentOffset() * 2;
        this.marginWidth = 0;
        this.color = color;
        this.setStyle(Style.emptyStyle);
        this.removeControls(new String[]{"null"});
        this.addControl((GuiControl)new GuiButtonHold("r-", "<", 0, 0, 1, 5){

            public void onClicked(int x, int y, int button) {
                GuiColorPickerAlet.this.onColorChanged();
                GuiColorPickerAlet.this.sliderR.setValue(GuiColorPickerAlet.this.sliderR.value - 1.0);
                GuiColorPickerAlet.this.updateShadeSlider();
            }
        });
        this.addControl((GuiControl)new GuiButtonHold("r+", ">", 98, 0, 1, 5){

            public void onClicked(int x, int y, int button) {
                GuiColorPickerAlet.this.onColorChanged();
                GuiColorPickerAlet.this.sliderR.setValue(GuiColorPickerAlet.this.sliderR.value + 1.0);
                GuiColorPickerAlet.this.updateShadeSlider();
            }
        });
        this.addControl((GuiControl)new GuiButtonHold("g-", "<", 0, 10, 1, 5){

            public void onClicked(int x, int y, int button) {
                GuiColorPickerAlet.this.onColorChanged();
                GuiColorPickerAlet.this.sliderG.setValue(GuiColorPickerAlet.this.sliderG.value - 1.0);
                GuiColorPickerAlet.this.updateShadeSlider();
            }
        });
        this.addControl((GuiControl)new GuiButtonHold("g+", ">", 98, 10, 1, 5){

            public void onClicked(int x, int y, int button) {
                GuiColorPickerAlet.this.onColorChanged();
                GuiColorPickerAlet.this.sliderG.setValue(GuiColorPickerAlet.this.sliderG.value + 1.0);
                GuiColorPickerAlet.this.updateShadeSlider();
            }
        });
        this.addControl((GuiControl)new GuiButtonHold("b-", "<", 0, 20, 1, 5){

            public void onClicked(int x, int y, int button) {
                GuiColorPickerAlet.this.onColorChanged();
                GuiColorPickerAlet.this.sliderB.setValue(GuiColorPickerAlet.this.sliderB.value - 1.0);
                GuiColorPickerAlet.this.updateShadeSlider();
            }
        });
        this.addControl((GuiControl)new GuiButtonHold("b+", ">", 98, 20, 1, 5){

            public void onClicked(int x, int y, int button) {
                GuiColorPickerAlet.this.onColorChanged();
                GuiColorPickerAlet.this.sliderB.setValue(GuiColorPickerAlet.this.sliderB.value + 1.0);
                GuiColorPickerAlet.this.updateShadeSlider();
            }
        });
        this.addControl((GuiControl)new GuiButtonHold("s-", "<", 0, 40, 1, 5){

            public void onClicked(int x, int y, int button) {
                GuiColorPickerAlet.this.onColorChanged();
                if (!GuiColorPickerAlet.this.isMin(GuiColorPickerAlet.this.sliderR.value, GuiColorPickerAlet.this.sliderG.value, GuiColorPickerAlet.this.sliderB.value)) {
                    GuiColorPickerAlet.this.sliderR.setValue(GuiColorPickerAlet.this.sliderR.value - 1.0);
                    GuiColorPickerAlet.this.sliderG.setValue(GuiColorPickerAlet.this.sliderG.value - 1.0);
                    GuiColorPickerAlet.this.sliderB.setValue(GuiColorPickerAlet.this.sliderB.value - 1.0);
                    GuiColorPickerAlet.this.sliderS.setValue(GuiColorPickerAlet.this.sliderS.value - 1.0);
                    GuiColorPickerAlet.this.updateShadeSlider();
                }
            }
        });
        this.addControl((GuiControl)new GuiButtonHold("s+", ">", 98, 40, 1, 5){

            public void onClicked(int x, int y, int button) {
                GuiColorPickerAlet.this.onColorChanged();
                if (!GuiColorPickerAlet.this.isMax(GuiColorPickerAlet.this.sliderR.value, GuiColorPickerAlet.this.sliderG.value, GuiColorPickerAlet.this.sliderB.value)) {
                    GuiColorPickerAlet.this.sliderR.setValue(GuiColorPickerAlet.this.sliderR.value + 1.0);
                    GuiColorPickerAlet.this.sliderG.setValue(GuiColorPickerAlet.this.sliderG.value + 1.0);
                    GuiColorPickerAlet.this.sliderB.setValue(GuiColorPickerAlet.this.sliderB.value + 1.0);
                    GuiColorPickerAlet.this.sliderS.setValue(GuiColorPickerAlet.this.sliderS.value + 1.0);
                    GuiColorPickerAlet.this.updateShadeSlider();
                }
            }
        });
        if (hasAlpha) {
            this.addControl((GuiControl)new GuiButtonHold("a-", "<", 0, 30, 1, 5){

                public void onClicked(int x, int y, int button) {
                    GuiColorPickerAlet.this.onColorChanged();
                    GuiColoredSteppedSliderAlet slider = (GuiColoredSteppedSliderAlet)GuiColorPickerAlet.this.get("a");
                    slider.setValue(slider.value - 1.0);
                }
            });
            this.addControl((GuiControl)new GuiButtonHold("a+", ">", 98, 30, 1, 5){

                public void onClicked(int x, int y, int button) {
                    GuiColorPickerAlet.this.onColorChanged();
                    GuiColoredSteppedSliderAlet slider = (GuiColoredSteppedSliderAlet)GuiColorPickerAlet.this.get("a");
                    slider.setValue(slider.value + 1.0);
                }
            });
        } else {
            color.setAlpha(255);
        }
        this.sliderR = new GuiColoredSteppedSliderAlet("r", 8, 0, 84, 5, this, ColorUtilsAlet.ColorPart.RED){

            public void mouseMove(int posX, int posY, int button) {
                super.mouseMove(posX, posY, button);
                if (this.grabbedSlider) {
                    GuiColorPickerAlet.this.updateShadeSlider();
                }
            }

            public boolean mouseScrolled(int x, int y, int scrolled) {
                super.mouseScrolled(x, y, scrolled);
                GuiColorPickerAlet.this.updateShadeSlider();
                return true;
            }
        };
        this.addControl(this.sliderR.setStyle(defaultStyle));
        this.sliderG = new GuiColoredSteppedSliderAlet("g", 8, 10, 84, 5, this, ColorUtilsAlet.ColorPart.GREEN){

            public void mouseMove(int posX, int posY, int button) {
                super.mouseMove(posX, posY, button);
                if (this.grabbedSlider) {
                    GuiColorPickerAlet.this.updateShadeSlider();
                }
            }

            public boolean mouseScrolled(int x, int y, int scrolled) {
                super.mouseScrolled(x, y, scrolled);
                GuiColorPickerAlet.this.updateShadeSlider();
                return true;
            }
        };
        this.addControl(this.sliderG.setStyle(defaultStyle));
        this.sliderB = new GuiColoredSteppedSliderAlet("b", 8, 20, 84, 5, this, ColorUtilsAlet.ColorPart.BLUE){

            public void mouseMove(int posX, int posY, int button) {
                super.mouseMove(posX, posY, button);
                if (this.grabbedSlider) {
                    GuiColorPickerAlet.this.updateShadeSlider();
                }
            }

            public boolean mouseScrolled(int x, int y, int scrolled) {
                super.mouseScrolled(x, y, scrolled);
                GuiColorPickerAlet.this.updateShadeSlider();
                return true;
            }
        };
        this.addControl(this.sliderB.setStyle(defaultStyle));
        if (hasAlpha) {
            GuiColoredSteppedSliderAlet alpha = new GuiColoredSteppedSliderAlet("a", 8, 30, 84, 5, this, ColorUtilsAlet.ColorPart.ALPHA);
            alpha.minValue = alphaMin;
            this.addControl(alpha.setStyle(defaultStyle));
        }
        this.sliderS = new GuiColoredSteppedSliderAlet("s", 8, 40, 84, 5, this, ColorUtilsAlet.ColorPart.SHADE){

            public void mouseMove(int posX, int posY, int button) {
                GuiColorPickerAlet.this.oldShaderValue = this.value;
                super.mouseMove(posX, posY, button);
                if (this.grabbedSlider) {
                    double difference = this.value - GuiColorPickerAlet.this.oldShaderValue;
                    GuiColorPickerAlet.this.sliderR.setValue(GuiColorPickerAlet.this.sliderR.value + difference);
                    GuiColorPickerAlet.this.sliderG.setValue(GuiColorPickerAlet.this.sliderG.value + difference);
                    GuiColorPickerAlet.this.sliderB.setValue(GuiColorPickerAlet.this.sliderB.value + difference);
                    GuiColorPickerAlet.this.oldShaderValue = this.value;
                }
            }

            public boolean mouseScrolled(int x, int y, int scrolled) {
                GuiColorPickerAlet.this.oldShaderValue = this.value;
                super.mouseScrolled(x, y, scrolled);
                double difference = this.value - GuiColorPickerAlet.this.oldShaderValue;
                GuiColorPickerAlet.this.sliderR.setValue(GuiColorPickerAlet.this.sliderR.value + difference);
                GuiColorPickerAlet.this.sliderG.setValue(GuiColorPickerAlet.this.sliderG.value + difference);
                GuiColorPickerAlet.this.sliderB.setValue(GuiColorPickerAlet.this.sliderB.value + difference);
                GuiColorPickerAlet.this.oldShaderValue = this.value;
                return true;
            }
        };
        this.updateShadeSlider();
        this.addControl(this.sliderS.setStyle(defaultStyle));
        this.addControl(new GuiColorPlate("plate", 107, 2, 20, 20, color).setStyle(defaultStyle));
        this.addControl((GuiControl)new GuiButton("more", "more", 105, 28){

            public void onClicked(int x, int y, int button) {
                if (GuiColorPickerAlet.this.palette != null) {
                    GuiColorPickerAlet.this.closePalette();
                } else {
                    GuiColorPickerAlet.this.openPalette();
                }
            }
        });
    }

    public void setColor(Color color) {
        this.color.setColor((ReadableColor)color);
        ((GuiColoredSteppedSliderAlet)this.get((String)"r")).value = color.getRed();
        ((GuiColoredSteppedSliderAlet)this.get((String)"g")).value = color.getGreen();
        ((GuiColoredSteppedSliderAlet)this.get((String)"b")).value = color.getBlue();
        if (this.hasAlpha) {
            ((GuiColoredSteppedSliderAlet)this.get((String)"a")).value = color.getAlpha();
        }
    }

    public void onColorChanged() {
        if (this.palette != null) {
            this.palette.onChanged();
        }
        this.raiseEvent((ControlEvent)new GuiControlChangedEvent((GuiControl)this));
    }

    public void openPalette() {
        this.palette = new GuiColorPicker.GuiColorPickerPalette(this.name + "palette", (GuiColorPicker)this, this.posX, this.posY + this.height, this.width - this.getContentOffset() * 2, 100);
        this.getGui().controls.add(this.palette);
        this.palette.parent = this.getGui();
        this.palette.moveControlToTop();
        this.palette.onOpened();
        this.getGui().refreshControls();
        this.palette.rotation = this.rotation;
        this.palette.posX = this.getPixelOffsetX() - this.getGui().getPixelOffsetX() - this.getContentOffset();
        this.palette.posY = this.getPixelOffsetY() - this.getGui().getPixelOffsetY() - this.getContentOffset() + this.height;
        if (this.palette.posY + this.palette.height > this.getParent().height && this.posY >= this.palette.height) {
            this.palette.posY -= this.height + this.palette.height;
        }
    }

    public void closePalette() {
        if (this.palette != null) {
            this.palette.savePalette();
            this.getGui().controls.remove(this.palette);
            this.removeListener(this.palette);
            this.palette = null;
        }
    }

    public double getShadeLimit(double r, double g, double b) {
        ArrayList<Double> rgb = new ArrayList<Double>();
        rgb.add(r);
        rgb.add(g);
        rgb.add(b);
        double min = (Double)Collections.min(rgb);
        double max = (Double)Collections.max(rgb);
        double a = 255.0 - max;
        return min + a;
    }

    public double getMinColor(double r, double g, double b) {
        ArrayList<Double> rgb = new ArrayList<Double>();
        rgb.add(r);
        rgb.add(g);
        rgb.add(b);
        return (Double)Collections.min(rgb);
    }

    public double getMaxColor(double r, double g, double b) {
        ArrayList<Double> rgb = new ArrayList<Double>();
        rgb.add(r);
        rgb.add(g);
        rgb.add(b);
        return (Double)Collections.max(rgb);
    }

    public boolean isMin(double r, double g, double b) {
        ArrayList<Double> rgb = new ArrayList<Double>();
        rgb.add(r);
        rgb.add(g);
        rgb.add(b);
        double min = (Double)Collections.min(rgb);
        return min == 0.0;
    }

    public boolean isMax(double r, double g, double b) {
        ArrayList<Double> rgb = new ArrayList<Double>();
        rgb.add(r);
        rgb.add(g);
        rgb.add(b);
        double max = (Double)Collections.max(rgb);
        return max == 255.0;
    }

    public void updateShadeSlider() {
        this.sliderS.maxValue = this.getShadeLimit(this.sliderR.value, this.sliderG.value, this.sliderB.value);
        this.oldShaderValue = this.sliderS.value = this.getMinColor(this.sliderR.value, this.sliderG.value, this.sliderB.value);
    }
}

