/*
 * Decompiled with CFR 0.152.
 */
package com.alet.items;

import com.alet.client.ALETClient;
import com.alet.client.gui.SubGuiTapeMeasure;
import com.alet.client.tapemeasure.TapeRenderer;
import com.alet.common.packet.PacketUpdateNBT;
import com.alet.common.utils.NBTUtils;
import com.alet.common.utils.StructureUtils;
import com.alet.tiles.SelectLittleTile;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.LittleTilesClient;
import com.creativemd.littletiles.client.gui.configure.SubGuiConfigure;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.api.ILittlePlacer;
import com.creativemd.littletiles.common.container.SubContainerConfigure;
import com.creativemd.littletiles.common.item.ItemMultiTiles;
import com.creativemd.littletiles.common.tile.math.vec.LittleAbsoluteVec;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.place.IMarkMode;
import com.creativemd.littletiles.common.util.place.MarkMode;
import com.creativemd.littletiles.common.util.place.PlacementPosition;
import com.creativemd.littletiles.common.util.place.PlacementPreview;
import com.creativemd.littletiles.common.util.tooltip.IItemTooltip;
import javax.vecmath.Point3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTapeMeasure
extends Item
implements ILittlePlacer,
IItemTooltip {
    public static int measurementType = 0;

    public void clear(ItemStack stack) {
        stack.func_77982_d(new NBTTagCompound());
    }

    public void clear(ItemStack stack, int index, EntityPlayer player) {
        NBTTagCompound nbt = stack.func_77978_p();
        PacketHandler.sendPacketToServer((CreativeCorePacket)new PacketUpdateNBT(stack));
    }

    public ItemTapeMeasure() {
        ItemTapeMeasure.setMax(50);
    }

    public ItemTapeMeasure(String name) {
        this.func_77655_b(name);
        this.setRegistryName(name);
        this.func_77625_d(1);
        this.func_77637_a(LittleTiles.littleTab);
    }

    public static void setMax(int maxMeasurements) {
    }

    public static int getMax() {
        return 50;
    }

    public static void setDefaultStackNBT(ItemStack stack) {
        NBTTagCompound nbtStack = new NBTTagCompound();
        nbtStack.func_74768_a("index", 0);
        nbtStack.func_74782_a("measurements", (NBTBase)new NBTTagCompound());
        stack.func_77982_d(nbtStack);
    }

    public static void setDefaultMeasurmentNBT(ItemStack stack, int index) {
        NBTTagCompound stackNBT = stack.func_77978_p();
        NBTTagCompound measurements = stackNBT.func_74775_l("measurements");
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("context", ItemMultiTiles.currentContext.index);
        data.func_74778_a("shape", "Box");
        data.func_74768_a("color", -1);
        data.func_74782_a("positions", (NBTBase)new NBTTagCompound());
        measurements.func_74782_a(index + "", (NBTBase)data);
        stackNBT.func_74782_a("measurements", (NBTBase)measurements);
        stack.func_77982_d(stackNBT);
    }

    public boolean onRightClick(World world, EntityPlayer plr, ItemStack stack, PlacementPosition position, RayTraceResult result) {
        return this.onBlockInteract(world, plr, stack, position, result, true);
    }

    public boolean onClickBlock(World world, EntityPlayer plr, ItemStack stack, PlacementPosition position, RayTraceResult result) {
        return this.onBlockInteract(world, plr, stack, position, result, false);
    }

    public boolean onBlockInteract(World world, EntityPlayer plr, ItemStack stack, PlacementPosition position, RayTraceResult result, boolean rightClick) {
        int additional;
        int index = 0;
        NBTTagCompound stackNBT = new NBTTagCompound();
        if (stack.func_77942_o()) {
            stackNBT = stack.func_77978_p();
            index = stackNBT.func_74764_b("index") ? stackNBT.func_74762_e("index") : 0;
        } else {
            ItemTapeMeasure.setDefaultStackNBT(stack);
            ItemTapeMeasure.setDefaultMeasurmentNBT(stack, 0);
            stackNBT = stack.func_77978_p();
        }
        LittleGridContext context = ItemTapeMeasure.getSelectedContext(stackNBT);
        int contextSize = context.size;
        RayTraceResult res = plr.func_174822_a(6.0, Minecraft.func_71410_x().func_184121_ak());
        LittleAbsoluteVec absPos = new LittleAbsoluteVec(res, context);
        if (LittleAction.isUsingSecondMode((EntityPlayer)plr)) {
            position.facing = position.facing.func_176734_d();
        }
        Point3f posOffsetted = StructureUtils.facingOffset(absPos.getPosX(), absPos.getPosY(), absPos.getPosZ(), contextSize, position.facing);
        int n = additional = rightClick ? 1 : 0;
        if (GuiScreen.func_146271_m()) {
            additional += 2;
        }
        NBTTagCompound data = ((NBTTagCompound)stackNBT.func_74781_a("measurements")).func_74775_l(index + "");
        NBTTagCompound pos = new NBTTagCompound();
        NBTTagCompound positions = new NBTTagCompound();
        if (data.func_74764_b("positions")) {
            positions = data.func_74775_l("positions");
        }
        pos.func_74782_a("pos", (NBTBase)NBTUtils.writeDoubleArrayFrom(posOffsetted.x, posOffsetted.y, posOffsetted.z));
        pos.func_74778_a("facing", position.facing.func_176610_l());
        positions.func_74782_a(additional + "", (NBTBase)pos);
        data.func_74782_a("positions", (NBTBase)positions);
        stack.func_77982_d(stackNBT);
        PacketHandler.sendPacketToServer((CreativeCorePacket)new PacketUpdateNBT(stack));
        return false;
    }

    public static LittleGridContext getSelectedContext(NBTTagCompound stackNBT) {
        NBTTagCompound selected = stackNBT.func_74775_l("measurements").func_74775_l(stackNBT.func_74762_e("index") + "");
        return selected.func_74764_b("context") && selected.func_74762_e("context") >= 0 && selected.func_74762_e("context") < LittleGridContext.gridSizes.length ? LittleGridContext.context[selected.func_74762_e("context")] : ItemMultiTiles.currentContext;
    }

    public static LittleGridContext getContextAt(NBTTagCompound stackNBT, int index) {
        NBTTagCompound selected = stackNBT.func_74775_l("measurements").func_74775_l(index + "");
        return selected.func_74764_b("context") && selected.func_74762_e("context") >= 0 && selected.func_74762_e("context") < LittleGridContext.gridSizes.length ? LittleGridContext.context[selected.func_74762_e("context")] : ItemMultiTiles.currentContext;
    }

    public void tick(EntityPlayer player, ItemStack stack, PlacementPosition position, RayTraceResult result) {
        NBTTagCompound stackNBT = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        LittleGridContext context = ItemTapeMeasure.getSelectedContext(stackNBT);
        LittleAbsoluteVec pos = new LittleAbsoluteVec(result, context);
        if (LittleAction.isUsingSecondMode((EntityPlayer)player)) {
            result.field_178784_b = result.field_178784_b.func_176734_d();
        }
        Point3f posEdit = StructureUtils.facingOffset(pos.getPosX(), pos.getPosY(), pos.getPosZ(), context.size, result.field_178784_b);
        TapeRenderer.renderCursor(posEdit, context);
    }

    public void onKeyPress(int pressedKey, EntityPlayer player, ItemStack stack) {
        if (pressedKey == 5) {
            this.clear(stack, stack.func_77978_p().func_74762_e("index"), player);
        }
    }

    public void rotate(EntityPlayer player, ItemStack stack, Rotation rotation, boolean client) {
        NBTTagCompound stackNBT;
        NBTTagCompound nBTTagCompound = stackNBT = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        if (stackNBT.func_74764_b("index")) {
            int index = stackNBT.func_74762_e("index");
            if (rotation == Rotation.Z_CLOCKWISE) {
                --index;
            }
            if (rotation == Rotation.Z_COUNTER_CLOCKWISE) {
                ++index;
            }
            if (index > 9) {
                index = 0;
            } else if (index < 0) {
                index = 9;
            }
            stackNBT.func_74768_a("index", index);
            if (!stackNBT.func_74775_l("measurements").func_74764_b(index + "")) {
                ItemTapeMeasure.setDefaultMeasurmentNBT(stack, index);
            }
            stack.func_77982_d(stackNBT);
        }
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return 0.0f;
    }

    public boolean canDestroyBlockInCreative(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public SubGuiConfigure getConfigureGUI(EntityPlayer player, ItemStack stack) {
        return new SubGuiTapeMeasure(stack);
    }

    public SubGuiConfigure getConfigureGUIAdvanced(EntityPlayer player, ItemStack stack) {
        return null;
    }

    public SubContainerConfigure getConfigureContainer(EntityPlayer player, ItemStack stack) {
        return new SubContainerConfigure(player, stack);
    }

    public boolean hasLittlePreview(ItemStack stack) {
        return true;
    }

    public LittlePreviews getLittlePreview(ItemStack stack) {
        return null;
    }

    public void saveLittlePreview(ItemStack stack, LittlePreviews previews) {
    }

    public boolean containsIngredients(ItemStack stack) {
        return false;
    }

    public Object[] tooltipData(ItemStack stack) {
        return new Object[]{LittleTilesClient.configure.getDisplayName(), LittleTilesClient.up.getDisplayName(), LittleTilesClient.down.getDisplayName(), ALETClient.clearMeasurment.getDisplayName()};
    }

    @SideOnly(value=Side.CLIENT)
    public IMarkMode onMark(EntityPlayer player, ItemStack stack, PlacementPosition position, RayTraceResult result, PlacementPreview previews) {
        return new MarkMode(player, position, previews);
    }

    public class PosData {
        public SelectLittleTile tilePosMin;
        public SelectLittleTile tilePosMax;
        public SelectLittleTile tilePosCursor;
        public RayTraceResult result;

        public PosData(SelectLittleTile posMin, SelectLittleTile posMax, SelectLittleTile posCursor, RayTraceResult res) {
            this.tilePosMin = posMin;
            this.tilePosMax = posMax;
            this.tilePosCursor = posCursor;
            this.result = res;
        }

        public PosData(SelectLittleTile pos, SelectLittleTile posCursor, RayTraceResult res) {
            this.tilePosMin = pos;
            this.tilePosMax = pos;
            this.tilePosCursor = posCursor;
            this.result = res;
        }
    }
}

