/*
 * Decompiled with CFR 0.152.
 */
package com.alet.font;

import com.alet.ALET;
import com.alet.common.utils.photo.PhotoReader;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.block.BlockLittleDyeable;
import com.creativemd.littletiles.common.tile.LittleTileColored;
import com.creativemd.littletiles.common.tile.combine.BasicCombiner;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.io.IOUtils;

public class FontReader {
    public static int fontSize;
    public static String fontType;

    public static BufferedImage fontToPhoto(String text, String fontType, @Nullable Map<TextAttribute, Object> textAttributeMap, int fontSize, int fontColor, double rotation) {
        if (text.equalsIgnoreCase("When Redstone?")) {
            text = "Please read the FAQ in TeamCreative's Discord";
        }
        Color color = new Color(fontColor, true);
        BufferedImage image = new BufferedImage(1, 1, 2);
        Graphics2D g2d = image.createGraphics();
        Font font = new Font(fontType, 0, fontSize);
        if (textAttributeMap != null && !textAttributeMap.isEmpty()) {
            Map<TextAttribute, ?> fontAttr = font.getAttributes();
            fontAttr.putAll(textAttributeMap);
            font = new Font(fontAttr);
        }
        g2d.setFont(font);
        FontMetrics fm = g2d.getFontMetrics();
        int w = fm.stringWidth(text) + 10;
        int h = fm.getHeight() + 1;
        g2d.dispose();
        double rads = Math.toRadians(rotation);
        double sin = Math.abs(Math.sin(rads));
        double cos = Math.abs(Math.cos(rads));
        int newWidth = (int)Math.floor((double)w * cos + (double)h * sin);
        int newHeight = (int)Math.floor((double)h * cos + (double)w * sin);
        image = new BufferedImage(newWidth, newHeight, 2);
        g2d = image.createGraphics();
        AffineTransform at = new AffineTransform();
        at.translate((newWidth - w) / 2, (newHeight - h) / 2);
        int x = w / 2;
        int y = h / 2;
        at.rotate(rads, x, y);
        g2d.setTransform(at);
        g2d.setFont(font);
        fm = g2d.getFontMetrics();
        g2d.setColor(color);
        g2d.drawString(text, 0, fm.getAscent());
        g2d.dispose();
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NBTTagCompound photoToNBT(String input, String font, @Nullable Map<TextAttribute, Object> textAttributeMap, int grid, int fontSize, int fontColor, double rotation) throws IOException {
        InputStream in = null;
        Object file = null;
        BufferedImage image = null;
        int color = 0;
        int maxPixelAmount = ALET.CONFIG.getMaxPixelText();
        try {
            int height;
            int width;
            image = FontReader.fontToPhoto(input, font, textAttributeMap, fontSize, fontColor, rotation);
            if (PhotoReader.isRescale) {
                if (PhotoReader.scaleX >= 1 || PhotoReader.scaleY >= 1) {
                    image = PhotoReader.resize(image, PhotoReader.scaleY, PhotoReader.scaleX);
                }
                PhotoReader.isRescale = false;
            }
            if (image != null && (width = image.getWidth()) * (height = image.getHeight()) < maxPixelAmount) {
                LittleGridContext context = LittleGridContext.get((int)grid);
                ArrayList<LittlePreview> tiles = new ArrayList<LittlePreview>();
                int expected = image.getWidth() * image.getHeight();
                for (int x = 0; x < image.getWidth(); ++x) {
                    for (int y = 0; y < image.getHeight(); ++y) {
                        color = image.getRGB(x, image.getHeight() - y - 1);
                        if (ColorUtils.isInvisible((int)color)) continue;
                        LittleTileColored tile = new LittleTileColored((Block)LittleTiles.dyeableBlock, BlockLittleDyeable.LittleDyeableType.CLEAN.getMetadata(), color);
                        tile.setBox(new LittleBox(new LittleVec(x, y, 0)));
                        tiles.add(tile.getPreviewTile());
                    }
                }
                ItemStack stack = new ItemStack(LittleTiles.recipeAdvanced);
                LittlePreviews previews = new LittlePreviews(context);
                BasicCombiner.combine(tiles);
                for (LittlePreview tile : tiles) {
                    previews.addWithoutCheckingPreview(tile);
                }
                LittlePreview.savePreview((LittlePreviews)previews, (ItemStack)stack);
                NBTTagCompound nBTTagCompound = stack.func_77978_p();
                return nBTTagCompound;
            }
        }
        finally {
            IOUtils.closeQuietly(in);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LittlePreviews photoToPreviews(String input, String font, @Nullable Map<TextAttribute, Object> textAttributeMap, int grid, int fontSize, int fontColor, double rotation) throws IOException {
        InputStream in = null;
        Object file = null;
        BufferedImage image = null;
        int color = 0;
        int maxPixelAmount = ALET.CONFIG.getMaxPixelText();
        try {
            int height;
            int width;
            image = FontReader.fontToPhoto(input, font, textAttributeMap, fontSize, fontColor, rotation);
            if (PhotoReader.isRescale) {
                if (PhotoReader.scaleX >= 1 || PhotoReader.scaleY >= 1) {
                    image = PhotoReader.resize(image, PhotoReader.scaleY, PhotoReader.scaleX);
                }
                PhotoReader.isRescale = false;
            }
            if (image != null && (width = image.getWidth()) * (height = image.getHeight()) < maxPixelAmount) {
                LittleGridContext context = LittleGridContext.get((int)grid);
                ArrayList<LittlePreview> tiles = new ArrayList<LittlePreview>();
                int expected = image.getWidth() * image.getHeight();
                for (int x = 0; x < image.getWidth(); ++x) {
                    for (int y = 0; y < image.getHeight(); ++y) {
                        color = image.getRGB(x, image.getHeight() - y - 1);
                        if (ColorUtils.isInvisible((int)color)) continue;
                        LittleTileColored tile = new LittleTileColored((Block)LittleTiles.dyeableBlock, BlockLittleDyeable.LittleDyeableType.CLEAN.getMetadata(), color);
                        tile.setBox(new LittleBox(new LittleVec(x, y, 0)));
                        tiles.add(tile.getPreviewTile());
                    }
                }
                ItemStack stack = new ItemStack(LittleTiles.recipeAdvanced);
                LittlePreviews previews = new LittlePreviews(context);
                BasicCombiner.combine(tiles);
                for (LittlePreview tile : tiles) {
                    previews.addWithoutCheckingPreview(tile);
                }
                LittlePreview.savePreview((LittlePreviews)previews, (ItemStack)stack);
                LittlePreviews littlePreviews = LittlePreview.getPreview((ItemStack)stack);
                return littlePreviews;
            }
        }
        finally {
            IOUtils.closeQuietly(in);
        }
        return null;
    }

    public static int getTextPixelHeight(String text, String fontType, @Nullable Map<TextAttribute, Object> textAttributeMap, int fontSize) {
        BufferedImage image = new BufferedImage(1, 1, 2);
        Graphics2D g2d = image.createGraphics();
        Font font = new Font(fontType, 0, fontSize);
        if (textAttributeMap != null && !textAttributeMap.isEmpty()) {
            Map<TextAttribute, ?> fontAttr = font.getAttributes();
            fontAttr.putAll(textAttributeMap);
            font = new Font(fontAttr);
        }
        g2d.setFont(font);
        FontMetrics fm = g2d.getFontMetrics();
        int h = fm.getHeight() + 1;
        return h;
    }

    public static int getTextPixelWidth(String text, String fontType, @Nullable Map<TextAttribute, Object> textAttributeMap, int fontSize) {
        BufferedImage image = new BufferedImage(1, 1, 2);
        Graphics2D g2d = image.createGraphics();
        Font font = new Font(fontType, 0, fontSize);
        if (textAttributeMap != null && !textAttributeMap.isEmpty()) {
            Map<TextAttribute, ?> fontAttr = font.getAttributes();
            fontAttr.putAll(textAttributeMap);
            font = new Font(fontAttr);
        }
        g2d.setFont(font);
        FontMetrics fm = g2d.getFontMetrics();
        int w = fm.stringWidth(text) + 10;
        return w;
    }
}

