/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.utils.text.translation;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.io.IOUtils;

public class ManualTranslator {
    private static final Pattern NUMERIC_VARIABLE_PATTERN = Pattern.compile("%(\\d+\\$)?[\\d\\.]*[df]");
    private static final Splitter EQUAL_SIGN_SPLITTER = Splitter.on((char)'=').limit(2);
    private static final Map<String, String> languageList = Maps.newHashMap();

    public static String translateToLocal(String page) {
        String lang = Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
        InputStream stream = Minecraft.func_71410_x().getClass().getClassLoader().getResourceAsStream("assets/alet/lang/manual/" + page.toLowerCase() + "." + lang + ".lang");
        ManualTranslator.inject(stream);
        return stream == null ? "" : ManualTranslator.tryTranslateKey("manual.page");
    }

    public static void inject(InputStream inputstream) {
        try {
            Map<String, String> map = ManualTranslator.parseLangFile(inputstream);
            languageList.putAll(map);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputstream);
        }
    }

    public static Map<String, String> parseLangFile(InputStream inputstream) {
        HashMap table = Maps.newHashMap();
        try {
            inputstream = FMLCommonHandler.instance().loadLanguage((Map)table, inputstream);
            if (inputstream == null) {
                return table;
            }
            for (String s : IOUtils.readLines((InputStream)inputstream, (Charset)StandardCharsets.UTF_8)) {
                String[] astring;
                if (s.isEmpty() || s.charAt(0) == '#' || (astring = (String[])Iterables.toArray((Iterable)EQUAL_SIGN_SPLITTER.split((CharSequence)s), String.class)) == null || astring.length != 2) continue;
                String s1 = astring[0];
                String s2 = NUMERIC_VARIABLE_PATTERN.matcher(astring[1]).replaceAll("%$1s");
                table.put(s1, s2);
            }
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return table;
    }

    public static String tryTranslateKey(String key) {
        String s = languageList.get(key);
        return s == null ? key : s;
    }
}

