/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.utils.photo;

import com.alet.ALET;
import com.alet.client.gui.SubGuiPhotoImport;
import com.alet.common.utils.photo.ColorAccuracy;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.controls.gui.GuiProgressBar;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.block.BlockLittleDyeable;
import com.creativemd.littletiles.common.tile.LittleTileColored;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.preview.LittleAbsolutePreviews;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.io.IOUtils;
import org.lwjgl.util.Color;

public class PhotoReader {
    public static int scaleX = 1;
    public static int scaleY = 1;
    public static boolean isRescale = false;

    public static InputStream load(String url) throws IOException {
        long requestTime = System.currentTimeMillis();
        URLConnection connection = new URL(url).openConnection();
        connection.addRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)");
        return connection.getInputStream();
    }

    public static BufferedImage resize(BufferedImage img, int height, int width) {
        Image tmp = img.getScaledInstance(width, height, 2);
        BufferedImage resized = new BufferedImage(width, height, 6);
        Graphics2D g2d = resized.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        return resized;
    }

    public static BufferedImage getImage(String input, String uploadOption) throws IOException {
        InputStream in = null;
        File file = null;
        BufferedImage image = null;
        if (uploadOption.equals("Print From Item") || uploadOption.equals("Print From Block")) {
            in = PhotoReader.class.getClassLoader().getResourceAsStream(input);
            image = ImageIO.read(in);
        } else if (uploadOption.equals("Print From URL")) {
            in = PhotoReader.load(input);
            image = ImageIO.read(in);
        } else if (uploadOption.equals("Print From File")) {
            file = new File(input);
            image = ImageIO.read(file);
        }
        return image;
    }

    public static int getPixelWidth(String input, String uploadOption) {
        BufferedImage image = null;
        try {
            image = PhotoReader.getImage(input, uploadOption);
        }
        catch (IOException e) {
            return 1;
        }
        return image.getWidth();
    }

    public static int getPixelLength(String input, String uploadOption) {
        BufferedImage image = null;
        try {
            image = PhotoReader.getImage(input, uploadOption);
        }
        catch (IOException e) {
            return 1;
        }
        return image.getHeight();
    }

    public static boolean photoExists(String input, String uploadOption) {
        BufferedImage image = null;
        try {
            image = PhotoReader.getImage(input, uploadOption);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return image != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ItemStack photoToStack(String input, boolean ignoreAlpha, String uploadOption, int grid, SubGui gui, double colorPerc) throws IOException {
        block18: {
            GuiProgressBar progress = (GuiProgressBar)((SubGuiPhotoImport)gui).get("progress");
            InputStream in = null;
            Object file = null;
            BufferedImage image = null;
            int color = 0;
            int maxPixelAmount = ALET.CONFIG.getMaxPixelAmount();
            ColorAccuracy.setColorAccuracy(colorPerc);
            try {
                image = PhotoReader.getImage(input, uploadOption);
                if (isRescale) {
                    if (scaleX >= 1 || scaleY >= 1) {
                        image = PhotoReader.resize(image, scaleY, scaleX);
                    }
                    isRescale = false;
                }
                if (image == null) break block18;
                int width = image.getWidth();
                int height = image.getHeight();
                byte[] pixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                boolean hasAlphaChannel = image.getAlphaRaster() != null;
                int[][] result = new int[height][width];
                if (width * height <= maxPixelAmount) {
                    int argb;
                    int col;
                    int row;
                    int pixel;
                    int pixelLength;
                    if (hasAlphaChannel) {
                        pixelLength = 4;
                        pixel = 0;
                        row = height - 1;
                        col = 0;
                        while (pixel + 3 < pixels.length) {
                            argb = 0;
                            argb += (pixels[pixel] & 0xFF) << 24;
                            argb += pixels[pixel + 1] & 0xFF;
                            argb += (pixels[pixel + 2] & 0xFF) << 8;
                            result[row][col] = argb += (pixels[pixel + 3] & 0xFF) << 16;
                            if (++col == width) {
                                col = 0;
                                --row;
                            }
                            pixel += 4;
                        }
                    } else {
                        pixelLength = 3;
                        pixel = 0;
                        row = height - 1;
                        col = 0;
                        while (pixel + 2 < pixels.length) {
                            argb = 0;
                            argb -= 0x1000000;
                            argb += pixels[pixel] & 0xFF;
                            argb += (pixels[pixel + 1] & 0xFF) << 8;
                            result[row][col] = argb += (pixels[pixel + 2] & 0xFF) << 16;
                            if (++col == width) {
                                col = 0;
                                --row;
                            }
                            pixel += 3;
                        }
                    }
                }
                LittleGridContext context = LittleGridContext.get((int)grid);
                ArrayList<LittlePreview> tiles = new ArrayList<LittlePreview>();
                for (int row = 0; row < result.length; ++row) {
                    for (int col = 0; col < result[row].length; ++col) {
                        color = ColorAccuracy.roundRGB(result[row][col]);
                        if (ColorUtils.isInvisible((int)color)) continue;
                        if (ignoreAlpha) {
                            Color c = ColorUtils.IntToRGBA((int)color);
                            c.setAlpha(255);
                            color = ColorUtils.RGBAToInt((Color)c);
                        }
                        LittleTileColored colorTile = new LittleTileColored((Block)LittleTiles.dyeableBlock, BlockLittleDyeable.LittleDyeableType.CLEAN.getMetadata(), color);
                        colorTile.setBox(new LittleBox(new LittleVec(col, row, 0)));
                        tiles.add(colorTile.getPreviewTile());
                    }
                }
                ItemStack stack = new ItemStack(LittleTiles.recipeAdvanced);
                LittlePreviews previews = new LittlePreviews(context);
                for (LittlePreview tile : tiles) {
                    previews.addWithoutCheckingPreview(tile);
                }
                PhotoReader.savePreview(previews, stack, progress);
                ItemStack itemStack = stack;
                return itemStack;
            }
            catch (IOException iOException) {
            }
            finally {
                IOUtils.closeQuietly(in);
            }
        }
        isRescale = false;
        return ItemStack.field_190927_a;
    }

    public static void setScale(int x, int y) {
        isRescale = true;
        scaleX = x;
        scaleY = y;
    }

    public static void savePreview(LittlePreviews previews, ItemStack stack, GuiProgressBar progress) {
        NBTTagList list;
        if (previews instanceof LittleAbsolutePreviews) {
            throw new IllegalArgumentException("Absolute positions cannot be saved!");
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (previews.hasStructure()) {
            stack.func_77978_p().func_74782_a("structure", (NBTBase)previews.structureNBT);
        }
        previews.getContext().set(stack.func_77978_p());
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (LittlePreview preview : previews.allPreviews()) {
            minX = Math.min(minX, preview.box.minX);
            minY = Math.min(minY, preview.box.minY);
            minZ = Math.min(minZ, preview.box.minZ);
            maxX = Math.max(maxX, preview.box.maxX);
            maxY = Math.max(maxY, preview.box.maxY);
            maxZ = Math.max(maxZ, preview.box.maxZ);
        }
        new LittleVec(maxX - minX, maxY - minY, maxZ - minZ).writeToNBT("size", stack.func_77978_p());
        new LittleVec(minX, minY, minZ).writeToNBT("min", stack.func_77978_p());
        if (previews.totalSize() >= LittlePreview.lowResolutionMode) {
            list = new NBTTagList();
            HashSet<BlockPos> positions = new HashSet<BlockPos>();
            for (int i = 0; i < previews.size(); ++i) {
                BlockPos pos = previews.get((int)i).box.getMinVec().getBlockPos(previews.getContext());
                if (positions.contains(pos)) continue;
                positions.add(pos);
                list.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}));
            }
            stack.func_77978_p().func_74782_a("pos", (NBTBase)list);
        } else {
            stack.func_77978_p().func_82580_o("pos");
        }
        list = PhotoReader.writePreviews(previews, progress);
        stack.func_77978_p().func_74782_a("tiles", (NBTBase)list);
        stack.func_77978_p().func_74768_a("count", previews.size());
        stack.func_77978_p().func_82580_o("children");
    }

    public static NBTTagList writePreviews(LittlePreviews previews, GuiProgressBar progress) {
        HashMapList groups = new HashMapList();
        for (LittlePreview preview : previews) {
            groups.add((Object)preview.getTypeIdToSave(), (Object)preview);
        }
        NBTTagList list = new NBTTagList();
        for (ArrayList classList : groups.values()) {
            int classListMax = classList.size();
            progress.max = classList.size();
            while (classList.size() > 0) {
                LittlePreview grouping = (LittlePreview)classList.remove(0);
                NBTTagCompound groupNBT = null;
                Iterator iterator2 = classList.iterator();
                while (iterator2.hasNext()) {
                    LittlePreview preview = (LittlePreview)iterator2.next();
                    if (!grouping.canBeNBTGrouped(preview)) continue;
                    if (groupNBT == null) {
                        groupNBT = grouping.startNBTGrouping();
                    }
                    grouping.groupNBTTile(groupNBT, preview);
                    iterator2.remove();
                }
                progress.pos = classListMax - classList.size();
                if (groupNBT == null) {
                    NBTTagCompound nbt = new NBTTagCompound();
                    grouping.writeToNBT(nbt);
                    list.func_74742_a((NBTBase)nbt);
                    continue;
                }
                list.func_74742_a(groupNBT);
            }
        }
        return list;
    }
}

