/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.utils;

import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.littletiles.common.block.BlockTile;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.relative.StructureRelative;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.place.Placement;
import com.creativemd.littletiles.common.util.place.PlacementMode;
import com.creativemd.littletiles.common.util.place.PlacementPreview;
import com.creativemd.littletiles.common.util.place.PlacementResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.vecmath.Point3f;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class StructureUtils {
    public static LittleStructure getStructureAt(World worldIn, LittleBox box, BlockPos pos, LittleGridContext context, @Nullable LittleStructure self, @Nullable Class<? extends LittleStructure> structureClass) {
        TileEntityLittleTiles te = BlockTile.loadTe((IBlockAccess)worldIn, (BlockPos)pos);
        if (te != null) {
            for (IStructureTileList s : te.structures()) {
                try {
                    LittleStructure structure = s.getStructure();
                    if (structureClass != null && structure.getClass() != structureClass || structure == self || structure.isChildOf(self)) continue;
                    for (Pair tile : structure.tiles()) {
                        if (!((IStructureTileList)tile.key).getPos().equals((Object)pos)) continue;
                        LittleBox copy = ((LittleTile)tile.value).getBox().copy();
                        copy.convertTo(((IStructureTileList)tile.key).getContext().size, context.size);
                        if (!StructureUtils.intersectsWith(copy, box)) continue;
                        return s.getStructure();
                    }
                }
                catch (CorruptedConnectionException | NotYetConnectedException throwable) {
                }
            }
        }
        return null;
    }

    public static Point3f facingOffset(double x, double y, double z, int contextSize, EnumFacing facing) {
        double offset = 1.0 / (double)contextSize;
        switch (facing) {
            case UP: {
                y -= offset;
                break;
            }
            case EAST: {
                x -= offset;
                break;
            }
            case SOUTH: {
                z -= offset;
                break;
            }
        }
        Point3f vec = new Point3f((float)x, (float)y, (float)z);
        return vec;
    }

    public static LittleStructure findConnection(World worldIn, BlockPos structurePos, StructureRelative searchArea, @Nullable LittleStructure self, @Nullable Class<? extends LittleStructure> structureClass) {
        LittleBox foundBox = searchArea.getBox().copy();
        double searchX = searchArea.getCenter().x;
        double searchY = searchArea.getCenter().y;
        double searchZ = searchArea.getCenter().z;
        BlockPos posSearch = new BlockPos((double)structurePos.func_177958_n() + searchX, (double)structurePos.func_177956_o() + searchY, (double)structurePos.func_177952_p() + searchZ);
        HashMapList boxesSearch = new HashMapList();
        foundBox.split(searchArea.getContext(), structurePos, boxesSearch, null);
        for (Map.Entry b : boxesSearch.entrySet()) {
            if (!((BlockPos)b.getKey()).equals((Object)posSearch)) continue;
            foundBox = (LittleBox)((ArrayList)b.getValue()).get(0);
        }
        return StructureUtils.getStructureAt(worldIn, foundBox, posSearch, searchArea.getContext(), self, structureClass);
    }

    public static boolean intersectsWith(LittleBox box, LittleBox box2) {
        return box.maxX > box2.minX && box.minX < box2.maxX && box.maxY > box2.minY && box.minY < box2.maxY && box.maxZ > box2.minZ && box.minZ < box2.maxZ;
    }

    public static LittlePreviews addChildToStructure(LittleStructure child, LittleStructure parent, boolean dynamic) {
        if (parent == null || child == null) {
            return null;
        }
        try {
            LittlePreviews ch = child.getPreviews(parent.getPos());
            LittlePreviews par = parent.getPreviews(parent.getPos());
            par.addChild(ch, dynamic);
            return par.copy();
        }
        catch (CorruptedConnectionException | NotYetConnectedException throwable) {
            return null;
        }
    }

    public static LittlePreviews addPreviewToStructure(LittlePreviews previews, LittleStructure parent, boolean dynamic) {
        if (parent == null || previews == null) {
            return null;
        }
        try {
            LittlePreviews par = parent.getPreviews(parent.getPos());
            par.addChild(previews, dynamic);
            return par.copy();
        }
        catch (CorruptedConnectionException | NotYetConnectedException throwable) {
            return null;
        }
    }

    public static void placeStructure(LittleStructure structure, World worldIn, BlockPos pos, LittleVec offset, EnumFacing facing, EntityPlayer playerIn) {
        try {
            LittlePreviews preview = structure.getPreviews(pos);
            PlacementPreview placePreview = new PlacementPreview(worldIn, preview, PlacementMode.fill, preview.getSurroundingBox(), true, pos, offset, facing);
            Placement place = new Placement(playerIn, placePreview);
            place.tryPlace();
        }
        catch (CorruptedConnectionException | NotYetConnectedException throwable) {
            // empty catch block
        }
    }

    public static boolean placePreview(LittlePreviews preview, World worldIn, BlockPos pos, LittleVec offset, EnumFacing facing, EntityPlayer playerIn) {
        PlacementPreview placePreview = new PlacementPreview(worldIn, preview, PlacementMode.fill, preview.getSurroundingBox(), true, pos, offset, facing);
        Placement place = new Placement(playerIn, placePreview);
        PlacementResult results = place.tryPlace();
        return results != null;
    }

    public static boolean mergeChildToStructure(LittleStructure child, LittleStructure parent, boolean dynamic, World worldIn, LittleVec offset, EnumFacing facing, EntityPlayer playerIn) {
        try {
            LittlePreviews preview = StructureUtils.addChildToStructure(child, parent, dynamic);
            BlockPos pos = parent.getPos();
            parent.onLittleTileDestroy();
            child.onLittleTileDestroy();
            return StructureUtils.placePreview(preview, worldIn, pos, offset, facing, playerIn);
        }
        catch (CorruptedConnectionException | NotYetConnectedException throwable) {
            return false;
        }
    }

    public static boolean mergePreviewToStructure(LittlePreviews previews, LittleStructure parent, boolean dynamic, World worldIn, LittleVec offset, EnumFacing facing, EntityPlayer playerIn) {
        try {
            LittlePreviews preview = StructureUtils.addPreviewToStructure(previews, parent, dynamic);
            BlockPos pos = parent.getPos();
            parent.onLittleTileDestroy();
            return StructureUtils.placePreview(preview, worldIn, pos, offset, facing, playerIn);
        }
        catch (CorruptedConnectionException | NotYetConnectedException throwable) {
            return false;
        }
    }

    public static void replaceStructure(LittleStructure replace, LittleStructure original, World worldIn, BlockPos pos, EnumFacing facing, EntityPlayer playerIn) {
        try {
            LittlePreviews preview = replace.getPreviews(replace.getPos()).copy();
            replace.onLittleTileDestroy();
            original.onLittleTileDestroy();
            StructureUtils.placePreview(preview, worldIn, pos, new LittleVec(0, 0, 0), facing, playerIn);
        }
        catch (CorruptedConnectionException | NotYetConnectedException e) {
            e.printStackTrace();
        }
    }

    public static boolean removeThisDynamicChild(LittleStructure child) {
        try {
            LittleStructure parent = child.getParent().getStructure();
            for (int i = 0; i < parent.countChildren(); ++i) {
                if (!parent.getChild(i).getStructure().equals(child)) continue;
                parent.removeDynamicChild(i);
                parent.updateStructure();
                return true;
            }
        }
        catch (CorruptedConnectionException | NotYetConnectedException throwable) {
            // empty catch block
        }
        return false;
    }

    public static List<BlockPos> getBlockArea(LittleStructure structure) {
        try {
            ArrayList<BlockPos> blockPositions = new ArrayList<BlockPos>();
            for (TileEntityLittleTiles te : structure.blocks()) {
                blockPositions.add(te.func_174877_v());
            }
            return blockPositions;
        }
        catch (CorruptedConnectionException | NotYetConnectedException throwable) {
            return null;
        }
    }
}

