/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.utils;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.nio.IntBuffer;
import java.util.HashMap;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Cursor;
import org.lwjgl.input.Mouse;

public class MouseUtils {
    private static final Cursor DEFAULT_CURSOR = Mouse.getNativeCursor();
    private static HashMap<String, Cursor> listOfCursors = new HashMap();

    public static void addCursor(String name, int width, int height, String modid, String location) {
        try {
            BufferedImage image = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(modid, location)).func_110527_b());
            BufferedImage resizedImage = new BufferedImage(width, height, 2);
            Graphics2D graphics2D = resizedImage.createGraphics();
            graphics2D.translate((resizedImage.getHeight() - resizedImage.getWidth()) / 2, (resizedImage.getHeight() - resizedImage.getWidth()) / 2);
            graphics2D.rotate(Math.toRadians(180.0), resizedImage.getHeight() / 2, resizedImage.getWidth() / 2);
            graphics2D.drawImage(image, 0, 0, width, height, null);
            graphics2D.dispose();
            Cursor cursor = new Cursor(resizedImage.getWidth(), resizedImage.getHeight(), resizedImage.getWidth() / 2, resizedImage.getHeight() / 2, 1, IntBuffer.wrap(resizedImage.getRGB(0, 0, resizedImage.getWidth(), resizedImage.getHeight(), null, 0, resizedImage.getWidth())), null);
            listOfCursors.put(name, cursor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addCursor(String name, String modid, String location) {
        MouseUtils.addCursor(name, 32, 32, modid, location);
    }

    public static void setCursor(String name) {
        try {
            Mouse.setNativeCursor((Cursor)listOfCursors.get(name));
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
    }

    public static void resetCursor() {
        try {
            Mouse.setNativeCursor((Cursor)DEFAULT_CURSOR);
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
    }

    static {
        MouseUtils.addCursor("move", "alet", "textures/cursors/move.png");
        MouseUtils.addCursor("open_hand", "alet", "textures/cursors/open_hand.png");
        MouseUtils.addCursor("dotted_line", "alet", "textures/cursors/dotted_line.png");
        MouseUtils.addCursor("close", 16, 16, "alet", "textures/cursors/close.png");
    }
}

