/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.utils;

import com.creativemd.littletiles.client.gui.signal.SubGuiDialogSignal;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.signal.component.ISignalComponent;
import com.creativemd.littletiles.common.structure.signal.component.SignalComponentType;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import java.util.ArrayList;
import java.util.List;

public class ComponentSearch {
    public LittlePreviews previews;
    public LittleStructureType type;

    public ComponentSearch(LittlePreviews previews, LittleStructureType type) {
        this.previews = previews;
        this.type = type;
    }

    public List<SubGuiDialogSignal.GuiSignalComponent> search(boolean input, boolean output, boolean includeRelations) {
        ArrayList<SubGuiDialogSignal.GuiSignalComponent> list = new ArrayList<SubGuiDialogSignal.GuiSignalComponent>();
        if (input) {
            this.gatherInputs(this.previews, this.type, "", "", list, includeRelations, true);
        }
        if (output) {
            this.gatherOutputs(this.previews, this.type, "", "", list, includeRelations, true);
        }
        return list;
    }

    protected void addInput(LittlePreviews previews, LittleStructureType type, String prefix, String totalNamePrefix, List<SubGuiDialogSignal.GuiSignalComponent> list, boolean includeRelations) {
        int i;
        String parentName = previews.getStructureName();
        if (type != null && type.inputs != null) {
            for (i = 0; i < type.inputs.size(); ++i) {
                list.add(new SubGuiDialogSignal.GuiSignalComponent(prefix + "a" + i, totalNamePrefix, (LittleStructureType.InternalComponent)type.inputs.get(i), true, false, i, parentName));
            }
        }
        for (i = 0; i < previews.childrenCount(); ++i) {
            LittlePreviews child = previews.getChild(i);
            if (child == this.previews) continue;
            LittleStructureType structure = child.getStructureType();
            String name = child.getStructureName();
            if (structure instanceof ISignalComponent && ((ISignalComponent)structure).getType() == SignalComponentType.INPUT) {
                list.add(new SubGuiDialogSignal.GuiSignalComponent(prefix + "i" + i, totalNamePrefix + (name != null ? name : "i" + i), (ISignalComponent)structure, true, i, parentName));
                continue;
            }
            if (!includeRelations) continue;
            this.gatherInputs(child, child.getStructureType(), prefix + "c" + i + ".", totalNamePrefix + (name != null ? name + "." : "c" + i + "."), list, includeRelations, false);
        }
    }

    protected void gatherInputs(LittlePreviews previews, LittleStructureType type, String prefix, String totalNamePrefix, List<SubGuiDialogSignal.GuiSignalComponent> list, boolean includeRelations, boolean searchForParent) {
        if (previews == this.previews) {
            this.addInput(previews, type, "", "", list, includeRelations);
        }
        if (searchForParent && previews.hasParent() && includeRelations) {
            this.gatherInputs(previews.getParent(), previews.getParent().getStructureType(), "p." + prefix, "p." + totalNamePrefix, list, includeRelations, true);
            return;
        }
        if (previews != this.previews) {
            this.addInput(previews, type, prefix, totalNamePrefix, list, includeRelations);
        }
    }

    protected void addOutput(LittlePreviews previews, LittleStructureType type, String prefix, String totalNamePrefix, List<SubGuiDialogSignal.GuiSignalComponent> list, boolean includeRelations) {
        int i;
        String parentName = previews.getStructureName();
        if (type != null && type.outputs != null) {
            for (i = 0; i < type.outputs.size(); ++i) {
                list.add(new SubGuiDialogSignal.GuiSignalComponent(prefix + "b" + i, totalNamePrefix, (LittleStructureType.InternalComponent)type.outputs.get(i), false, false, i, parentName));
            }
        }
        for (i = 0; i < previews.childrenCount(); ++i) {
            LittlePreviews child = previews.getChild(i);
            if (child == this.previews) continue;
            LittleStructureType structure = child.getStructureType();
            String name = child.getStructureName();
            if (structure instanceof ISignalComponent && ((ISignalComponent)structure).getType() == SignalComponentType.OUTPUT) {
                list.add(new SubGuiDialogSignal.GuiSignalComponent(prefix + "o" + i, totalNamePrefix + (name != null ? name : "o" + i), (ISignalComponent)structure, true, i, parentName));
                continue;
            }
            if (!includeRelations) continue;
            this.gatherOutputs(child, child.getStructureType(), prefix + "c" + i + ".", totalNamePrefix + (name != null ? name + "." : "c" + i + "."), list, includeRelations, false);
        }
    }

    protected void gatherOutputs(LittlePreviews previews, LittleStructureType type, String prefix, String totalNamePrefix, List<SubGuiDialogSignal.GuiSignalComponent> list, boolean includeRelations, boolean searchForParent) {
        if (previews == this.previews) {
            this.addOutput(previews, type, "", "", list, includeRelations);
        }
        if (searchForParent && previews.hasParent() && includeRelations) {
            this.gatherOutputs(previews.getParent(), previews.getParent().getStructureType(), "p." + prefix, "p." + totalNamePrefix, list, includeRelations, searchForParent);
            return;
        }
        if (previews != this.previews) {
            this.addOutput(previews, type, prefix, totalNamePrefix, list, includeRelations);
        }
    }
}

