/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.structure.type.programable.basic.events;

import com.alet.common.structure.type.programable.basic.LittleTriggerObject;
import com.alet.common.structure.type.programable.basic.events.LittleTriggerEvent;
import com.alet.common.utils.ComponentSearch;
import com.creativemd.creativecore.common.gui.CoreControl;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiPanel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.gui.event.ControlEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.utils.math.BooleanUtils;
import com.creativemd.littletiles.client.gui.signal.SubGuiDialogSignal;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.signal.component.ISignalComponent;
import com.creativemd.littletiles.common.structure.signal.logic.SignalPatternParser;
import com.creativemd.littletiles.common.structure.signal.logic.SignalTarget;
import com.creativemd.littletiles.common.structure.signal.output.InternalSignalOutput;
import com.creativemd.littletiles.common.structure.signal.output.SignalExternalOutputHandler;
import com.creativemd.littletiles.common.structure.signal.output.SignalOutputHandler;
import com.creativemd.littletiles.common.structure.type.premade.signal.LittleSignalOutput;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleTriggerEventSetSignal
extends LittleTriggerEvent {
    public String outputName = "";
    public int outputValue = 0;

    public LittleTriggerEventSetSignal(int id) {
        super(id);
    }

    @Override
    public boolean runEvent() {
        try {
            InternalSignalOutput o;
            SignalTarget target = SignalTarget.parseTarget((SignalPatternParser)new SignalPatternParser(this.outputName), (boolean)true, (boolean)false);
            ISignalComponent componet = target.getTarget((LittleStructure)this.structure);
            SignalOutputHandler handler = null;
            if (componet instanceof InternalSignalOutput) {
                o = (InternalSignalOutput)componet;
                handler = o.handler;
            } else if (componet instanceof LittleSignalOutput) {
                SignalExternalOutputHandler x;
                o = (LittleSignalOutput)componet;
                if (o.getParent() != null && (x = o.getParent().getStructure().getExternalOutputHandler(o.getParent().childId)) != null) {
                    handler = x.handler;
                }
                if (handler == null) {
                    boolean[] arr = new boolean[o.getBandwidth()];
                    BooleanUtils.intToBool((int)this.outputValue, (boolean[])arr);
                    o.updateState(arr);
                }
            }
            if (handler != null) {
                try {
                    boolean[] arr = new boolean[handler.getBandwidth()];
                    BooleanUtils.intToBool((int)this.outputValue, (boolean[])arr);
                    handler.schedule(arr);
                }
                catch (CorruptedConnectionException | NotYetConnectedException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (CorruptedConnectionException | NotYetConnectedException | ParseException e) {
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public LittleTriggerObject deserializeNBT(NBTTagCompound nbt) {
        this.outputName = nbt.func_74779_i("outputName");
        this.outputValue = nbt.func_74762_e("outputValue");
        return this;
    }

    @Override
    public NBTTagCompound serializeNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("outputName", this.outputName);
        nbt.func_74768_a("outputValue", this.outputValue);
        return nbt;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void createGuiControls(GuiPanel panel, LittlePreviews previews) {
        List<SubGuiDialogSignal.GuiSignalComponent> GuiSignalComponent2 = new ComponentSearch(previews, previews.getStructureType()).search(false, true, true);
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> title = new ArrayList<String>();
        int index = 0;
        int i = 0;
        for (SubGuiDialogSignal.GuiSignalComponent o : GuiSignalComponent2) {
            if (o.totalName.equals("allow") || o.totalName.equals("completed") || o.totalName.equals("activate")) continue;
            if (o.totalName.equals(this.outputName)) {
                index = i;
            }
            title.add(o.display());
            list.add(o.name);
            ++i;
        }
        GuiTitledComboBox box = new GuiTitledComboBox("outList", 0, 0, 153, title, list);
        if (!list.isEmpty()) {
            box.select(index);
            panel.raiseEvent((ControlEvent)new GuiControlChangedEvent((GuiControl)box));
        }
        panel.addControl((GuiControl)box);
        GuiTextfield text = new GuiTextfield("value", this.outputValue + "", 0, 23, 50, 8).setNumbersOnly();
        panel.addControl((GuiControl)text);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void guiChangedEvent(CoreControl source) {
        if (source.is(new String[]{"outList"})) {
            GuiTitledComboBox combo = (GuiTitledComboBox)source;
            this.outputName = combo.getSelected();
            System.out.println(this.outputName);
        }
        if (source.is(new String[]{"value"})) {
            GuiTextfield text = (GuiTextfield)source;
            if (!text.text.isEmpty()) {
                this.outputValue = Integer.parseInt(text.text);
            }
        }
    }

    protected class GuiTitledComboBox
    extends GuiComboBox {
        List<String> titles;

        public GuiTitledComboBox(String name, int x, int y, int width, List<String> titles, List<String> lines) {
            super(name, x, y, width, titles);
            this.titles = new ArrayList<String>();
            this.titles = lines;
        }

        public String getSelected() {
            return this.titles.get(this.index);
        }
    }
}

