/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.structure.type.programable.basic.events;

import com.alet.common.packet.PacketPlaySound;
import com.alet.common.structure.type.programable.basic.LittleTriggerObject;
import com.alet.common.structure.type.programable.basic.events.LittleTriggerEvent;
import com.creativemd.creativecore.common.gui.CoreControl;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.controls.gui.GuiAnalogeSlider;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiPanel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleTriggerEventPlaySound
extends LittleTriggerEvent {
    public float volume = 1.0f;
    public float pitch = 1.0f;
    public List<String> possibleLines = new ArrayList<String>();
    public String selected;

    public LittleTriggerEventPlaySound(int id) {
        super(id);
        for (ResourceLocation location : SoundEvent.field_187505_a.func_148742_b()) {
            this.possibleLines.add(location.toString());
        }
    }

    @Override
    public boolean runEvent() {
        for (Entity entity : this.getEntities()) {
            if (!(entity instanceof EntityPlayer)) continue;
            PacketHandler.sendPacketToPlayer((CreativeCorePacket)new PacketPlaySound(this.pitch, this.volume, false, this.structure.getPos(), this.selected), (EntityPlayerMP)((EntityPlayerMP)entity));
        }
        return true;
    }

    @Override
    public LittleTriggerObject deserializeNBT(NBTTagCompound nbt) {
        this.volume = nbt.func_74760_g("volume");
        this.pitch = nbt.func_74760_g("pitch");
        this.selected = nbt.func_74779_i("selected");
        return this;
    }

    @Override
    public NBTTagCompound serializeNBT(NBTTagCompound nbt) {
        nbt.func_74776_a("volume", this.volume);
        nbt.func_74776_a("pitch", this.pitch);
        nbt.func_74778_a("selected", this.selected);
        return nbt;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void createGuiControls(GuiPanel panel, LittlePreviews previews) {
        GuiTextfield search = new GuiTextfield("search", "", 0, 0, 170, 14);
        panel.addControl((GuiControl)search);
        GuiComboBox box = new GuiComboBox("sounds", 0, 22, 170, this.possibleLines);
        if (this.selected != null) {
            box.select(this.selected);
        } else {
            this.selected = box.getCaption();
        }
        panel.addControl((GuiControl)box);
        panel.addControl((GuiControl)new GuiLabel(I18n.func_74838_a((String)"gui.sound.volume") + ":", 0, 44));
        panel.addControl((GuiControl)new GuiAnalogeSlider("volume", 60, 44, 60, 8, (double)this.volume, 0.0, 1.0));
        panel.addControl((GuiControl)new GuiLabel(I18n.func_74838_a((String)"gui.sound.pitch") + ":", 0, 64));
        panel.addControl((GuiControl)new GuiAnalogeSlider("pitch", 60, 64, 60, 8, (double)this.pitch, 0.5, 2.0));
        panel.addControl((GuiControl)new GuiButton("play", 140, 44){

            public void onClicked(int x, int y, int button) {
                SoundEvent event = LittleTriggerEventPlaySound.this.getSelected();
                if (event != null) {
                    1.playSound((SoundEvent)event, (float)LittleTriggerEventPlaySound.this.volume, (float)LittleTriggerEventPlaySound.this.pitch);
                }
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public SoundEvent getSelected() {
        ResourceLocation location = this.getSelectionLocation();
        if (location != null) {
            return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)location);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getSelectionLocation() {
        if (this.selected != null && !this.selected.isEmpty()) {
            return new ResourceLocation(this.selected);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void guiChangedEvent(CoreControl source) {
        if (source instanceof GuiComboBox) {
            this.selected = ((GuiComboBox)source).getCaption();
        }
        if (source instanceof GuiAnalogeSlider) {
            GuiAnalogeSlider slider = (GuiAnalogeSlider)source;
            if (source.is(new String[]{"volume"})) {
                this.volume = (float)slider.value;
            }
            if (source.is(new String[]{"pitch"})) {
                this.pitch = (float)slider.value;
            }
        } else if (source instanceof GuiTextfield && source.is(new String[]{"search"})) {
            GuiTextfield search = (GuiTextfield)source;
            GuiComboBox sounds = (GuiComboBox)source.parent.get("sounds");
            ArrayList<String> foundLines = new ArrayList<String>();
            if (search.text.isEmpty()) {
                foundLines.addAll(this.possibleLines);
            } else {
                for (int i = 0; i < this.possibleLines.size(); ++i) {
                    if (!this.possibleLines.get(i).contains(search.text)) continue;
                    foundLines.add(this.possibleLines.get(i));
                }
            }
            sounds.lines = foundLines;
            if (!sounds.select(this.selected)) {
                sounds.select(0);
            }
        }
    }
}

