/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.structure.type.programable.basic.events;

import com.alet.common.structure.type.programable.basic.events.LittleTriggerEvent;
import com.creativemd.creativecore.common.gui.CoreControl;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiPanel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiScrollBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleTriggerEventModifyScoreboard
extends LittleTriggerEvent {
    public int value = 0;
    public String scoreName = "";
    private WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0);

    public LittleTriggerEventModifyScoreboard(int id) {
        super(id);
    }

    @Override
    public NBTTagCompound serializeNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("value", this.value);
        nbt.func_74778_a("scoreName", this.scoreName);
        return nbt;
    }

    @Override
    public LittleTriggerEvent deserializeNBT(NBTTagCompound nbt) {
        this.value = nbt.func_74762_e("value");
        this.scoreName = nbt.func_74779_i("scoreName");
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void createGuiControls(GuiPanel panel, LittlePreviews previews) {
        Scoreboard score = this.world.func_96441_U();
        Collection objectives = score.func_96514_c();
        ArrayList<String> list = new ArrayList<String>();
        for (ScoreObjective obj : objectives) {
            list.add(obj.func_96679_b());
        }
        LittleTriggerEventModifyScoreboard.wipeControls((GuiParent)panel);
        panel.addControl((GuiControl)new GuiLabel("Type:", 0, 100));
        panel.addControl((GuiControl)new GuiLabel("type", "", 30, 100));
        panel.addControl((GuiControl)new GuiLabel("Change Value by:", 0, 118));
        panel.addControl((GuiControl)new GuiTextfield("value", this.value + "", 90, 118, 30, 10).setNumbersIncludingNegativeOnly());
        panel.addControl((GuiControl)new GuiScrollBox("bx", 0, 40, 152, 50));
        GuiComboBox cBox = new GuiComboBox("ls", 0, 20, 152, list);
        cBox.setCaption(this.scoreName);
        cBox.width = 158;
        panel.addControl((GuiControl)cBox);
        this.fillComboBox(cBox);
        panel.addControl((GuiControl)new GuiLabel("Modify Scoreboard", 0, 0));
    }

    @SideOnly(value=Side.CLIENT)
    public void fillComboBox(GuiComboBox cBox) {
        GuiPanel panel = (GuiPanel)cBox.getGui().get("panel");
        GuiScrollBox sBox = (GuiScrollBox)panel.get("bx");
        Scoreboard score = this.world.func_96441_U();
        GuiLabel label = null;
        LittleTriggerEventModifyScoreboard.wipeControls((GuiParent)sBox);
        int i = 0;
        String caption = cBox.getCaption();
        for (Score sc : score.func_96528_e()) {
            String s = sc.func_96653_e().replaceAll("-", "");
            if (!sc.func_96645_d().func_96679_b().equals(caption)) continue;
            if (s.length() == 32) {
                long least;
                String m = s.substring(0, 16);
                String l = s.substring(16, 32);
                long most = new BigInteger(m, 16).longValue();
                UUID uuid = new UUID(most, least = new BigInteger(l, 16).longValue());
                Entity entity = this.world.func_175733_a(uuid);
                if (entity.func_95999_t() != null && !entity.func_95999_t().equals("")) {
                    label = this.shortenName(entity.func_95999_t(), i);
                    label.setCustomTooltip(new String[]{sc.func_96653_e()});
                } else {
                    label = this.shortenName(sc.func_96653_e(), i);
                }
            } else {
                label = this.shortenName(sc.func_96653_e(), i);
            }
            GuiLabel value = new GuiLabel("" + sc.func_96652_c(), 100, i * 15);
            GuiLabel type = (GuiLabel)panel.get("type");
            type.setCaption(sc.func_96645_d().func_96680_c().func_96636_a());
            sBox.addControl((GuiControl)label);
            sBox.addControl((GuiControl)value);
            ++i;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void guiChangedEvent(CoreControl source) {
        if (source instanceof GuiComboBox) {
            GuiComboBox cBox = (GuiComboBox)source;
            if (cBox.is(new String[]{"ls"})) {
                this.fillComboBox(cBox);
                this.scoreName = cBox.getCaption();
            }
        }
        if (source instanceof GuiTextfield) {
            GuiTextfield tField = (GuiTextfield)source;
            if (tField.name.equals("value")) {
                this.value = Integer.parseInt(tField.text);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public GuiLabel shortenName(String name, int y) {
        GuiLabel label = new GuiLabel(name, 0, y * 15);
        String fullName = new String(name);
        if (name.length() > 10) {
            name = name.substring(0, 10);
            label.setCaption(name + "...");
            label.setCustomTooltip(new String[]{fullName});
        }
        return label;
    }

    @Override
    public boolean runEvent() {
        Collection objectives = this.world.func_96441_U().func_96514_c();
        ScoreObjective objective = null;
        Score score = null;
        for (ScoreObjective obj : objectives) {
            if (!obj.func_96679_b().equals(this.scoreName)) continue;
            objective = obj;
            break;
        }
        for (Entity entity : this.getEntities()) {
            if (entity instanceof EntityPlayerMP) {
                score = this.world.func_96441_U().func_96529_a(entity.func_70005_c_(), objective);
                continue;
            }
            score = this.world.func_96441_U().func_96529_a(entity.func_110124_au().toString(), objective);
        }
        if (score != null) {
            if (this.value > 0) {
                score.func_96649_a(this.value);
            } else if (this.value < 0) {
                score.func_96646_b(Math.abs(this.value));
            }
        }
        return true;
    }
}

