/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.structure.type.programable.basic.events;

import com.alet.client.gui.LittleItemSelector;
import com.alet.client.gui.controls.GuiConnectedCheckBoxes;
import com.alet.client.gui.controls.GuiFakeSlot;
import com.alet.common.structure.type.programable.basic.events.LittleTriggerEvent;
import com.creativemd.creativecore.common.gui.CoreControl;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiPanel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.gui.controls.gui.custom.GuiStackSelectorAll;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.util.ingredient.LittleIngredient;
import com.creativemd.littletiles.common.util.ingredient.LittleIngredients;
import com.creativemd.littletiles.common.util.ingredient.LittleInventory;
import com.creativemd.littletiles.common.util.ingredient.NotEnoughIngredientsException;
import com.creativemd.littletiles.common.util.ingredient.StackIngredient;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class LittleTriggerEventModifyInventory
extends LittleTriggerEvent {
    public boolean addItem = true;
    public int stackCount = 1;
    public ItemStack stack = ItemStack.field_190927_a;
    public Slot selected = Slot.MAIN_HAND;
    public int slotID = 0;

    public LittleTriggerEventModifyInventory(int id) {
        super(id);
    }

    @Override
    public LittleTriggerEvent deserializeNBT(NBTTagCompound nbt) {
        this.addItem = nbt.func_74767_n("addItem");
        this.stackCount = nbt.func_74762_e("stackCount");
        this.stack = new ItemStack(nbt.func_74775_l("stack"));
        this.selected = Slot.getSlotFrom(nbt);
        return this;
    }

    @Override
    public NBTTagCompound serializeNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("addItem", this.addItem);
        nbt.func_74768_a("stackCount", this.stackCount);
        NBTTagCompound nbtItemStack = new NBTTagCompound();
        this.stack.func_77955_b(nbtItemStack);
        nbt.func_74782_a("stack", (NBTBase)nbtItemStack);
        nbt.func_74778_a("selected", this.selected != null ? this.selected.getName() : Slot.MAIN_HAND.name);
        return nbt;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void createGuiControls(GuiPanel panel, LittlePreviews previews) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        GuiFakeSlot stack = new GuiFakeSlot("stack", 0, 20, 18, 18);
        panel.addControl((GuiControl)stack);
        if (!this.stack.func_190926_b()) {
            stack.updateItemStack(this.stack);
        }
        panel.addControl((GuiControl)new GuiStackSelectorAll("preview", 0, 0, 110, (EntityPlayer)player, (GuiStackSelectorAll.StackCollector)new GuiStackSelectorAll.InventoryCollector((GuiStackSelectorAll.StackSelector)new LittleItemSelector()), true));
        panel.addControl((GuiControl)new GuiButton("use", "Use Item", 25, 22){

            public void onClicked(int x, int y, int button) {
                GuiStackSelectorAll preview = (GuiStackSelectorAll)this.parent.get("preview");
                GuiFakeSlot key = (GuiFakeSlot)this.parent.get("stack");
                ItemStack temp = preview.getSelected().func_77946_l();
                temp.func_190920_e(LittleTriggerEventModifyInventory.this.stackCount);
                key.updateItemStack(temp);
            }
        });
        panel.addControl((GuiControl)new GuiLabel("Stack Count:", 0, 45));
        GuiTextfield count = new GuiTextfield("count", this.stackCount + "", 66, 45, 25, 10).setNumbersOnly();
        count.maxLength = 2;
        panel.addControl((GuiControl)count);
        GuiConnectedCheckBoxes addRemove = new GuiConnectedCheckBoxes("addRemove", 0, 65).addCheckBox("add", "Add Item").addCheckBox("remove", "Remove Item");
        if (this.addItem) {
            addRemove.setSelected("add");
        } else {
            addRemove.setSelected("remove");
        }
        panel.addControl((GuiControl)addRemove);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void guiChangedEvent(CoreControl source) {
        if (source instanceof GuiFakeSlot) {
            GuiFakeSlot key = (GuiFakeSlot)source;
            this.stack = key.basic.func_70301_a(0).func_77946_l();
        } else if (source instanceof GuiConnectedCheckBoxes) {
            GuiConnectedCheckBoxes boxes = (GuiConnectedCheckBoxes)source;
            if (source.is(new String[]{"addRemove"})) {
                this.addItem = boxes.getSelected().name.equals("add");
            }
        } else if (!source.is(new String[]{"selectedSlot"})) {
            if (source.is(new String[]{"count"})) {
                GuiTextfield count = (GuiTextfield)source;
                int c = Integer.parseInt(count.text);
                if (c == 0) {
                    c = 1;
                    count.text = "1";
                } else if (c > 64) {
                    c = 64;
                    count.text = "64";
                }
                this.stackCount = c;
                if (!this.stack.func_190926_b()) {
                    this.stack.func_190920_e(this.stackCount);
                }
            }
        }
    }

    @Override
    public boolean runEvent() {
        for (Entity entity : this.getEntities()) {
            if (!(entity instanceof EntityPlayer)) continue;
            EntityPlayer player = (EntityPlayer)entity;
            if (this.stack.func_190926_b()) continue;
            LittleIngredients ingredients = new LittleIngredients(new LittleIngredient[]{new StackIngredient(new ItemStack[]{this.stack})});
            try {
                if (!this.addItem) {
                    LittleAction.checkAndTake((EntityPlayer)player, (LittleInventory)new LittleInventory(player, this.selected.getSlotHandler(player, this.slotID)), (LittleIngredients)ingredients);
                    return true;
                }
                LittleAction.checkAndGive((EntityPlayer)player, (LittleInventory)new LittleInventory(player, this.selected.getSlotHandler(player, this.slotID)), (LittleIngredients)ingredients);
                return true;
            }
            catch (NotEnoughIngredientsException e) {
                return false;
            }
        }
        return false;
    }

    public static enum Slot {
        MAIN_HAND("main_hand"),
        OFF_HAND("off_hand"),
        HELM("helm"),
        CHEST("chest"),
        LEGS("legs"),
        BOOTS("boots"),
        SPECIFIC("specific"),
        ANY("any");

        private String name;

        private Slot(String name) {
            this.name = name;
        }

        public static Slot getSlotFrom(NBTTagCompound nbt) {
            String name = nbt.func_74779_i("selected");
            for (Slot s : Slot.values()) {
                if (!s.name.equals(name)) continue;
                return s;
            }
            return MAIN_HAND;
        }

        public String getName() {
            return this.name;
        }

        public IItemHandler getSlotHandler(EntityPlayer player, @Nullable Integer specificID) {
            InventoryPlayer inv = player.field_71071_by;
            switch (this) {
                case MAIN_HAND: {
                    System.out.println(inv.field_70461_c);
                    return new RangedWrapper((IItemHandlerModifiable)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), inv.field_70461_c, inv.field_70461_c + 1);
                }
                case OFF_HAND: {
                    return new RangedWrapper((IItemHandlerModifiable)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), 40, 41);
                }
                case HELM: {
                    return new RangedWrapper((IItemHandlerModifiable)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), 39, 40);
                }
                case CHEST: {
                    return new RangedWrapper((IItemHandlerModifiable)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), 38, 39);
                }
                case LEGS: {
                    return new RangedWrapper((IItemHandlerModifiable)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), 37, 38);
                }
                case BOOTS: {
                    return new RangedWrapper((IItemHandlerModifiable)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), 36, 37);
                }
                case SPECIFIC: {
                    return specificID != null ? new RangedWrapper((IItemHandlerModifiable)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), specificID.intValue(), specificID + 1) : null;
                }
                case ANY: {
                    return (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                }
            }
            return null;
        }
    }
}

