/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.structure.type.programable.basic.events;

import com.alet.common.structure.type.programable.basic.events.LittleTriggerEvent;
import com.creativemd.creativecore.common.gui.CoreControl;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiAnalogeSlider;
import com.creativemd.creativecore.common.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiPanel;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleTriggerEventModifyHealth
extends LittleTriggerEvent {
    public float damageAmount = 0.0f;
    public float healAmount = 0.0f;
    public String damageType = "";
    public boolean heal = false;
    public boolean harm = false;
    public static List<DamageSource> sourceOfDmg = new ArrayList<DamageSource>();

    public LittleTriggerEventModifyHealth(int id) {
        super(id);
    }

    @Override
    public NBTTagCompound serializeNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("heal", this.heal);
        nbt.func_74757_a("harm", this.harm);
        nbt.func_74776_a("damageAmount", this.damageAmount);
        nbt.func_74778_a("damageType", this.damageType);
        nbt.func_74776_a("healAmount", this.healAmount);
        return nbt;
    }

    @Override
    public LittleTriggerEvent deserializeNBT(NBTTagCompound nbt) {
        this.heal = nbt.func_74767_n("heal");
        this.harm = nbt.func_74767_n("harm");
        this.damageAmount = nbt.func_74760_g("damageAmount");
        this.damageType = nbt.func_74779_i("damageType");
        this.healAmount = nbt.func_74760_g("healAmount");
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void createGuiControls(GuiPanel panel, LittlePreviews previews) {
        ArrayList<String> sourceList = new ArrayList<String>();
        for (DamageSource forEachSource : sourceOfDmg) {
            sourceList.add(forEachSource.field_76373_n);
        }
        LittleTriggerEventModifyHealth.wipeControls((GuiParent)panel);
        panel.addControl((GuiControl)new GuiLabel("Modify Health", 0, 0));
        panel.addControl((GuiControl)new GuiLabel("For Every Tick:", 0, 18));
        panel.addControl((GuiControl)new GuiCheckBox("harm", "Harm Entity", 0, 38, this.harm));
        panel.addControl((GuiControl)new GuiLabel("Damage Type:", 0, 58));
        panel.addControl((GuiControl)new GuiLabel("Total Damage:", 0, 81));
        GuiComboBox damageSource = new GuiComboBox("sources", 73, 55, 80, sourceList);
        damageSource.select(this.damageType);
        panel.addControl((GuiControl)damageSource);
        panel.addControl((GuiControl)new GuiAnalogeSlider("dmgAmount", 73, 78, 56, 14, (double)this.damageAmount, 0.0, 20.0));
        panel.addControl((GuiControl)new GuiCheckBox("heal", "Heal Entity", 0, 110, this.heal));
        panel.addControl((GuiControl)new GuiLabel("Total Heal:", 0, 130));
        panel.addControl((GuiControl)new GuiAnalogeSlider("healAmount", 60, 127, 56, 14, (double)this.healAmount, 0.0, 20.0));
        panel.get("sources").setEnabled(this.harm);
        panel.get("dmgAmount").setEnabled(this.harm);
        panel.get("healAmount").setEnabled(this.heal);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void guiChangedEvent(CoreControl source) {
        if (source instanceof GuiAnalogeSlider) {
            GuiAnalogeSlider slider = (GuiAnalogeSlider)source;
            if (slider.name.equals("dmgAmount")) {
                this.damageAmount = (float)slider.value;
            } else if (slider.name.equals("healAmount")) {
                this.healAmount = (float)slider.value;
            }
        } else if (source instanceof GuiComboBox) {
            GuiComboBox combo = (GuiComboBox)source;
            if (combo.name.equals("sources")) {
                this.damageType = combo.getCaption();
            }
        } else if (source instanceof GuiCheckBox) {
            GuiCheckBox check = (GuiCheckBox)source;
            GuiPanel panel = (GuiPanel)check.getGui().get("content");
            if (check.name.equals("harm")) {
                this.harm = check.value;
            } else if (check.name.equals("heal")) {
                this.heal = check.value;
            }
            panel.get("sources").setEnabled(this.harm);
            panel.get("dmgAmount").setEnabled(this.harm);
            panel.get("healAmount").setEnabled(this.heal);
        }
    }

    @Override
    public boolean runEvent() {
        if (this.harm) {
            DamageSource damageSource = DamageSource.field_76377_j;
            for (DamageSource source : sourceOfDmg) {
                if (!this.damageType.equals(source.func_76355_l())) continue;
                damageSource = source;
                break;
            }
            for (Entity entity : this.getEntities()) {
                entity.func_70097_a(damageSource, this.damageAmount);
            }
        }
        if (this.heal) {
            for (Entity entity : this.getEntities()) {
                if (!(entity instanceof EntityLivingBase)) continue;
                EntityLivingBase living = (EntityLivingBase)entity;
                living.func_70691_i(this.healAmount);
            }
        }
        return true;
    }

    static {
        if (sourceOfDmg.isEmpty()) {
            sourceOfDmg.add(DamageSource.field_82728_o);
            sourceOfDmg.add(DamageSource.field_76367_g);
            sourceOfDmg.add(DamageSource.field_191291_g);
            sourceOfDmg.add(DamageSource.field_188407_q);
            sourceOfDmg.add(DamageSource.field_76369_e);
            sourceOfDmg.add(DamageSource.field_76379_h);
            sourceOfDmg.add(DamageSource.field_82729_p);
            sourceOfDmg.add(DamageSource.field_191552_t);
            sourceOfDmg.add(DamageSource.field_188406_j);
            sourceOfDmg.add(DamageSource.field_76377_j);
            sourceOfDmg.add(DamageSource.field_190095_e);
            sourceOfDmg.add(DamageSource.field_76372_a);
            sourceOfDmg.add(DamageSource.field_76368_d);
            sourceOfDmg.add(DamageSource.field_76371_c);
            sourceOfDmg.add(DamageSource.field_180137_b);
            sourceOfDmg.add(DamageSource.field_76376_m);
            sourceOfDmg.add(DamageSource.field_76370_b);
            sourceOfDmg.add(DamageSource.field_76380_i);
            sourceOfDmg.add(DamageSource.field_76366_f);
            sourceOfDmg.add(DamageSource.field_82727_n);
        }
    }
}

