/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.structure.type.programable.basic.conditions;

import com.alet.common.structure.type.programable.basic.LittleTriggerObject;
import com.alet.common.structure.type.programable.basic.conditions.LittleTriggerCondition;
import com.creativemd.creativecore.common.gui.CoreControl;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiPanel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleTriggerConditionTickDelay
extends LittleTriggerCondition {
    public int effectPerTick = 0;

    public LittleTriggerConditionTickDelay(int id) {
        super(id);
        this.shouldLoop = true;
    }

    @Override
    public boolean conditionPassed() {
        if (this.effectPerTick - 1 <= this.structure.tick) {
            this.structure.tick = 0;
            return true;
        }
        ++this.structure.tick;
        return false;
    }

    @Override
    public LittleTriggerObject deserializeNBT(NBTTagCompound nbt) {
        this.effectPerTick = nbt.func_74762_e("effectPerTick");
        return this;
    }

    @Override
    public NBTTagCompound serializeNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("effectPerTick", this.effectPerTick);
        return nbt;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void guiChangedEvent(CoreControl source) {
        if (source instanceof GuiTextfield) {
            this.effectPerTick = Integer.parseInt(((GuiTextfield)source).text);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void createGuiControls(GuiPanel panel, LittlePreviews previews) {
        panel.addControl((GuiControl)new GuiLabel("Tick Delay:", 0, 3));
        panel.addControl((GuiControl)new GuiTextfield("preTick", this.effectPerTick + "", 60, 0, 40, 14).setNumbersOnly());
    }
}

