/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.structure.type.programable.basic.conditions;

import com.alet.client.gui.controls.GuiConnectedCheckBoxes;
import com.alet.client.gui.controls.GuiWrappedTextField;
import com.alet.common.command.sender.EntityCommandSender;
import com.alet.common.command.sender.StructureCommandSender;
import com.alet.common.structure.type.programable.basic.conditions.LittleTriggerCondition;
import com.creativemd.creativecore.common.gui.CoreControl;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiPanel;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleTriggerConditionSuccessfulCommand
extends LittleTriggerCondition {
    String command = "";
    boolean isSenderPlayer = false;

    public LittleTriggerConditionSuccessfulCommand(int id) {
        super(id);
    }

    @Override
    public boolean conditionPassed() {
        for (Entity entity : this.getEntities()) {
            int i;
            Object sender = new StructureCommandSender(entity, this.structure);
            if (this.isSenderPlayer) {
                sender = new EntityCommandSender(entity);
            }
            if ((i = entity.field_70170_p.func_73046_m().func_71187_D().func_71556_a((ICommandSender)sender, this.command)) != 1) continue;
            return true;
        }
        return false;
    }

    @Override
    public NBTTagCompound serializeNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("command", this.command);
        nbt.func_74757_a("isSenderPlayer", this.isSenderPlayer);
        return nbt;
    }

    @Override
    public LittleTriggerCondition deserializeNBT(NBTTagCompound nbt) {
        this.command = nbt.func_74779_i("command");
        this.isSenderPlayer = nbt.func_74767_n("isSenderPlayer");
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void createGuiControls(GuiPanel panel, LittlePreviews previews) {
        panel.addControl((GuiControl)new GuiLabel("Command", 0, 37));
        panel.addControl((GuiControl)new GuiWrappedTextField("command", this.command, 0, 50, 153, 123));
        GuiConnectedCheckBoxes option = new GuiConnectedCheckBoxes("", 0, 0);
        option.addCheckBox("entityIsSender", "Entity is Sender");
        option.addCheckBox("structureIsSender", "Structure is Sender");
        option.setSelected(this.isSenderPlayer ? "entityIsSender" : "structureIsSender");
        panel.addControl((GuiControl)option);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void guiChangedEvent(CoreControl source) {
        if (source instanceof GuiWrappedTextField) {
            GuiWrappedTextField text = (GuiWrappedTextField)source;
            this.command = text.text;
        } else if (source instanceof GuiConnectedCheckBoxes) {
            GuiConnectedCheckBoxes checkBox = (GuiConnectedCheckBoxes)source;
            String selected = checkBox.getSelected().name;
            if (selected.equals("structureIsSender")) {
                this.isSenderPlayer = false;
            } else if (selected.equals("entityIsSender")) {
                this.isSenderPlayer = true;
            }
        }
    }
}

