/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.structure.type.programable.basic.conditions;

import com.alet.common.packet.PacketGetServerScoreboard;
import com.alet.common.structure.type.programable.basic.conditions.LittleTriggerCondition;
import com.creativemd.creativecore.common.gui.CoreControl;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiPanel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiScrollBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleTriggerConditionScoreboard
extends LittleTriggerCondition {
    public int value = 0;
    public String scoreName = "";
    public int operation = 0;
    private WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0);

    public LittleTriggerConditionScoreboard(int id) {
        super(id);
    }

    @Override
    public boolean conditionPassed() {
        for (Entity entity : this.getEntities()) {
            Scoreboard scoreBoard = this.world.func_96441_U();
            for (Score sc : scoreBoard.func_96528_e()) {
                if (!sc.func_96645_d().func_96679_b().equals(this.scoreName)) continue;
                switch (this.operation) {
                    case 0: {
                        if (sc.func_96652_c() != this.value) break;
                        return true;
                    }
                    case 1: {
                        if (sc.func_96652_c() >= this.value) break;
                        return true;
                    }
                    case 2: {
                        if (sc.func_96652_c() <= this.value) break;
                        return true;
                    }
                    case 3: {
                        if (sc.func_96652_c() > this.value) break;
                        return true;
                    }
                    case 4: {
                        if (sc.func_96652_c() < this.value) break;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public NBTTagCompound serializeNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("value", this.value);
        nbt.func_74768_a("operation", this.operation);
        nbt.func_74778_a("scoreName", this.scoreName);
        return nbt;
    }

    @Override
    public LittleTriggerCondition deserializeNBT(NBTTagCompound nbt) {
        this.value = nbt.func_74762_e("value");
        this.operation = nbt.func_74762_e("operation");
        this.scoreName = nbt.func_74779_i("scoreName");
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void createGuiControls(GuiPanel panel, LittlePreviews previews) {
        PacketHandler.sendPacketToServer((CreativeCorePacket)new PacketGetServerScoreboard());
        panel.getGui().getPlayer();
        Scoreboard score = this.world.func_96441_U();
        Collection objectives = score.func_96514_c();
        ArrayList<String> list = new ArrayList<String>();
        for (ScoreObjective obj : objectives) {
            list.add(obj.func_96679_b());
        }
        panel.addControl((GuiControl)new GuiLabel("Type:", 0, 100));
        panel.addControl((GuiControl)new GuiLabel("type", "", 30, 100));
        panel.addControl((GuiControl)new GuiLabel("If Value is", 0, 118));
        panel.addControl((GuiControl)new GuiTextfield("value", this.value + "", 86, 118, 30, 10).setNumbersIncludingNegativeOnly());
        panel.addControl((GuiControl)new GuiScrollBox("bx", 0, 40, 152, 50));
        GuiComboBox cBox = new GuiComboBox("ls", 0, 20, 152, list);
        cBox.setCaption(this.scoreName);
        cBox.width = 158;
        panel.addControl((GuiControl)cBox);
        this.fillComboBox(cBox);
        panel.addControl((GuiControl)new GuiLabel("Is Scoreboard", 0, 0));
        ArrayList<String> operations = new ArrayList<String>();
        operations.add("=");
        operations.add("<");
        operations.add(">");
        operations.add(">=");
        operations.add("<=");
        GuiComboBox op = new GuiComboBox("operation", 58, 116, 20, operations){

            public void setCaption(String caption) {
                this.caption = caption;
            }
        };
        String cap = "";
        switch (this.operation) {
            case 0: {
                cap = "=";
                break;
            }
            case 1: {
                cap = "<";
                break;
            }
            case 2: {
                cap = ">";
                break;
            }
            case 3: {
                cap = "<=";
                break;
            }
            case 4: {
                cap = ">=";
                break;
            }
        }
        op.setCaption(cap);
        panel.addControl((GuiControl)op);
    }

    @SideOnly(value=Side.CLIENT)
    public void fillComboBox(GuiComboBox cBox) {
        GuiPanel panel = (GuiPanel)cBox.getGui().get("panel");
        GuiScrollBox sBox = (GuiScrollBox)panel.get("bx");
        Scoreboard score = this.world.func_96441_U();
        GuiLabel label = null;
        LittleTriggerConditionScoreboard.wipeControls((GuiParent)sBox);
        int i = 0;
        String caption = cBox.getCaption();
        for (Score sc : score.func_96528_e()) {
            String s = sc.func_96653_e().replaceAll("-", "");
            if (!sc.func_96645_d().func_96679_b().equals(caption)) continue;
            if (s.length() == 32) {
                long least;
                String m = s.substring(0, 16);
                String l = s.substring(16, 32);
                long most = new BigInteger(m, 16).longValue();
                UUID uuid = new UUID(most, least = new BigInteger(l, 16).longValue());
                Entity entity = this.world.func_175733_a(uuid);
                if (entity.func_95999_t() != null && !entity.func_95999_t().equals("")) {
                    label = this.shortenName(entity.func_95999_t(), i);
                    label.setCustomTooltip(new String[]{sc.func_96653_e()});
                } else {
                    label = this.shortenName(sc.func_96653_e(), i);
                }
            } else {
                label = this.shortenName(sc.func_96653_e(), i);
            }
            GuiLabel value = new GuiLabel("" + sc.func_96652_c(), 100, i * 15);
            GuiLabel type = (GuiLabel)panel.get("type");
            type.setCaption(sc.func_96645_d().func_96680_c().func_96636_a());
            sBox.addControl((GuiControl)label);
            sBox.addControl((GuiControl)value);
            ++i;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void guiChangedEvent(CoreControl source) {
        if (source instanceof GuiComboBox) {
            GuiComboBox cBox = (GuiComboBox)source;
            if (cBox.is(new String[]{"ls"})) {
                this.fillComboBox(cBox);
                this.scoreName = cBox.getCaption();
            } else if (cBox.is(new String[]{"operation"})) {
                switch (cBox.getCaption()) {
                    case "=": {
                        this.operation = 0;
                        break;
                    }
                    case "<": {
                        this.operation = 1;
                        break;
                    }
                    case ">": {
                        this.operation = 2;
                        break;
                    }
                    case "<=": {
                        this.operation = 3;
                        break;
                    }
                    case ">=": {
                        this.operation = 4;
                        break;
                    }
                }
            }
        }
        if (source instanceof GuiTextfield) {
            GuiTextfield tField = (GuiTextfield)source;
            if (tField.name.equals("value")) {
                this.value = Integer.parseInt(tField.text);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public GuiLabel shortenName(String name, int y) {
        GuiLabel label = new GuiLabel(name, 0, y * 15);
        String fullName = new String(name);
        if (name.length() > 10) {
            name = name.substring(0, 10);
            label.setCaption(name + "...");
            label.setCustomTooltip(new String[]{fullName});
        }
        return label;
    }
}

