/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.structure.type.programable.basic.conditions;

import com.alet.common.structure.type.programable.basic.LittleTriggerObject;
import com.alet.common.structure.type.programable.basic.conditions.LittleTriggerCondition;
import com.alet.common.utils.ComponentSearch;
import com.creativemd.creativecore.common.gui.CoreControl;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiPanel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.gui.event.ControlEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.utils.math.BooleanUtils;
import com.creativemd.littletiles.client.gui.signal.SubGuiDialogSignal;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.signal.component.ISignalComponent;
import com.creativemd.littletiles.common.structure.signal.logic.SignalPatternParser;
import com.creativemd.littletiles.common.structure.signal.logic.SignalTarget;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleTriggerConditionIsSignal
extends LittleTriggerCondition {
    public String name = "";
    public int value = 0;

    public LittleTriggerConditionIsSignal(int id) {
        super(id);
    }

    @Override
    public boolean conditionPassed() {
        try {
            SignalTarget target = SignalTarget.parseTarget((SignalPatternParser)new SignalPatternParser(this.name), (boolean)false, (boolean)false);
            ISignalComponent componet = target.getTarget((LittleStructure)this.structure);
            if (componet != null) {
                try {
                    boolean[] arr = new boolean[componet.getBandwidth()];
                    BooleanUtils.intToBool((int)this.value, (boolean[])arr);
                    return BooleanUtils.equals((boolean[])componet.getState(), (boolean[])arr);
                }
                catch (CorruptedConnectionException | NotYetConnectedException e) {
                    return false;
                }
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public LittleTriggerObject deserializeNBT(NBTTagCompound nbt) {
        this.name = nbt.func_74779_i("name");
        this.value = nbt.func_74762_e("value");
        return this;
    }

    @Override
    public NBTTagCompound serializeNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("name", this.name);
        nbt.func_74768_a("value", this.value);
        return nbt;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void createGuiControls(GuiPanel panel, LittlePreviews previews) {
        List<SubGuiDialogSignal.GuiSignalComponent> GuiSignalComponent2 = new ComponentSearch(previews, previews.getStructureType()).search(true, true, true);
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> title = new ArrayList<String>();
        int index = 0;
        int i = 0;
        for (SubGuiDialogSignal.GuiSignalComponent o : GuiSignalComponent2) {
            if (o.totalName.equals("allow") || o.totalName.equals("completed") || o.totalName.equals("activate")) continue;
            if (o.totalName.equals(this.name)) {
                index = i;
            }
            title.add(o.display());
            list.add(o.name);
            ++i;
        }
        panel.addControl((GuiControl)new GuiLabel("Is Signal Equal", 0, 0));
        panel.addControl((GuiControl)new GuiLabel("Signal Connections", 0, 20));
        GuiTitledComboBox box = new GuiTitledComboBox("outList", 0, 33, 153, title, list);
        if (!list.isEmpty()) {
            box.select(index);
            panel.raiseEvent((ControlEvent)new GuiControlChangedEvent((GuiControl)box));
        }
        panel.addControl((GuiControl)box);
        panel.addControl((GuiControl)new GuiLabel("If Signal is equal to", 0, 57));
        GuiTextfield valueText = new GuiTextfield("value", this.value + "", 0, 70, 153, 14).setNumbersOnly();
        valueText.setCustomTooltip(new String[]{"Enter value as a decimal"});
        panel.addControl((GuiControl)valueText);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void guiChangedEvent(CoreControl source) {
        if (source.is(new String[]{"outList"})) {
            GuiTitledComboBox combo = (GuiTitledComboBox)source;
            this.name = combo.getSelected();
        } else if (source.is(new String[]{"value"})) {
            GuiTextfield valueText = (GuiTextfield)source;
            if (!valueText.text.equals("")) {
                this.value = Integer.parseInt(valueText.text);
            }
        }
    }

    protected class GuiTitledComboBox
    extends GuiComboBox {
        List<String> titles;

        public GuiTitledComboBox(String name, int x, int y, int width, List<String> titles, List<String> lines) {
            super(name, x, y, width, titles);
            this.titles = new ArrayList<String>();
            this.titles = lines;
        }

        public String getSelected() {
            return this.titles.get(this.index);
        }
    }
}

