/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.structure.type.programable.basic.conditions;

import com.alet.client.gui.controls.GuiConnectedCheckBoxes;
import com.alet.common.structure.type.programable.basic.LittleTriggerObject;
import com.alet.common.structure.type.programable.basic.conditions.LittleTriggerCondition;
import com.creativemd.creativecore.common.gui.CoreControl;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.controls.gui.GuiPanel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.gui.controls.gui.custom.GuiItemComboBox;
import com.creativemd.creativecore.common.gui.event.ControlEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.gui.SubGuiRecipe;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.type.door.LittleDoorBase;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleTriggerConditionDoorTick
extends LittleTriggerCondition {
    int tick = 0;
    int childID = 0;
    boolean onClose = false;

    public LittleTriggerConditionDoorTick(int id) {
        super(id);
    }

    @Override
    public boolean conditionPassed() {
        block6: {
            try {
                LittleStructure struct = this.structure.getChild(this.childID).getStructure();
                if (struct instanceof LittleDoorBase) {
                    boolean flag;
                    LittleDoorBase door = (LittleDoorBase)struct;
                    if (door.animation == null) {
                        return false;
                    }
                    String s0 = door.animation.controller.toString();
                    String[] s1 = s0.split(">");
                    int i = -1;
                    if (s1.length > 1) {
                        i = Integer.parseInt(s1[1].replace("-", ""));
                    }
                    boolean bl = flag = this.onClose ? door.animation.controller.getCurrentState().name.equals("opened") : door.animation.controller.getCurrentState().name.equals("closed");
                    if (i == this.tick && flag) {
                        return true;
                    }
                    break block6;
                }
                return false;
            }
            catch (CorruptedConnectionException | NotYetConnectedException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public LittleTriggerObject deserializeNBT(NBTTagCompound nbt) {
        this.tick = nbt.func_74762_e("door_tick");
        this.childID = nbt.func_74762_e("child_id");
        this.onClose = nbt.func_74767_n("on_close");
        return this;
    }

    @Override
    public NBTTagCompound serializeNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("door_tick", this.tick);
        nbt.func_74768_a("child_id", this.childID);
        nbt.func_74757_a("on_close", this.onClose);
        return nbt;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void createGuiControls(GuiPanel panel, LittlePreviews previews) {
        ArrayList<SubGuiRecipe.StructureHolder> doorHierarchy = new ArrayList<SubGuiRecipe.StructureHolder>();
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ArrayList<String> doorNames = new ArrayList<String>();
        ArrayList<Integer> childIDs = new ArrayList<Integer>();
        LittleTriggerConditionDoorTick.addPreviews(this.findParent(previews), doorHierarchy, stacks, doorNames, childIDs, "", null, -1, 0);
        GuiDoorComboBox combo = new GuiDoorComboBox("doorList", 0, 5, 200, doorNames, stacks, childIDs);
        int select = 0;
        for (int i = 0; i < doorHierarchy.size(); ++i) {
            if (((SubGuiRecipe.StructureHolder)doorHierarchy.get((int)i)).index != this.childID) continue;
            select = i;
            break;
        }
        combo.select(select);
        panel.raiseEvent((ControlEvent)new GuiControlChangedEvent((GuiControl)combo));
        panel.addControl((GuiControl)combo);
        panel.addControl((GuiControl)new GuiTextfield("door_tick", this.tick + "", 0, 30, 50, 10).setNumbersOnly());
        GuiConnectedCheckBoxes doorState = new GuiConnectedCheckBoxes("door_state", 0, 50).addCheckBox("on_open", "On Opening").addCheckBox("on_close", "On Closing");
        panel.addControl((GuiControl)doorState);
        if (!this.onClose) {
            doorState.setSelected("on_open");
        } else {
            doorState.setSelected("on_close");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public LittlePreviews findParent(LittlePreviews previews) {
        LittlePreviews parentPreview = previews.getParent();
        if (parentPreview == null) {
            return previews;
        }
        this.findParent(parentPreview);
        return parentPreview;
    }

    @SideOnly(value=Side.CLIENT)
    protected static void addPreviews(LittlePreviews previews, List<SubGuiRecipe.StructureHolder> hierarchy, List<ItemStack> stacks, List<String> lines, List<Integer> childIDs, String prefix, SubGuiRecipe.StructureHolder parent, int childId, int index) {
        SubGuiRecipe.StructureHolder holder = new SubGuiRecipe.StructureHolder(parent, childId, hierarchy.size());
        holder.previews = previews;
        holder.prefix = prefix;
        ItemStack stack = new ItemStack(LittleTiles.multiTiles);
        LittlePreviews newPreviews = new LittlePreviews(previews.getContext());
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        for (LittlePreview preview : previews) {
            newPreviews.addWithoutCheckingPreview(preview.copy());
            minX = Math.min(minX, preview.box.minX);
            minY = Math.min(minY, preview.box.minY);
            minZ = Math.min(minZ, preview.box.minZ);
            minX = Math.min(minX, preview.box.maxX);
            minY = Math.min(minY, preview.box.maxY);
            minZ = Math.min(minZ, preview.box.maxZ);
        }
        for (LittlePreview preview : newPreviews) {
            preview.box.sub(minX, minY, minZ);
        }
        LittlePreview.savePreview((LittlePreviews)newPreviews, (ItemStack)stack);
        holder.explicit = stack;
        if (previews.getStructureType() instanceof LittleDoorBase.LittleDoorBaseType) {
            stacks.add(stack);
            hierarchy.add(holder);
            lines.add(index + " " + holder.getDisplayName());
            childIDs.add(childId);
        }
        ++index;
        if (previews.hasChildren()) {
            int i = 0;
            for (LittlePreviews child : previews.getChildren()) {
                LittleTriggerConditionDoorTick.addPreviews(child, hierarchy, stacks, lines, childIDs, prefix + "-", holder, i, index);
                ++i;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public String getDisplayName(LittlePreviews previews, int childId) {
        String name = previews.getStructureName();
        if (name == null) {
            name = previews.hasStructure() ? previews.getStructureId() : "none";
        }
        return childId + " " + name;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void guiChangedEvent(CoreControl source) {
        if (source instanceof GuiTextfield) {
            GuiTextfield text = (GuiTextfield)source;
            if (!text.text.equals("")) {
                this.tick = text.parseInteger();
            }
        }
        if (source.is(new String[]{"doorList"})) {
            GuiDoorComboBox combo = (GuiDoorComboBox)source;
            if (!combo.lines.isEmpty()) {
                this.childID = combo.childIDs.get(combo.index);
            }
        }
        if (source.is(new String[]{"door_state"})) {
            GuiConnectedCheckBoxes doorState = (GuiConnectedCheckBoxes)source;
            this.onClose = doorState.getSelected().name.equals("on_close");
        }
    }

    protected class GuiDoorComboBox
    extends GuiItemComboBox {
        List<Integer> childIDs;

        public GuiDoorComboBox(String name, int x, int y, int width, List<String> lines, List<ItemStack> stacks, List<Integer> childIDs) {
            super(name, x, y, width, lines, stacks);
            this.childIDs = childIDs;
        }
    }
}

