/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.structure.type.programable.basic.activator;

import com.alet.common.structure.type.programable.basic.LittleTriggerObject;
import com.alet.common.structure.type.programable.basic.activator.LittleTriggerActivator;
import com.alet.common.utils.NBTUtils;
import com.creativemd.creativecore.common.gui.CoreControl;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiPanel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleTriggerActivatorCollisionArea
extends LittleTriggerActivator {
    private boolean runWhileCollided = false;
    private double x_min = 0.0;
    private double y_min = 0.0;
    private double z_min = 0.0;
    private double x_max = 0.0;
    private double y_max = 0.0;
    private double z_max = 0.0;
    private AxisAlignedBB collisionArea = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    @Override
    public LittleTriggerObject deserializeNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("collisionArea")) {
            NBTTagCompound n = (NBTTagCompound)nbt.func_74781_a("collisionArea");
            this.collisionArea = NBTUtils.readAABB(n);
            this.x_min = this.collisionArea.field_72340_a;
            this.y_min = this.collisionArea.field_72338_b;
            this.z_min = this.collisionArea.field_72339_c;
            this.x_max = this.collisionArea.field_72336_d;
            this.y_max = this.collisionArea.field_72337_e;
            this.z_max = this.collisionArea.field_72334_f;
        }
        return this;
    }

    @Override
    public NBTTagCompound serializeNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("collisionArea", (NBTBase)NBTUtils.writeAABB(this.collisionArea));
        return nbt;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void createGuiControls(GuiPanel panel, LittlePreviews previews) {
        panel.addControl((GuiControl)new GuiCheckBox("while_collided", "Run Only While Collided", 0, 0, this.runWhileCollided));
        panel.addControl((GuiControl)new GuiLabel("X1:", 0, 14));
        panel.addControl((GuiControl)new GuiLabel("X2:", 0, 29));
        panel.addControl((GuiControl)new GuiLabel("Y1:", 52, 14));
        panel.addControl((GuiControl)new GuiLabel("Y2:", 52, 29));
        panel.addControl((GuiControl)new GuiLabel("Z1:", 104, 14));
        panel.addControl((GuiControl)new GuiLabel("Z2:", 104, 29));
        panel.addControl((GuiControl)new GuiTextfield("x_min", this.collisionArea != null ? this.collisionArea.field_72340_a + "" : "", 18, 14, 30, 8).setFloatOnly());
        panel.addControl((GuiControl)new GuiTextfield("x_max", this.collisionArea != null ? this.collisionArea.field_72336_d + "" : "", 18, 29, 30, 8).setFloatOnly());
        panel.addControl((GuiControl)new GuiTextfield("y_min", this.collisionArea != null ? this.collisionArea.field_72338_b + "" : "", 70, 14, 30, 8).setFloatOnly());
        panel.addControl((GuiControl)new GuiTextfield("y_max", this.collisionArea != null ? this.collisionArea.field_72337_e + "" : "", 70, 29, 30, 8).setFloatOnly());
        panel.addControl((GuiControl)new GuiTextfield("z_min", this.collisionArea != null ? this.collisionArea.field_72339_c + "" : "", 122, 14, 30, 8).setFloatOnly());
        panel.addControl((GuiControl)new GuiTextfield("z_max", this.collisionArea != null ? this.collisionArea.field_72334_f + "" : "", 122, 29, 30, 8).setFloatOnly());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void guiChangedEvent(CoreControl source) {
        if (source.is(new String[]{"x_min", "x_max", "y_min", "y_max", "z_min", "z_max"})) {
            GuiTextfield text = (GuiTextfield)source;
            System.out.println(this.collisionArea);
            double value = Double.parseDouble(text.text);
            if (text.is(new String[]{"x_min"})) {
                this.x_min = value;
            } else if (text.is(new String[]{"x_max"})) {
                this.x_max = value;
            } else if (text.is(new String[]{"y_min"})) {
                this.y_min = value;
            } else if (text.is(new String[]{"y_max"})) {
                this.y_max = value;
            } else if (text.is(new String[]{"z_min"})) {
                this.z_min = value;
            } else if (text.is(new String[]{"z_max"})) {
                this.z_max = value;
            }
            this.collisionArea = new AxisAlignedBB(this.x_min, this.y_min, this.z_min, this.x_max, this.y_max, this.z_max);
        }
    }

    @Override
    public boolean shouldRun(World world, HashSet<Entity> entities) {
        if (!world.field_72996_f.isEmpty()) {
            entities.clear();
            entities.addAll(world.func_72872_a(Entity.class, this.collisionArea));
            if (!entities.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void loopRules(HashSet<Entity> entities, boolean shouldContinue, boolean flag) {
    }

    @Override
    public void onCollision(World worldIn, Entity entityIn) {
    }

    @Override
    public void onCollision(World worldIn, Collection<Entity> entities) {
    }

    @Override
    public void onRightClick(World worldIn, LittleTile tile, BlockPos pos, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) {
    }
}

