/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.structure.type.programable.basic;

import com.alet.common.structure.type.programable.basic.LittleTriggerObject;
import com.alet.common.structure.type.programable.basic.activator.LittleTriggerActivator;
import com.alet.common.structure.type.programable.basic.activator.LittleTriggerActivatorCollisionArea;
import com.alet.common.structure.type.programable.basic.activator.LittleTriggerActivatorCollisionTiles;
import com.alet.common.structure.type.programable.basic.activator.LittleTriggerActivatorGlobal;
import com.alet.common.structure.type.programable.basic.activator.LittleTriggerActivatorRightClick;
import com.alet.common.structure.type.programable.basic.activator.LittleTriggerActivatorTargetSelector;
import com.alet.common.structure.type.programable.basic.conditions.LittleTriggerConditionDoorTick;
import com.alet.common.structure.type.programable.basic.conditions.LittleTriggerConditionHasItem;
import com.alet.common.structure.type.programable.basic.conditions.LittleTriggerConditionIsEntity;
import com.alet.common.structure.type.programable.basic.conditions.LittleTriggerConditionIsSignal;
import com.alet.common.structure.type.programable.basic.conditions.LittleTriggerConditionSuccessfulCommand;
import com.alet.common.structure.type.programable.basic.conditions.LittleTriggerConditionTickDelay;
import com.alet.common.structure.type.programable.basic.events.LittleTriggerEventExecuteCommand;
import com.alet.common.structure.type.programable.basic.events.LittleTriggerEventModifyHealth;
import com.alet.common.structure.type.programable.basic.events.LittleTriggerEventModifyInventory;
import com.alet.common.structure.type.programable.basic.events.LittleTriggerEventModifyMotion;
import com.alet.common.structure.type.programable.basic.events.LittleTriggerEventModifyScoreboard;
import com.alet.common.structure.type.programable.basic.events.LittleTriggerEventPlaySound;
import com.alet.common.structure.type.programable.basic.events.LittleTriggerEventSetSignal;
import com.alet.common.structure.type.programable.basic.events.LittleTriggerEventSetSpawn;
import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.creativecore.common.utils.type.PairList;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.nbt.NBTTagCompound;

public class LittleTriggerRegistrar {
    public static PairList<String, PairList<String, Class<? extends LittleTriggerObject>>> triggerableObjects = new PairList();
    public static PairList<String, PairList<String, Class<? extends LittleTriggerActivator>>> triggerActivators = new PairList();
    public static PairList<Class<? extends LittleTriggerObject>, String> names = new PairList();

    public static void registerTriggerObject(String category, String name, Class<? extends LittleTriggerObject> clazz) {
        category = "trigger.category." + category + ".name";
        PairList categoryList = (PairList)triggerableObjects.getValue((Object)category);
        if (categoryList == null) {
            categoryList = new PairList();
            triggerableObjects.add((Object)category, (Object)categoryList);
        }
        name = "trigger." + name + ".name";
        LittleTriggerRegistrar.setName(name, clazz);
        categoryList.add((Object)name, clazz);
    }

    public static void registerTriggerActivator(String category, String name, Class<? extends LittleTriggerActivator> clazz) {
        category = "trigger.category." + category + ".name";
        PairList categoryList = (PairList)triggerActivators.getValue((Object)category);
        if (categoryList == null) {
            categoryList = new PairList();
            triggerActivators.add((Object)category, (Object)categoryList);
        }
        name = "trigger." + name + ".name";
        LittleTriggerRegistrar.setName(name, clazz);
        categoryList.add((Object)name, clazz);
    }

    public static String getName(Class<? extends LittleTriggerObject> clazz) {
        return (String)names.getValue(clazz);
    }

    public static void setName(String name, Class<? extends LittleTriggerObject> clazz) {
        names.add(clazz, (Object)name);
    }

    public static Class<? extends LittleTriggerObject> getTriggerClass(String name) {
        for (Pair pair : names) {
            if (!((String)pair.getValue()).equals(name)) continue;
            return (Class)pair.key;
        }
        return null;
    }

    public static LittleTriggerActivator getTriggerActivator(Class<? extends LittleTriggerActivator> clazz) {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static LittleTriggerObject getTriggerObject(Class<? extends LittleTriggerObject> clazz, int index) {
        try {
            return clazz.getConstructor(Integer.TYPE).newInstance(index);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static LittleTriggerObject getFromNBT(NBTTagCompound nbt) {
        String trigger = "";
        if (nbt.func_74764_b("trigger")) {
            trigger = nbt.func_74779_i("trigger");
        } else if (nbt.func_74764_b("activator")) {
            trigger = nbt.func_74779_i("activator");
        }
        String[] arr = trigger.split("(?<=\\D)(?=\\d)");
        String name = arr[0];
        int index = Integer.parseInt(arr[1]);
        LittleTriggerObject event = null;
        if (nbt.func_74764_b("trigger")) {
            event = LittleTriggerRegistrar.getTriggerObject(LittleTriggerRegistrar.getTriggerClass(name), index);
        } else if (nbt.func_74764_b("activator")) {
            event = LittleTriggerRegistrar.getTriggerActivator(LittleTriggerRegistrar.getTriggerClass(name));
        }
        event.deserializeNBT(nbt);
        return event;
    }

    static {
        LittleTriggerRegistrar.registerTriggerActivator("simple", "right_click", LittleTriggerActivatorRightClick.class);
        LittleTriggerRegistrar.registerTriggerActivator("simple", "collision_tiles", LittleTriggerActivatorCollisionTiles.class);
        LittleTriggerRegistrar.registerTriggerActivator("simple", "global", LittleTriggerActivatorGlobal.class);
        LittleTriggerRegistrar.registerTriggerActivator("advanced", "collision_area", LittleTriggerActivatorCollisionArea.class);
        LittleTriggerRegistrar.registerTriggerActivator("advanced", "trigger_selector", LittleTriggerActivatorTargetSelector.class);
        LittleTriggerRegistrar.registerTriggerObject("codition", "tick_delay", LittleTriggerConditionTickDelay.class);
        LittleTriggerRegistrar.registerTriggerObject("codition", "has_item", LittleTriggerConditionHasItem.class);
        LittleTriggerRegistrar.registerTriggerObject("codition", "is_door_tick", LittleTriggerConditionDoorTick.class);
        LittleTriggerRegistrar.registerTriggerObject("codition", "successful_command", LittleTriggerConditionSuccessfulCommand.class);
        LittleTriggerRegistrar.registerTriggerObject("codition", "is_entity", LittleTriggerConditionIsEntity.class);
        LittleTriggerRegistrar.registerTriggerObject("codition", "is_signal", LittleTriggerConditionIsSignal.class);
        LittleTriggerRegistrar.registerTriggerObject("event", "modify_health", LittleTriggerEventModifyHealth.class);
        LittleTriggerRegistrar.registerTriggerObject("event", "modify_motion", LittleTriggerEventModifyMotion.class);
        LittleTriggerRegistrar.registerTriggerObject("event", "modify_inventory", LittleTriggerEventModifyInventory.class);
        LittleTriggerRegistrar.registerTriggerObject("event", "modify_scoreboard", LittleTriggerEventModifyScoreboard.class);
        LittleTriggerRegistrar.registerTriggerObject("event", "execute_command", LittleTriggerEventExecuteCommand.class);
        LittleTriggerRegistrar.registerTriggerObject("event", "set_spawn", LittleTriggerEventSetSpawn.class);
        LittleTriggerRegistrar.registerTriggerObject("event", "play_sound", LittleTriggerEventPlaySound.class);
        LittleTriggerRegistrar.registerTriggerObject("event", "set_signal", LittleTriggerEventSetSignal.class);
    }
}

