/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.structure.type.programable.basic;

import com.alet.client.gui.controls.menu.GuiMenu;
import com.alet.client.gui.controls.menu.GuiMenuPart;
import com.alet.client.gui.controls.menu.GuiPopupMenu;
import com.alet.client.gui.controls.menu.GuiTreePart;
import com.alet.common.structure.type.programable.basic.LittleTriggerObject;
import com.alet.common.structure.type.programable.basic.LittleTriggerRegistrar;
import com.alet.common.structure.type.programable.basic.activator.LittleTriggerActivator;
import com.alet.common.structure.type.programable.basic.conditions.LittleTriggerCondition;
import com.alet.common.structure.type.programable.basic.events.LittleTriggerEvent;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBoxCategory;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBoxExtensionCategory;
import com.creativemd.creativecore.common.gui.controls.gui.GuiPanel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiScrollBox;
import com.creativemd.creativecore.common.gui.event.ControlEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.creativecore.common.utils.type.PairList;
import com.creativemd.creativecore.common.world.SubWorldServer;
import com.creativemd.littletiles.client.gui.dialogs.SubGuiSignalEvents;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.animation.AnimationGuiHandler;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.registry.LittleStructureGuiParser;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.parent.IParentTileList;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleTriggerBoxStructureALET
extends LittleStructure {
    public HashSet<Entity> entities = new HashSet();
    public List<UUID> entitiesToLoad;
    public int tick = 0;
    public int currentEvent = 0;
    public boolean run = false;
    public LittleTriggerActivator triggerActivator;
    public boolean considerEventsConditions = false;
    public List<LittleTriggerObject> triggerObjs = new ArrayList<LittleTriggerObject>();

    public LittleTriggerBoxStructureALET(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock);
    }

    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("triggers", 10);
        int i = 0;
        this.triggerObjs.clear();
        for (NBTBase base : list) {
            if (!(base instanceof NBTTagCompound)) continue;
            NBTTagCompound n = (NBTTagCompound)base;
            LittleTriggerObject triggerObj = LittleTriggerRegistrar.getFromNBT((NBTTagCompound)n.func_74781_a(i + ""));
            this.triggerObjs.add(triggerObj);
            triggerObj.structure = this;
            ++i;
        }
        NBTTagList entityList = nbt.func_150295_c("entities", 8);
        this.entitiesToLoad = new ArrayList<UUID>();
        for (int j = 0; j < entityList.func_74745_c(); ++j) {
            this.entitiesToLoad.add(UUID.fromString(entityList.func_150307_f(j)));
        }
        if (nbt.func_74764_b("activator")) {
            this.triggerActivator = (LittleTriggerActivator)LittleTriggerRegistrar.getFromNBT(nbt.func_74775_l("activator"));
            this.triggerActivator.structure = this;
        }
        this.run = nbt.func_74767_n("isRunning");
        this.tick = nbt.func_74762_e("currentTick");
        this.currentEvent = nbt.func_74762_e("currentEvent");
        if (nbt.func_74764_b("consideredEventsConditions")) {
            this.considerEventsConditions = nbt.func_74767_n("consideredEventsConditions");
        }
    }

    protected void writeToNBTExtra(NBTTagCompound nbt) {
        int i = 0;
        NBTTagList list = new NBTTagList();
        for (LittleTriggerObject triggerObj : this.triggerObjs) {
            NBTTagCompound n = new NBTTagCompound();
            n.func_74782_a(i + "", (NBTBase)triggerObj.createNBT());
            list.func_74742_a((NBTBase)n);
            ++i;
        }
        NBTTagList entityList = new NBTTagList();
        if (this.entities != null && !this.entities.isEmpty()) {
            for (Entity entity : this.entities) {
                entityList.func_74742_a((NBTBase)new NBTTagString(entity.func_110124_au().toString()));
            }
        }
        if (this.triggerActivator != null) {
            nbt.func_74782_a("activator", (NBTBase)this.triggerActivator.createNBT());
        }
        nbt.func_74757_a("isRunning", this.run);
        nbt.func_74782_a("triggers", (NBTBase)list);
        nbt.func_74782_a("entities", (NBTBase)entityList);
        nbt.func_74768_a("currentTick", this.tick);
        nbt.func_74768_a("currentEvent", this.currentEvent);
        nbt.func_74757_a("consideredEventsConditions", this.considerEventsConditions);
    }

    public void onEntityCollidedWithBlock(World worldIn, IParentTileList parent, BlockPos pos, Entity entityIn) {
        if (worldIn.field_72995_K) {
            return;
        }
        boolean intersected = false;
        for (LittleTile tile : parent) {
            if (!tile.getBox().getBox(parent.getContext(), pos).func_72326_a(entityIn.func_174813_aQ())) continue;
            intersected = true;
            break;
        }
        if (intersected) {
            this.triggerActivator.onCollision(worldIn, entityIn);
        }
    }

    public void checkForAnimationCollision(EntityAnimation animation, HashMap<Entity, AxisAlignedBB> entities) throws CorruptedConnectionException, NotYetConnectedException {
        if (animation.field_70170_p.field_72995_K) {
            return;
        }
        this.triggerActivator.onCollision(animation.field_70170_p, entities.keySet());
    }

    public boolean onBlockActivated(World worldIn, LittleTile tile, BlockPos pos, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) throws LittleActionException {
        if (!this.isClient()) {
            this.triggerActivator.onRightClick(worldIn, tile, pos, playerIn, hand, heldItem, side, hitX, hitY, hitZ, action);
        }
        return true;
    }

    public void tick() {
        if (!this.isClient()) {
            World world = this.getWorld();
            if (world instanceof SubWorldServer) {
                world = ((SubWorldServer)world).getRealWorld();
            }
            WorldServer server = (WorldServer)world;
            if (this.entitiesToLoad != null) {
                Iterator<UUID> iterator = this.entitiesToLoad.iterator();
                while (iterator.hasNext()) {
                    UUID uuid = iterator.next();
                    Entity en = server.func_175733_a(uuid);
                    if (en == null) continue;
                    this.entities.add(en);
                    iterator.remove();
                }
                if (this.entitiesToLoad.isEmpty()) {
                    this.entitiesToLoad = null;
                }
            }
            this.run = this.triggerActivator.shouldRun(world, this.entities);
            if (!this.entities.isEmpty() && this.run) {
                boolean hasCondition = LittleTriggerObject.hasCondition(this.triggerObjs);
                boolean shouldContinue = true;
                boolean flag = false;
                while (this.currentEvent < this.triggerObjs.size()) {
                    LittleTriggerEvent triggerEvent;
                    boolean event;
                    LittleTriggerObject triggerObj = this.triggerObjs.get(this.currentEvent);
                    if (triggerObj instanceof LittleTriggerCondition) {
                        LittleTriggerCondition condition;
                        if (this.triggerObjs.size() > this.currentEvent && !(shouldContinue = (condition = (LittleTriggerCondition)triggerObj).conditionRunEvent()) && !condition.shouldLoop) {
                            flag = true;
                            this.entities.clear();
                        }
                    } else if (shouldContinue && triggerObj instanceof LittleTriggerEvent && !(event = (triggerEvent = (LittleTriggerEvent)triggerObj).runEvent()) && this.considerEventsConditions) {
                        this.run = false;
                        this.tick = 0;
                        this.currentEvent = 0;
                        this.entities.clear();
                        for (LittleTriggerObject triggerObj2 : this.triggerObjs) {
                            if (!(triggerObj2 instanceof LittleTriggerCondition)) continue;
                            ((LittleTriggerCondition)triggerObj2).completed = false;
                        }
                    }
                    if (!shouldContinue) break;
                    ++this.currentEvent;
                }
                this.triggerActivator.loopRules(this.entities, shouldContinue, flag);
                if (hasCondition && shouldContinue && !flag) {
                    this.getInput(0).updateState(new boolean[]{true});
                } else {
                    this.getInput(0).updateState(new boolean[]{false});
                }
                if (this.currentEvent >= this.triggerObjs.size() || flag) {
                    this.run = false;
                    this.tick = 0;
                    this.currentEvent = 0;
                    this.entities.clear();
                    for (LittleTriggerObject triggerObj : this.triggerObjs) {
                        if (!(triggerObj instanceof LittleTriggerCondition)) continue;
                        ((LittleTriggerCondition)triggerObj).completed = false;
                    }
                }
            }
        }
    }

    public static class LittleTriggerBoxStructureParser
    extends LittleStructureGuiParser {
        public List<LittleTriggerObject> triggers = new ArrayList<LittleTriggerObject>();
        LittleTriggerObject trigger = null;
        public LittlePreviews previews;
        public boolean runWhileCollided = false;
        public AxisAlignedBB collisionArea;
        public LittleTriggerActivator triggerActivator;
        public boolean consideredEventsConditions = false;

        public LittleTriggerBoxStructureParser(GuiParent parent, AnimationGuiHandler handler) {
            super(parent, handler);
        }

        @SideOnly(value=Side.CLIENT)
        public void create(LittlePreviews previews, @Nullable LittleStructure structure) {
            this.createControls(previews, structure);
            this.parent.controls.add(new SubGuiSignalEvents.GuiSignalEventsButton("signal", 0, 222, previews, structure, this.getStructureType()));
        }

        @SideOnly(value=Side.CLIENT)
        public void createControls(LittlePreviews previews, LittleStructure structure) {
            LittleTriggerBoxStructureALET triggerBox = (LittleTriggerBoxStructureALET)structure;
            this.previews = previews;
            if (triggerBox != null) {
                this.triggers = triggerBox.triggerObjs;
                this.consideredEventsConditions = triggerBox.considerEventsConditions;
                this.triggerActivator = triggerBox.triggerActivator;
            }
            GuiPanel settingsPanel = new GuiPanel("settings", 135, 50, 159, 179);
            this.parent.controls.add(settingsPanel);
            GuiPanel triggerPanel = new GuiPanel("trigger", 135, 0, 159, 43);
            this.parent.controls.add(triggerPanel);
            GuiScrollBox box = new GuiScrollBox("box", 0, 19, 127, 165);
            this.parent.controls.add(box);
            ArrayList<GuiTreePart> listOfMenus = new ArrayList<GuiTreePart>();
            GuiMenuPart moveUp = new GuiMenuPart("", "Move Up", GuiTreePart.EnumPartType.Leaf);
            GuiMenuPart moveDown = new GuiMenuPart("", "Move Down", GuiTreePart.EnumPartType.Leaf);
            GuiMenuPart delete = new GuiMenuPart("", "Delete", GuiTreePart.EnumPartType.Leaf);
            listOfMenus.add(moveUp);
            listOfMenus.add(moveDown);
            listOfMenus.add(delete);
            GuiMenu menu = new GuiMenu("", 0, 0, 60, listOfMenus);
            menu.height = 100;
            GuiPopupMenu popup = new GuiPopupMenu("popup", menu, 0, 0, 0, 0);
            box.addControl((GuiControl)popup);
            GuiComboBoxCategory<Class<? extends LittleTriggerActivator>> listActivators = new GuiComboBoxCategory<Class<? extends LittleTriggerActivator>>("activators", 0, 0, 127, LittleTriggerRegistrar.triggerActivators){

                public void setCaption(String caption) {
                    int size = -1;
                    for (PairList pair : this.elements.values()) {
                        for (Pair d : pair) {
                            String key;
                            if (!(key = this.getKeyAtIndex(++size)).equals(caption)) continue;
                            this.select(size);
                        }
                    }
                }

                public String getKeyAtIndex(int index) {
                    int currentIndex = 0;
                    if (index == -1) {
                        return "";
                    }
                    for (Pair pair : this.elements) {
                        if (index >= currentIndex + ((PairList)pair.value).size()) {
                            currentIndex += ((PairList)pair.value).size();
                            continue;
                        }
                        return (String)((Pair)((PairList)pair.value).get((int)(index - currentIndex))).key;
                    }
                    return "";
                }

                public boolean select(int index) {
                    int currentIndex = 0;
                    if (index == -1) {
                        return false;
                    }
                    for (Pair pair : this.elements) {
                        if (index >= currentIndex + ((PairList)pair.value).size()) {
                            currentIndex += ((PairList)pair.value).size();
                            continue;
                        }
                        this.caption = 1.translate((String)((String)((Pair)((PairList)pair.value).get((int)(index - currentIndex))).key));
                        this.index = index;
                        this.raiseEvent((ControlEvent)new GuiControlChangedEvent((GuiControl)this));
                        return true;
                    }
                    return false;
                }

                protected GuiComboBoxExtensionCategory<Class<? extends LittleTriggerActivator>> createBox() {
                    return new GuiComboBoxExtensionCategory(this.name + "extension", (GuiComboBoxCategory)this, this.posX, this.posY + this.height, 133 - this.getContentOffset() * 2, 100);
                }
            };
            if (this.triggerActivator == null) {
                this.createActivator((Class)listActivators.getSelected().value);
            }
            if (this.triggerActivator != null) {
                listActivators.setCaption(this.triggerActivator.getName());
                this.updateActivatorControls();
            }
            this.parent.addControl((GuiControl)listActivators);
            GuiComboBoxCategory<Class<? extends LittleTriggerObject>> list = new GuiComboBoxCategory<Class<? extends LittleTriggerObject>>("list", 0, 189, 100, LittleTriggerRegistrar.triggerableObjects){

                protected GuiComboBoxExtensionCategory<Class<? extends LittleTriggerObject>> createBox() {
                    return new GuiComboBoxExtensionCategory(this.name + "extension", (GuiComboBoxCategory)this, this.posX, this.posY + this.height, 133 - this.getContentOffset() * 2, 100);
                }
            };
            list.height = 19;
            this.parent.controls.add(list);
            GuiTriggerBoxAddButton add = new GuiTriggerBoxAddButton(this, "Add", 105, 189, 22);
            add.height = 19;
            this.parent.addControl((GuiControl)add);
            if (this.triggers != null && !this.triggers.isEmpty()) {
                for (int i = 0; i < this.triggers.size(); ++i) {
                    box.addControl((GuiControl)new GuiTriggerEventButton(this.triggers.get(i).getName() + i, I18n.func_74838_a((String)this.triggers.get(i).getName()), 0, i * 17, 119, 12));
                }
            }
            this.parent.addControl((GuiControl)new GuiCheckBox("consider", "Make Events Conditional", 0, 208, this.consideredEventsConditions));
        }

        @SideOnly(value=Side.CLIENT)
        public LittleTriggerBoxStructureALET parseStructure(LittlePreviews previews) {
            LittleTriggerBoxStructureALET structure = (LittleTriggerBoxStructureALET)this.createStructure(LittleTriggerBoxStructureALET.class, null);
            structure.triggerObjs = this.triggers;
            structure.triggerActivator = this.triggerActivator;
            structure.considerEventsConditions = this.consideredEventsConditions;
            return structure;
        }

        @SideOnly(value=Side.CLIENT)
        protected LittleStructureType getStructureType() {
            return LittleStructureRegistry.getStructureType(LittleTriggerBoxStructureALET.class);
        }

        public void moveTriggerOnList(int distance) {
            int z = 0;
            LittleTriggerObject triggerObj = null;
            for (int i = 0; i < this.triggers.size(); ++i) {
                triggerObj = this.triggers.get(i);
                String triggerName = triggerObj.getName() + triggerObj.id;
                if (!triggerName.equals(this.trigger.getName() + this.trigger.id)) continue;
                z = i;
                break;
            }
            if (triggerObj != null && z + distance > -1 && z + distance < this.triggers.size()) {
                Collections.swap(this.triggers, z, z + distance);
                this.updateList();
            }
        }

        public void createActivator(Class<? extends LittleTriggerActivator> clazz) {
            this.triggerActivator = LittleTriggerRegistrar.getTriggerActivator(clazz);
        }

        public void createActivatorGui() {
            GuiPanel panel = this.triggerActivator.getPanel(this.parent);
            LittleTriggerObject.wipeControls((GuiParent)panel);
            this.triggerActivator.createGuiControls(panel, this.previews);
        }

        @CustomEventSubscribe
        public void onControlChanged(GuiControlChangedEvent event) {
            if (event.source.is(new String[]{"while_collided"})) {
                this.runWhileCollided = ((GuiCheckBox)event.source).value;
            } else if (event.source.is(new String[]{"consider"})) {
                this.consideredEventsConditions = ((GuiCheckBox)event.source).value;
            } else if (event.source.is(new String[]{"activators"})) {
                GuiComboBoxCategory listActivators = (GuiComboBoxCategory)event.source;
                this.createActivator((Class)listActivators.getSelected().value);
                this.createActivatorGui();
            } else if (event.source instanceof GuiMenuPart) {
                String caption = ((GuiMenuPart)event.source).caption;
                if (caption.equals("Move Up")) {
                    this.moveTriggerOnList(-1);
                } else if (caption.equals("Move Down")) {
                    this.moveTriggerOnList(1);
                } else if (caption.equals("Delete")) {
                    int z = 0;
                    for (int i = 0; i < this.triggers.size(); ++i) {
                        LittleTriggerObject triggerObj = this.triggers.get(i);
                        String triggerName = triggerObj.getName() + triggerObj.id;
                        if (!triggerName.equals(this.trigger.getName() + this.trigger.id)) continue;
                        z = i;
                        break;
                    }
                    this.triggers.remove(z);
                    this.updateList();
                }
            }
            if (this.trigger != null) {
                this.trigger.guiChangedEvent(event.source);
            }
            if (this.triggerActivator != null) {
                this.triggerActivator.guiChangedEvent(event.source);
            }
        }

        public void updateList() {
            GuiScrollBox box = (GuiScrollBox)this.parent.get("box");
            GuiPanel panel = (GuiPanel)this.parent.get("settings");
            box.removeControls(new String[]{"popup"});
            LittleTriggerObject.wipeControls((GuiParent)panel);
            for (int i = 0; i < this.triggers.size(); ++i) {
                LittleTriggerObject triggerObj = this.triggers.get(i);
                triggerObj.id = i;
                box.addControl((GuiControl)new GuiTriggerEventButton(triggerObj.getName() + i, I18n.func_74838_a((String)triggerObj.getName()), 0, i * 17, 119, 12));
            }
        }

        public void updateActivatorControls() {
            if (this.triggerActivator != null) {
                GuiPanel panel = this.triggerActivator.getPanel(this.parent);
                LittleTriggerObject.wipeControls((GuiParent)panel);
                this.triggerActivator.createGuiControls(panel, this.previews);
            }
        }

        public void updateObjectControls(String name) {
            for (LittleTriggerObject triggerObj : this.triggers) {
                String objName = triggerObj.getName() + triggerObj.id;
                if (!objName.equals(name)) continue;
                this.trigger = triggerObj;
                break;
            }
            if (this.trigger != null) {
                GuiPanel panel = this.trigger.getPanel(this.parent);
                LittleTriggerObject.wipeControls((GuiParent)panel);
                this.trigger.createGuiControls(panel, this.previews);
            }
        }

        public class GuiTriggerBoxAddButton
        extends GuiButton {
            public GuiTriggerBoxAddButton(LittleTriggerBoxStructureParser parser, String caption, int x, int y, int width) {
                super(caption, x, y, width);
            }

            public void onClicked(int x, int y, int button) {
                GuiScrollBox box = (GuiScrollBox)this.getGui().get("box");
                GuiComboBoxCategory list = (GuiComboBoxCategory)this.getGui().get("list");
                int i = LittleTriggerBoxStructureParser.this.triggers.size();
                LittleTriggerBoxStructureParser.this.triggers.add(LittleTriggerRegistrar.getTriggerObject((Class)list.getSelected().value, i));
                GuiTriggerEventButton bu = new GuiTriggerEventButton((String)list.getSelected().key + i, list.getCaption(), 0, i * 17, 119, 12);
                box.addControl((GuiControl)bu);
            }
        }

        public class GuiTriggerEventButton
        extends GuiButton {
            public GuiTriggerEventButton(String name, String caption, int x, int y, int width, int height) {
                super(name, caption, x, y, width, height);
            }

            public void onClicked(int x, int y, int button) {
                GuiScrollBox box = (GuiScrollBox)this.getGui().get("box");
                if (button == 0 || button == 1) {
                    for (GuiControl gui : box.controls) {
                        if (!(gui instanceof GuiTriggerEventButton)) continue;
                        GuiButton b = (GuiButton)gui;
                        b.color = -1;
                    }
                    this.color = -256;
                    LittleTriggerBoxStructureParser.this.updateObjectControls(this.name);
                }
            }

            public boolean hasBorder() {
                return false;
            }
        }
    }
}

