/*
 * Decompiled with CFR 0.152.
 */
package com.alet.common.structure.type.programable.advanced;

import com.alet.client.gui.controls.menu.GuiTreePart;
import com.alet.client.gui.controls.menu.GuiTreePartHolder;
import com.alet.client.gui.controls.programmable.functions.GuiFunction;
import com.alet.common.structure.type.programable.advanced.Function;
import com.alet.common.structure.type.programable.advanced.activators.FunctionOnRightClick;
import com.alet.common.structure.type.programable.advanced.events.FunctionDebugMessage;
import com.alet.common.structure.type.programable.advanced.flows.FunctionForLoop;
import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.creativecore.common.utils.type.PairList;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.translation.I18n;

public class FunctionRegistar {
    public static PairList<String, PairList<String, GuiFunction>> guiFunctions = new PairList();
    public static PairList<String, Class<? extends Function>> functions = new PairList();

    public static void registerFunctions() {
        FunctionRegistar.registerFunction("activator", new FunctionOnRightClick(0));
        FunctionRegistar.registerFunction("flow_control", new FunctionForLoop(0));
        FunctionRegistar.registerFunction("event", new FunctionDebugMessage(0));
    }

    public static void registerFunction(String category, Function function) {
        category = "programmable.advanced.category." + category + ".name";
        PairList categoryList = (PairList)guiFunctions.getValue((Object)category);
        if (categoryList == null) {
            categoryList = new PairList();
        }
        guiFunctions.add((Object)category, (Object)categoryList);
        String name = function.getName();
        name = "programmable.advanced." + name + ".name";
        categoryList.add((Object)name, (Object)new GuiFunction(name, FunctionRegistar.getTranslatedName(name), function.getColor(), function.isMethodSender(), function.isMethodReciever(), function.setGuiNodes()));
        functions.add(new Pair((Object)function.getName(), function.getClass()));
    }

    public static Function getFunctionFromGui(GuiFunction guiFunction) {
        try {
            Function function = (Function)((Class)functions.getValue((Object)guiFunction.name)).getConstructor(Integer.TYPE).newInstance(guiFunction.id);
            return function;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getTranslatedName(String name) {
        return I18n.func_74838_a((String)name);
    }

    public static List<GuiTreePart> treeList() {
        ArrayList<GuiTreePart> treeList = new ArrayList<GuiTreePart>();
        for (Pair headerPair : guiFunctions) {
            GuiTreePart header = new GuiTreePart(FunctionRegistar.getTranslatedName((String)headerPair.key), GuiTreePart.EnumPartType.Branch);
            for (Pair pair : (PairList)headerPair.value) {
                header.addMenu(new GuiTreePartHolder<String>((String)pair.key, FunctionRegistar.getTranslatedName((String)pair.key), GuiTreePart.EnumPartType.Leaf, ((GuiFunction)((Object)pair.value)).FUNCTION_TITLE));
            }
            treeList.add(header);
        }
        return treeList;
    }

    public static GuiFunction createFunctionGui(String name, boolean translate, int id) {
        for (Pair mainPair : guiFunctions) {
            for (Pair pair : (PairList)mainPair.value) {
                System.out.println(((String)pair.key).equals(name));
                if (!(translate ? FunctionRegistar.getTranslatedName((String)pair.key).equals(name) : ((String)pair.key).equals(name))) continue;
                return ((GuiFunction)((Object)pair.value)).clone(id);
            }
        }
        return null;
    }
}

